/* $Id: ASNInteger.java,v 1.2 2000/01/20 14:59:38 gelderen Exp $
 *
 * Copyright (C) 2000 The Cryptix Foundation Limited.
 * All rights reserved.
 *
 * Use, modification, copying and distribution of this software is subject
 * the terms and conditions of the Cryptix General Licence. You should have
 * received a copy of the Cryptix General Licence along with this library;
 * if not, you can download a copy from http://www.cryptix.org/ .
 */
package cryptix.jce.util.der;


import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;


/**
 * @version $Revision: 1.2 $
 * @author  Jeroen C. van Gelderen (gelderen@cryptix.org)
 */
public final class ASNInteger
extends ASNObject
{

// Instance variables
//...........................................................................

    private final BigInteger bi;
    

// Constructors
//...........................................................................

    public ASNInteger(BigInteger bi)
    {
        this.bi = bi;
    }


// Concreteness
//...........................................................................
    
    /*package*/ void write(DEROutputStream os) throws IOException
    {
        byte[] biBytes = this.bi.toByteArray();
        os.writeType(INTEGER);
        os.writeLength(biBytes.length);
        os.writeBytes(biBytes);
    }
    
    
    /*package*/ int getEncodedLength()
    {
        byte[] biBytes = this.bi.toByteArray();
        
        // lengt of data + len of length field + 1 byte for type field
        return biBytes.length + getLengthOfEncodedLength(biBytes.length) + 1;
    }
}
