/* $Id: TestTiger.java,v 1.3 2000/01/20 14:59:35 gelderen Exp $
 *
 * Copyright (C) 2000 The Cryptix Foundation Limited.
 * All rights reserved.
 *
 * Use, modification, copying and distribution of this software is subject
 * the terms and conditions of the Cryptix General Licence. You should have
 * received a copy of the Cryptix General Licence along with this library;
 * if not, you can download a copy from http://www.cryptix.org/ .
 */
package cryptix.jce.test;


final class TestTiger
extends MessageDigestTest
{
    private static final String NAME="Tiger";

    String[][] TEST_VALUES =
    {
        //    data, md
        //  ......................
        {"",               "24F0130C63AC933216166E76B1BB925FF373DE2D49584E7A"},
        {"abc",            "F258C1E88414AB2A527AB541FFC5B8BF935F7B951C132951"},
        {"Tiger",          "9F00F599072300DD276ABB38C8EB6DEC37790C116F9D2BDF"},
        {"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+-",
                           "87FB2A9083851CF7470D2CF810E6DF9EB586445034A5A386"},
        {"ABCDEFGHIJKLMNOPQRSTUVWXYZ=abcdefghijklmnopqrstuvwxyz+0123456789",
                           "467DB80863EBCE488DF1CD1261655DE957896565975F9197"},
        {"Tiger - A Fast New Hash Function, by Ross Anderson and Eli Biham",
                           "0C410A042968868A1671DA5A3FD29A725EC1E457D3CDB303"},
        {"Tiger - A Fast New Hash Function, by Ross Anderson and Eli Biham, " +
         "proceedings of Fast Software Encryption 3, Cambridge.",
                           "EBF591D5AFA655CE7F22894FF87F54AC89C811B6B0DA3193"},
        {"Tiger - A Fast New Hash Function, by Ross Anderson and Eli Biham, " +
         "proceedings of Fast Software Encryption 3, Cambridge, 1996.",
                           "3D9AEB03D1BD1A6357B2774DFD6D5B24DD68151D503974FC"},
        {"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+-" +
         "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+-",
                           "00B83EB4E53440C576AC6AAEE0A7485825FD15E70A59FFE4"}
    };


    protected TestTiger()
    {
        super(NAME);
    }


    protected void doIt()
    throws Exception
    {
        java.security.Security.addProvider(new cryptix.jce.provider.Cryptix());

        testExistence(NAME);
        testValues(NAME, TEST_VALUES);
        //testCloning(NAME);
    }
}