/* $Id: TestRC6.java,v 1.1 2000/02/10 05:30:58 gelderen Exp $
 *
 * Copyright (C) 1995-1999 The Cryptix Foundation Limited.
 * All rights reserved.
 *
 * Use, modification, copying and distribution of this software is subject
 * the terms and conditions of the Cryptix General Licence. You should have
 * received a copy of the Cryptix General Licence along with this library;
 * if not, you can download a copy from http://www.cryptix.org/ .
 */
package cryptix.jce.test;


final class TestRC6
extends CipherTest
{
    private static final String NAME="RC6";


    //
    // Test Values taken from the Twofish AES Submission Package
    //
    private static final String[][] TEST_VALUES =
    {
        // Variable Key Known Answer Tests (128-bit key)
        {"00000000000000000000000000000000", 
         "00000000000000000000000000000000", 
         "8fc3a53656b1f778c129df4e9848a41e"},
    };


    protected TestRC6()
    {
        super(NAME);
    }


    protected void doIt()
    throws Exception
    {
        java.security.Security.addProvider(new cryptix.jce.provider.Cryptix());

        testCipher(TEST_VALUES);
    }
}


/*
    Test vectors: KEYs
    private static final byte[][] KEY = {
      { (byte)0x00, (byte)0x00, (byte)0x00, (byte)0x00,
        (byte)0x00, (byte)0x00, (byte)0x00, (byte)0x00,
        (byte)0x00, (byte)0x00, (byte)0x00, (byte)0x00,
        (byte)0x00, (byte)0x00, (byte)0x00, (byte)0x00 },
      { (byte)0x01, (byte)0x23, (byte)0x45, (byte)0x67,
        (byte)0x89, (byte)0xab, (byte)0xcd, (byte)0xef,
        (byte)0x01, (byte)0x12, (byte)0x23, (byte)0x34,
        (byte)0x45, (byte)0x56, (byte)0x67, (byte)0x78 },
      { (byte)0x00, (byte)0x00, (byte)0x00, (byte)0x00,
        (byte)0x00, (byte)0x00, (byte)0x00, (byte)0x00,
        (byte)0x00, (byte)0x00, (byte)0x00, (byte)0x00,
        (byte)0x00, (byte)0x00, (byte)0x00, (byte)0x00,
        (byte)0x00, (byte)0x00, (byte)0x00, (byte)0x00,
        (byte)0x00, (byte)0x00, (byte)0x00, (byte)0x00 },
      { (byte)0x01, (byte)0x23, (byte)0x45, (byte)0x67,
        (byte)0x89, (byte)0xab, (byte)0xcd, (byte)0xef,
        (byte)0x01, (byte)0x12, (byte)0x23, (byte)0x34,
        (byte)0x45, (byte)0x56, (byte)0x67, (byte)0x78,
        (byte)0x89, (byte)0x9a, (byte)0xab, (byte)0xbc,
        (byte)0xcd, (byte)0xde, (byte)0xef, (byte)0xf0 },
      { (byte)0x00, (byte)0x00, (byte)0x00, (byte)0x00,
        (byte)0x00, (byte)0x00, (byte)0x00, (byte)0x00,
        (byte)0x00, (byte)0x00, (byte)0x00, (byte)0x00,
        (byte)0x00, (byte)0x00, (byte)0x00, (byte)0x00,
        (byte)0x00, (byte)0x00, (byte)0x00, (byte)0x00,
        (byte)0x00, (byte)0x00, (byte)0x00, (byte)0x00,
        (byte)0x00, (byte)0x00, (byte)0x00, (byte)0x00,
        (byte)0x00, (byte)0x00, (byte)0x00, (byte)0x00 },
      { (byte)0x01, (byte)0x23, (byte)0x45, (byte)0x67,
        (byte)0x89, (byte)0xab, (byte)0xcd, (byte)0xef,
        (byte)0x01, (byte)0x12, (byte)0x23, (byte)0x34,
        (byte)0x45, (byte)0x56, (byte)0x67, (byte)0x78,
        (byte)0x89, (byte)0x9a, (byte)0xab, (byte)0xbc,
        (byte)0xcd, (byte)0xde, (byte)0xef, (byte)0xf0,
        (byte)0x10, (byte)0x32, (byte)0x54, (byte)0x76,
        (byte)0x98, (byte)0xba, (byte)0xdc, (byte)0xfe }
    };


    Test vectors: PlainTexts 
    private static final byte[][] PT = {
      { (byte)0x00, (byte)0x00, (byte)0x00, (byte)0x00,
        (byte)0x00, (byte)0x00, (byte)0x00, (byte)0x00,
        (byte)0x00, (byte)0x00, (byte)0x00, (byte)0x00,
        (byte)0x00, (byte)0x00, (byte)0x00, (byte)0x00 },
      { (byte)0x02, (byte)0x13, (byte)0x24, (byte)0x35,
        (byte)0x46, (byte)0x57, (byte)0x68, (byte)0x79,
        (byte)0x8a, (byte)0x9b, (byte)0xac, (byte)0xbd,
        (byte)0xce, (byte)0xdf, (byte)0xe0, (byte)0xf1 },
      { (byte)0x00, (byte)0x00, (byte)0x00, (byte)0x00,
        (byte)0x00, (byte)0x00, (byte)0x00, (byte)0x00,
        (byte)0x00, (byte)0x00, (byte)0x00, (byte)0x00,
        (byte)0x00, (byte)0x00, (byte)0x00, (byte)0x00 },
      { (byte)0x02, (byte)0x13, (byte)0x24, (byte)0x35,
        (byte)0x46, (byte)0x57, (byte)0x68, (byte)0x79,
        (byte)0x8a, (byte)0x9b, (byte)0xac, (byte)0xbd,
        (byte)0xce, (byte)0xdf, (byte)0xe0, (byte)0xf1 },
      { (byte)0x00, (byte)0x00, (byte)0x00, (byte)0x00,
        (byte)0x00, (byte)0x00, (byte)0x00, (byte)0x00,
        (byte)0x00, (byte)0x00, (byte)0x00, (byte)0x00,
        (byte)0x00, (byte)0x00, (byte)0x00, (byte)0x00 },
      { (byte)0x02, (byte)0x13, (byte)0x24, (byte)0x35,
        (byte)0x46, (byte)0x57, (byte)0x68, (byte)0x79,
        (byte)0x8a, (byte)0x9b, (byte)0xac, (byte)0xbd,
        (byte)0xce, (byte)0xdf, (byte)0xe0, (byte)0xf1 }
    };


    Test vectors: CipherTexts
    private static final byte[][] CT = {
      { (byte)0x8f, (byte)0xc3, (byte)0xa5, (byte)0x36,
        (byte)0x56, (byte)0xb1, (byte)0xf7, (byte)0x78,
        (byte)0xc1, (byte)0x29, (byte)0xdf, (byte)0x4e,
        (byte)0x98, (byte)0x48, (byte)0xa4, (byte)0x1e },
      { (byte)0x52, (byte)0x4e, (byte)0x19, (byte)0x2f,
        (byte)0x47, (byte)0x15, (byte)0xc6, (byte)0x23,
        (byte)0x1f, (byte)0x51, (byte)0xf6, (byte)0x36,
        (byte)0x7e, (byte)0xa4, (byte)0x3f, (byte)0x18 },
      { (byte)0x6c, (byte)0xd6, (byte)0x1b, (byte)0xcb,
        (byte)0x19, (byte)0x0b, (byte)0x30, (byte)0x38,
        (byte)0x4e, (byte)0x8a, (byte)0x3f, (byte)0x16,
        (byte)0x86, (byte)0x90, (byte)0xae, (byte)0x82 },
      { (byte)0x68, (byte)0x83, (byte)0x29, (byte)0xd0,
        (byte)0x19, (byte)0xe5, (byte)0x05, (byte)0x04,
        (byte)0x1e, (byte)0x52, (byte)0xe9, (byte)0x2a,
        (byte)0xf9, (byte)0x52, (byte)0x91, (byte)0xd4 },
      { (byte)0x8f, (byte)0x5f, (byte)0xbd, (byte)0x05,
        (byte)0x10, (byte)0xd1, (byte)0x5f, (byte)0xa8,
        (byte)0x93, (byte)0xfa, (byte)0x3f, (byte)0xda,
        (byte)0x6e, (byte)0x85, (byte)0x7e, (byte)0xc2 },
      { (byte)0xc8, (byte)0x24, (byte)0x18, (byte)0x16,
        (byte)0xf0, (byte)0xd7, (byte)0xe4, (byte)0x89,
        (byte)0x20, (byte)0xad, (byte)0x16, (byte)0xa1,
        (byte)0x67, (byte)0x4e, (byte)0x5d, (byte)0x48 }
    };
*/


/*
 * ORIGINAL LICENSE
 *
 * Jeroen C. van Gelderen wrote this file.  As long as you retain this notice
 * you can do whatever you want with this stuff. If we meet some day, and you
 * think this stuff is worth it, you can buy me a beer in return.
 *                            Jeroen C. van Gelderen <jeroen@vangelderen.org>
 */