/* $Id: RSAPublicKeyX509.java,v 1.2 2000/01/20 14:59:33 gelderen Exp $
 *
 * Copyright (C) 2000 The Cryptix Foundation Limited.
 * All rights reserved.
 *
 * Use, modification, copying and distribution of this software is subject
 * the terms and conditions of the Cryptix General Licence. You should have
 * received a copy of the Cryptix General Licence along with this library;
 * if not, you can download a copy from http://www.cryptix.org/ .
 */
package cryptix.jce.provider.rsa;


import cryptix.jce.util.der.*;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.interfaces.RSAPublicKey;


/**
 * @version $Revision: 1.2 $
 * @author  Jeroen C. van Gelderen (gelderen@cryptix.org)
 */
/*package*/ final class RSAPublicKeyX509
implements RSAPublicKey
{
    private final BigInteger n, e;


    /*package*/ RSAPublicKeyX509(BigInteger n, BigInteger e)
    {
        this.n = n;
        this.e = e;
    }


    public BigInteger getModulus()
    {
        return this.n;
    }


    public BigInteger getPublicExponent()
    {
        return this.e;
    }


// Implementation of Key interface
//...........................................................................

    public String getAlgorithm()
    {
        return "RSA";
    }


    public String getFormat()
    {
        return "X.509";
    }


    public byte[] getEncoded()
    {
        /*
         * SubjectPublicKeyInfo ::= SEQUENCE {
         *     algorithm AlgorithmIdentifier,
         *     subjectPublicKey BIT STRING
         * }
         *
         * AlgorithmIdentifier ::= SEQUENCE {
         *     algorithm OBJECT IDENTIFIER,
         *     parameters ANY DEFINED BY algorithm OPTIONAL
         * }
         *
         * PKCS#1 defines;
         *
         * rsaEncryption OBJECT IDENTIFIER ::=  { 1 2 840 113549 1 1 1 }
         *
         * RSAPublicKey ::= SEQUENCE {
         *  modulus INTEGER, -- n
         *  publicExponent INTEGER -- e
         * }
         */

        ASNObject[] spkData = { new ASNInteger(this.n),new ASNInteger(this.e) };
        ASNBitString subjectPublicKey =
            new ASNBitString( new ASNSequence(spkData) );

        ASNObject[] algData = { ASNObjectIdentifier.RSA };
        ASNSequence algorithm = new ASNSequence(algData);

        ASNObject[] spkiData = { algorithm, subjectPublicKey };
        ASNSequence subjectPublicKeyInfo = new ASNSequence( spkiData );

        try
        {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DEROutputStream       dos  = new DEROutputStream(baos);
            dos.write(subjectPublicKeyInfo);
            dos.flush();
            dos.close();
            return baos.toByteArray();
        }
        catch(IOException e)
        {
            throw new RuntimeException("PANIC");
        }
    }
}
