/* $Id: RSAAlgorithm.java,v 1.4 2000/01/20 14:59:33 gelderen Exp $
 *
 * Copyright (C) 1995-1999 The Cryptix Foundation Limited.
 * All rights reserved.
 *
 * Use, modification, copying and distribution of this software is subject
 * the terms and conditions of the Cryptix General Licence. You should have
 * received a copy of the Cryptix General Licence along with this library;
 * if not, you can download a copy from http://www.cryptix.org/ .
 */
package cryptix.jce.provider.rsa;


import cryptix.jce.util.Util;

import java.math.BigInteger;

import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;

import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;

import java.security.spec.AlgorithmParameterSpec;

import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;


/**
 * @author Jeroen C. van Gelderen (gelderen@cryptix.org)
 */
public final class RSACipher_ECB_PKCS1 extends CipherSpi
{

// ..........................................................................

    private byte[] buf;
    private int bufOffset;
    private int bufSize;
    
    
    /**
     * Size of the RSA modulus (n), rounded up to the nearest 
     * multiple of bytes.
     */
    private int modulusSize;
    
    
    /** RSA modulus (n) and exponent (e or d). */
    private BigInteger n, c;
    
    
    private SecureRandom random;
    
    private static final int 
        UNITIALIZED = Cipher.ENCRYPT_MODE ^ Cipher.DECRYPT_MODE;

    private int mode = UNITIALIZED;


// Constructor
// ..........................................................................
    
    public RSACipher_ECB_PKCS1()
    {
        super();
    }
   

// ..........................................................................
    
    
    protected void engineSetMode(String mode)
    throws NoSuchAlgorithmException
    {
        if( !mode.equalsIgnoreCase("ECB") )
            throw new NoSuchAlgorithmException("Only ECB is supported.");
    }
    
    
    protected void engineSetPadding(String padding)
    throws NoSuchPaddingException
    {
        if( !padding.equalsIgnoreCase("PKCS#1") )
            throw new NoSuchPaddingException("Only PKCS#1 is supported.");
    }
    
    
    /**
	 * Get the block size. Size of key minus padding bytes for encryption,
	 * size of key for decryption.
	 */
    protected int engineGetBlockSize()
    {
        return this.bufSize;
    }
    
    
    /**
     * Returns max output buffer size required for next update or doFinal.
     */
    protected int engineGetOutputSize(int inputLen)
    {
        if( this.mode == UNITIALIZED )
            throw new IllegalStateException();
            
        int bufLeft = this.bufSize - this.bufOffset;
        throw new RuntimeException("NYI");
    }
    
    
    protected byte[] engineGetIV()
    {
        // ECB mode doesn't have an IV
        return null;
    }
    
    
    protected AlgorithmParameters engineGetParameters()
    {
        throw new RuntimeException("NYI");
    }
    
    
    protected void engineInit(int opmode, Key key, SecureRandom random)
    throws InvalidKeyException
    {
        // ASSERT( random != null);
        
        switch(opmode)
        {
        case Cipher.ENCRYPT_MODE:
            if( !(key instanceof RSAPublicKey) )
                throw new InvalidKeyException("key: not an RSAPublicKey");
                
            RSAPublicKey pub = (RSAPublicKey)key;
            this.n = pub.getModulus();
            this.c = pub.getPublicExponent();
            break;
                
        case Cipher.DECRYPT_MODE:
            if( !(key instanceof RSAPrivateKey) )
                throw new InvalidKeyException("key: not an RSAPrivateKey");

            RSAPrivateKey priv = (RSAPrivateKey)key;
            this.n = priv.getModulus();
            this.c = priv.getPrivateExponent();
            break;
                
        default:
            throw new IllegalArgumentException("opmode: " + opmode);
        }
        
        this.modulusSize = (this.n.bitLength() + 7) / 8;
        this.random = random;   
    }
    
    
    protected void engineInit(int opmode, Key key, 
                              AlgorithmParameterSpec params, 
                              SecureRandom random)
    throws InvalidKeyException, InvalidAlgorithmParameterException
    {
        throw new RuntimeException("NYI");
    }


    protected void engineInit(int opmode, Key key, AlgorithmParameters params,
                              SecureRandom random)
    throws InvalidKeyException, InvalidAlgorithmParameterException
    {
        throw new RuntimeException("NYI");
    }

    
    protected byte[] engineUpdate(byte[] input, int inputOffset, int inputLen)
    {
        if( this.mode == UNITIALIZED )
            throw new IllegalStateException();
            
        byte[] out = new byte[getUpdateOutputSize(inputLen)];
        update(input, inputOffset, inputLen, out, 0);
        return out;
    }
    
    
    protected int engineUpdate(byte[] input, int inputOffset, int inputLen,
                               byte[] output, int outputOffset)
    throws ShortBufferException
    {
        if( this.mode == UNITIALIZED )
            throw new IllegalStateException();

        int lengthRequired = getUpdateOutputSize(inputLen);
        if( (output.length - outputOffset) < lengthRequired )
            throw new ShortBufferException(lengthRequired + "bytes needed");
            
        return update(input, inputOffset, inputLen, output, outputOffset);
    }
    

    protected byte[] engineDoFinal(byte[] input, int inputOffset, int inputLen)
    throws IllegalBlockSizeException, BadPaddingException
    {
        if( this.mode == UNITIALIZED )
            throw new IllegalStateException();

        throw new RuntimeException("NYI");
    }
    
    
    protected int engineDoFinal(byte[] input, int inputOffset, int inputLen,
                                byte[] output, int outputOffset)
    throws ShortBufferException, IllegalBlockSizeException, BadPaddingException
    {
        if( this.mode == UNITIALIZED )
            throw new IllegalStateException();

        throw new RuntimeException("NYI");
    }


// ..........................................................................

    private int getUpdateOutputSize(int inputLen)
    {
        throw new RuntimeException("NYI");
    }

    
    /*
     * This methods expects only valid parameters, no sanity checking is done.
     */
    private int update(byte[] input, int inputOffset, int inputLen,
                       byte[] output, int outputOffset)
    {
        int todo;
        while( (todo = this.bufSize - this.bufOffset) <= inputLen )
        {
            System.arraycopy(input, inputOffset, 
                             this.buf, this.bufOffset, todo);

            if( this.mode == Cipher.ENCRYPT_MODE )
            {
                byte[] padded = 
                    PaddingPKCS1.pad(this.buf, this.modulusSize, this.random);
                    
                BigInteger res = 
                    RSAAlgorithm.rsa(new BigInteger(padded), this.n, this.c);

                byte[] resBytes = Util.toByteArray(res, this.modulusSize);
                
                System.arraycopy(resBytes, 0, 
                                 output, outputOffset, resBytes.length);
                                 
                outputOffset += resBytes.length;
            }
            else
            {
                throw new RuntimeException("NYI");
            }
            
            inputLen       -= todo;
            inputOffset    += todo;
            this.bufOffset  = 0;
        }
        
        System.arraycopy(input, inputOffset, 
                         this.buf, this.bufOffset, inputLen);
        this.bufOffset = 0;
        
        throw new RuntimeException();
    }

}
