/* $Id: RSAAlgorithm.java,v 1.4 2000/01/20 14:59:33 gelderen Exp $
 *
 * Copyright (C) 1995-1999 The Cryptix Foundation Limited.
 * All rights reserved.
 *
 * Use, modification, copying and distribution of this software is subject
 * the terms and conditions of the Cryptix General Licence. You should have
 * received a copy of the Cryptix General Licence along with this library;
 * if not, you can download a copy from http://www.cryptix.org/ .
 */
package cryptix.jce.provider.rsa;


import java.security.SecureRandom;
import javax.crypto.BadPaddingException;


/*package*/ final class PaddingPKCS1
{
    private static final int MIN_PADDING_SIZE = 2 + 8 + 1;
    
    /*package*/ static byte[] pad(byte[] unpaddedBytes, int outLen, 
                                  SecureRandom random)
    {
        int unpaddedBytesLen = unpaddedBytes.length;
        
        if( (unpaddedBytesLen + MIN_PADDING_SIZE) > outLen )
            throw new IllegalArgumentException();
        
        byte[] out = new byte[outLen];
        random.nextBytes(out);
        //for(int i=0; i<out.length; i++) out[i] = 0x00;
        
        out[0] = 0x00;
        out[1] = 0x02;
        
        int i;
        for(i=2; i<outLen-unpaddedBytesLen-1; i++)
            if( out[i] == 0x00 ) out[i] = 0x01; // this shouldn't hurt
        
        out[i] = 0x00;

        System.arraycopy(unpaddedBytes, 0, 
                         out, outLen-unpaddedBytesLen, unpaddedBytesLen);

        return out;
    }
    
    
    /*package*/ /*static int pad(byte[] unpaddedBytes, 
                               byte[] out, int outOff, int outLen, 
                               SecureRandom random)
    {
        byte[] tmp = pad(unpaddedBytes, outLen, random);
        System.arraycopy(tmp, 0, out, outOff, outLen);
        return tmp.length;
    }*/
    
    
    /*package*/ static byte[] unpad(byte[] paddedBytes)
    throws BadPaddingException
    {
        int paddedBytesLen = paddedBytes.length;
        if(paddedBytesLen < MIN_PADDING_SIZE) 
            throw new BadPaddingException();
        
        if( (paddedBytes[0] != 0x00) || (paddedBytes[1] != 0x02) )
            throw new BadPaddingException();
        
        int i;
        for(i=2; i<paddedBytesLen; i++)
            if( paddedBytes[i] == 0x00 ) break;
            
        if( paddedBytes[i] != 0x00 )
            throw new BadPaddingException();
        
        int    unpaddedLen = paddedBytesLen - i - 1;
        byte[] unpadded    = new byte[unpaddedLen];
        System.arraycopy(paddedBytes, i+1, unpadded, 0, unpaddedLen);
        return unpadded;
    }


    public static void main(String[] argv)
    {
        while(true)
            doIt();
    }
    
    private static void doIt()
    {
        try
        {
            byte[] unpadded = new byte[0];
            for(int i=0; i<unpadded.length; i++)
                unpadded[i] = (byte)(i+1);
            
            byte[] padded = pad(unpadded, 35, new SecureRandom());
            for(int i=0; i<padded.length; i++)
                System.out.print( padded[i] + " " );
            System.out.println();
    
            unpadded = unpad(padded);
            for(int i=0; i<unpadded.length; i++)
                System.out.print( unpadded[i] + " " );
            System.out.println();
        }
        catch(Exception e)
        {
            e.printStackTrace();
        }
    }
}
    