/* $Id: ModeECB.java,v 1.8 2000/01/20 14:59:24 gelderen Exp $
 *
 * Copyright (C) 1995-2000 The Cryptix Foundation Limited.
 * All rights reserved.
 *
 * Use, modification, copying and distribution of this software is subject
 * the terms and conditions of the Cryptix General Licence. You should have
 * received a copy of the Cryptix General Licence along with this library;
 * if not, you can download a copy from http://www.cryptix.org/ .
 */
package cryptix.jce.provider.cipher;


import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
//import java.security.NoSuchAlgorithmException; //FIXME: See below. (pw)
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
//import javax.crypto.BadPaddingException; //FIXME: See below. (pw)
//import javax.crypto.IllegalBlockSizeException; //FIXME: See below. (pw)
//import javax.crypto.NoSuchPaddingException; //FIXME: See below. (pw)
import javax.crypto.ShortBufferException;
//import javax.crypto.spec.IvParameterSpec; //FIXME: See below. (pw)

// FIXME: Check with the api, if not needed remove. (pw)

/**
 * <B>Please read the comments in the source.</B>
 *
 * @author  Jeroen C. van Gelderen (gelderen@cryptix.org)
 * @author Paul Waserbrot (pw@cryptix.org)
 * @version $Revision: 1.8 $
 */


final class ModeECB extends Mode
{
    /** buffers incomplete blocks */
    private final byte[] buf; // we count the buffer with bufCount from Mode.java



    ModeECB(BlockCipher cipher) {
        super(cipher);
        buf = new byte[CIPHER_BLOCK_SIZE];
    }


// Implementation
//............................................................................

    final int coreGetOutputSize(int inputLen) {
        return ((bufCount+inputLen)/CIPHER_BLOCK_SIZE)*CIPHER_BLOCK_SIZE;
    }


    final void coreInit(boolean decrypt, Key key, AlgorithmParameterSpec params,
                    SecureRandom random)
    throws InvalidKeyException, InvalidAlgorithmParameterException
    {
        cipher.coreInit(key, decrypt);
    }


    int coreUpdate(byte[] input, int inputOffset, int inputLen,
               byte[] output, int outputOffset)
    throws ShortBufferException
    {
        // Invariant: bufCount < CIPHER_BLOCK_SIZE bytes

        int ret = 0;
        int remainder;
        while(inputLen >= (remainder = CIPHER_BLOCK_SIZE - bufCount)) {
            System.arraycopy(input, inputOffset, buf, bufCount, remainder);
            cipher.coreCrypt(buf, 0, output, outputOffset);
            inputLen     -= remainder;
            inputOffset  += remainder;
            outputOffset += CIPHER_BLOCK_SIZE;
            ret          += CIPHER_BLOCK_SIZE;
            bufCount      = 0;
        }

        // Invariant: bufCount < CIPHER_BLOCK_SIZE bytes

        System.arraycopy(input, inputOffset, buf, bufCount, inputLen);
        bufCount += inputLen;

        // Invariant: bufCount < CIPHER_BLOCK_SIZE bytes

        return ret;
    }

    final byte [] coreGetIV() 
    {
	return (byte []) null;
    }

    final AlgorithmParameterSpec coreGetParamSpec() 
    {
	return (AlgorithmParameterSpec) null;
    }
}
