/* $Id: Mode.java,v 1.9 2000/01/20 14:59:24 gelderen Exp $
 *
 * Copyright (C) 1995-2000 The Cryptix Foundation Limited.
 * All rights reserved.
 *
 * Use, modification, copying and distribution of this software is subject
 * the terms and conditions of the Cryptix General Licence. You should have
 * received a copy of the Cryptix General Licence along with this library;
 * if not, you can download a copy from http://www.cryptix.org/ .
 */
package cryptix.jce.provider.cipher;


import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
//import javax.crypto.BadPaddingException; // FIXME: remove? (see below)
//import javax.crypto.Cipher; // FIXME: remove? (see below)
//import javax.crypto.IllegalBlockSizeException; // FIXME: remove? (see below)
//import javax.crypto.NoSuchPaddingException; // FIXME: See below. (pw)
import javax.crypto.ShortBufferException;
//import javax.crypto.spec.IvParameterSpec; // FIXME: remove? (see below)

// FIXME: Check with the api, if not needed remove. (pw)


/**
 * <p>
 * A fully constructed Cipher instance looks like this:
 * <pre>
 * +------------------------------------------+
 * | CipherSpi (API methods)                  |
 * |                                          |
 * | +--------------------------------------+ |
 * | | Padding                              | |
 * | |                                      | |
 * | | +----------------------------------+ | |
 * | | | Mode                             | | |
 * | | |                                  | | |
 * | | | +------------------------------+ | | |
 * | | | | CipherSpi                    | | | |
 * | | | | (blockcipher implementation) | | | |
 * | | | |                              | | | |
 * | | | +------------------------------+ | | |
 * | | |                                  | | |
 * | | +----------------------------------+ | |
 * | |                                      | |
 * | +--------------------------------------+ |
 * |                                          |
 * +------------------------------------------+
 * </pre>
 *
 * @author  Jeroen C. van Gelderen (gelderen@cryptix.org)
 * @author  Paul Waserbrot (pw@cryptix.org)
 * @version $Revision: 1.9 $
 */
abstract class Mode
{
    /** Underlying block cipher */
    protected final BlockCipher cipher;


    /** Block size of underlying cipher */
    protected final int CIPHER_BLOCK_SIZE;


    /** Decrypting? */
    protected boolean decrypt;


    /** How many bytes the buffer holds */
    protected int bufCount;


    Mode(BlockCipher cipher) {
        this.cipher       = cipher;
        CIPHER_BLOCK_SIZE = cipher.coreGetBlockSize();
    }


    static Mode getInstance(String mode, BlockCipher cipher)
    throws NoSuchAlgorithmException
    {
        if( mode.equalsIgnoreCase("CBC") )
            return new ModeCBC(cipher);
        else if( mode.equalsIgnoreCase("ECB") )
            return new ModeECB(cipher);
        else if( mode.equalsIgnoreCase("OFB") )
            return new ModeOFB(cipher);
        else
            throw new NoSuchAlgorithmException();
    }


    void init(boolean decrypt, Key key, AlgorithmParameterSpec params,
                    SecureRandom random)
    throws InvalidKeyException, InvalidAlgorithmParameterException
    {
        this.decrypt = decrypt;
        coreInit(decrypt, key, params, random);
    }


    final byte[] getIV() {
        return coreGetIV();
    }


    final AlgorithmParameterSpec getParamSpec() {
	return coreGetParamSpec();
    }

    final int getOutputSize(int inputLen) {
        return coreGetOutputSize(inputLen);
    }


    final int getBlockSize() {
        return CIPHER_BLOCK_SIZE;
    }


    final int update(byte[] input, int inputOffset, int inputLen,
                     byte[] output, int outputOffset)
    throws ShortBufferException {
        return coreUpdate(input, inputOffset, inputLen, output, outputOffset);
    }

   
   final int getBufSize() {
        return bufCount;
   }



   protected byte [] generateIV() {
        byte [] b = new byte[CIPHER_BLOCK_SIZE];
        SecureRandom sr = new SecureRandom();
        sr.nextBytes(b);
        return b;
   }


// Abstract methods
//............................................................................

    abstract int coreGetOutputSize(int inputLen);

    abstract void coreInit(boolean decrypt, Key key, 
                           AlgorithmParameterSpec params, SecureRandom random)
    throws InvalidKeyException, InvalidAlgorithmParameterException;


    abstract int coreUpdate(byte[] input, int inputOffset, int inputLen,
                           byte[] output, int outputOffset)
    throws ShortBufferException;

    abstract byte [] coreGetIV();

    abstract AlgorithmParameterSpec coreGetParamSpec();
}
