/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.test;

import cryptix.jce.provider.Cryptix;
import cryptix.jce.test.Test;
import java.io.Serializable;
import java.security.Provider;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SealedObject;
import javax.crypto.SecretKey;

final class TestSealedObject
extends Test {
    private static final String name = "SealedObject";
    private Cipher c;
    private Cipher d;
    private SecretKey sk;
    private final String s;
    private String algo;
    private int KEY_SIZE;

    protected void doIt() throws Exception {
        this.init();
        this.beginTest("Decrypt with the cipher");
        this.passIf(this.test1(this.c, this.d, "ThisIsASecretSecretMessag"));
        this.beginTest("Decrypting with the secretkey");
        this.passIf(this.test2(this.c, this.sk, "ThisIsASecretSecretMessag"));
    }

    private void init() throws Exception {
        Security.addProvider((Provider)new Cryptix());
        KeyGenerator kg = KeyGenerator.getInstance(this.algo);
        kg.init(this.KEY_SIZE);
        this.sk = kg.generateKey();
        this.algo = this.algo + "/ECB/NoPadding";
        this.c = Cipher.getInstance(this.algo);
        this.d = Cipher.getInstance(this.algo);
        this.c.init(1, this.sk);
        this.d.init(2, this.sk);
    }

    private boolean test1(Cipher c, Cipher d, String s) throws Exception {
        String rs = "";
        SealedObject so = new SealedObject((Serializable)((Object)s), c);
        rs = (String)so.getObject(d);
        return rs.equals(s);
    }

    private boolean test2(Cipher c, SecretKey sKey, String s) throws Exception {
        String rs = "";
        SealedObject so = new SealedObject((Serializable)((Object)s), c);
        rs = (String)so.getObject(sKey);
        return rs.equals(s);
    }

    protected TestSealedObject(String algo, int KEY_SIZE) {
        super(name);
        this.s = "ThisIsASecretSecretMessag";
        this.algo = algo;
        this.KEY_SIZE = KEY_SIZE;
    }

    protected TestSealedObject() {
        super(name);
        this.s = "ThisIsASecretSecretMessag";
        this.algo = "DES";
        this.KEY_SIZE = 56;
    }
}

