/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.test;

import cryptix.jce.provider.Cryptix;
import cryptix.jce.test.CipherTest;
import java.security.Provider;
import java.security.Security;

final class TestRijndael
extends CipherTest {
    private static final String NAME = "Rijndael";
    private static final String[][] TEST_VALUES = new String[][]{{"80000000000000000000000000000000", "00000000000000000000000000000000", "0EDD33D3C621E546455BD8BA1418BEC8"}, {"40000000000000000000000000000000", "00000000000000000000000000000000", "C0CC0C5DA5BD63ACD44A80774FAD5222"}, {"20000000000000000000000000000000", "00000000000000000000000000000000", "2F0B4B71BC77851B9CA56D42EB8FF080"}, {"10000000000000000000000000000000", "00000000000000000000000000000000", "6B1E2FFFE8A114009D8FE22F6DB5F876"}, {"08000000000000000000000000000000", "00000000000000000000000000000000", "9AA042C315F94CBB97B62202F83358F5"}, {"04000000000000000000000000000000", "00000000000000000000000000000000", "DBE01DE67E346A800C4C4B4880311DE4"}, {"02000000000000000000000000000000", "00000000000000000000000000000000", "C117D2238D53836ACD92DDCDB85D6A21"}, {"01000000000000000000000000000000", "00000000000000000000000000000000", "DC0ED85DF9611ABB7249CDD168C5467E"}, {"00800000000000000000000000000000", "00000000000000000000000000000000", "807D678FFF1F56FA92DE3381904842F2"}, {"00400000000000000000000000000000", "00000000000000000000000000000000", "0E53B3FCAD8E4B130EF73AEB957FB402"}, {"00200000000000000000000000000000", "00000000000000000000000000000000", "969FFD3B7C35439417E7BDE923035D65"}, {"00100000000000000000000000000000", "00000000000000000000000000000000", "A99B512C19CA56070491166A1503BF15"}, {"00080000000000000000000000000000", "00000000000000000000000000000000", "6E9985252126EE344D26AE369D2327E3"}, {"00040000000000000000000000000000", "00000000000000000000000000000000", "B85F4809F904C275491FCDCD1610387E"}, {"00020000000000000000000000000000", "00000000000000000000000000000000", "ED365B8D7D20C1F5D53FB94DD211DF7B"}, {"00010000000000000000000000000000", "00000000000000000000000000000000", "B3A575E86A8DB4A7135D604C43304896"}, {"00008000000000000000000000000000", "00000000000000000000000000000000", "89704BCB8E69F846259EB0ACCBC7F8A2"}, {"00004000000000000000000000000000", "00000000000000000000000000000000", "C56EE7C92197861F10D7A92B90882055"}, {"00002000000000000000000000000000", "00000000000000000000000000000000", "92F296F6846E0EAF9422A5A24A08B069"}, {"00001000000000000000000000000000", "00000000000000000000000000000000", "E67E32BB8F11DEB8699318BEE9E91A60"}, {"00000800000000000000000000000000", "00000000000000000000000000000000", "B08EEF85EAF626DD91B65C4C3A97D92B"}, {"00000400000000000000000000000000", "00000000000000000000000000000000", "661083A6ADDCE79BB4E0859AB5538013"}, {"00000200000000000000000000000000", "00000000000000000000000000000000", "55DFE2941E0EB10AFC0B333BD34DE1FE"}, {"00000100000000000000000000000000", "00000000000000000000000000000000", "6BFE5945E715C9662609770F8846087A"}, {"00000080000000000000000000000000", "00000000000000000000000000000000", "79848E9C30C2F8CDA8B325F7FED2B139"}, {"00000040000000000000000000000000", "00000000000000000000000000000000", "7A713A53B99FEF34AC04DEEF80965BD0"}, {"00000020000000000000000000000000", "00000000000000000000000000000000", "18144A2B46620D32C3C32CE52D49257F"}, {"00000010000000000000000000000000", "00000000000000000000000000000000", "872E827C70887C80749F7B8BB1847C7E"}, {"00000008000000000000000000000000", "00000000000000000000000000000000", "6B86C6A4FE6A60C59B1A3102F8DE49F3"}, {"00000004000000000000000000000000", "00000000000000000000000000000000", "9848BB3DFDF6F532F094679A4C231A20"}, {"00000002000000000000000000000000", "00000000000000000000000000000000", "925AD528E852E329B2091CD3F1C2BCEE"}, {"00000001000000000000000000000000", "00000000000000000000000000000000", "80DF436544B0DD596722E46792A40CD8"}, {"00000000800000000000000000000000", "00000000000000000000000000000000", "525DAF18F93E83E1E74BBBDDE4263BBA"}, {"00000000400000000000000000000000", "00000000000000000000000000000000", "F65C9D2EE485D24701FFA3313B9D5BE6"}, {"00000000200000000000000000000000", "00000000000000000000000000000000", "E4FC8D8BCA06425BDF94AFA40FCC14BA"}, {"00000000100000000000000000000000", "00000000000000000000000000000000", "A53F0A5CA1E4E6440BB975FF320DE6F8"}, {"00000000080000000000000000000000", "00000000000000000000000000000000", "D55313B9394080462E87E02899B553F0"}, {"00000000040000000000000000000000", "00000000000000000000000000000000", "34A71D761F71BCD344384C7F97D27906"}, {"00000000020000000000000000000000", "00000000000000000000000000000000", "233F3D819599612EBC89580245C996A8"}, {"00000000010000000000000000000000", "00000000000000000000000000000000", "B4F1374E5268DBCB676E447529E53F89"}, {"00000000008000000000000000000000", "00000000000000000000000000000000", "0816BD27861D2BA891D1044E39951E96"}, {"00000000004000000000000000000000", "00000000000000000000000000000000", "F3BE9EA3F10C73CA64FDE5DB13A951D1"}, {"00000000002000000000000000000000", "00000000000000000000000000000000", "2448086A8106FBD03048DDF857D3F1C8"}, {"00000000001000000000000000000000", "00000000000000000000000000000000", "670756E65BEC8B68F03D77CDCDCE7B91"}, {"00000000000800000000000000000000", "00000000000000000000000000000000", "EF968CF0D36FD6C6EFFD225F6FB44CA9"}, {"00000000000400000000000000000000", "00000000000000000000000000000000", "2E8767157922E3826DDCEC1B0CC1E105"}, {"00000000000200000000000000000000", "00000000000000000000000000000000", "78CE7EEC670E45A967BAB17E26A1AD36"}, {"00000000000100000000000000000000", "00000000000000000000000000000000", "3C5CEE825655F098F6E81A2F417DA3FB"}, {"00000000000080000000000000000000", "00000000000000000000000000000000", "67BFDB431DCE1292200BC6F5207ADB12"}, {"00000000000040000000000000000000", "00000000000000000000000000000000", "7540FD38E447C0779228548747843A6F"}, {"00000000000020000000000000000000", "00000000000000000000000000000000", "B85E513301F8A936EA9EC8A21A85B5E6"}, {"00000000000010000000000000000000", "00000000000000000000000000000000", "04C67DBF16C11427D507A455DE2C9BC5"}, {"00000000000008000000000000000000", "00000000000000000000000000000000", "03F75EB8959E55079CFFB4FF149A37B6"}, {"00000000000004000000000000000000", "00000000000000000000000000000000", "74550287F666C63BB9BC7838433434B0"}, {"00000000000002000000000000000000", "00000000000000000000000000000000", "7D537200195EBC3AEFD1EAAB1C385221"}, {"00000000000001000000000000000000", "00000000000000000000000000000000", "CE24E4D40C68A82B535CBD3C8E21652A"}, {"00000000000000800000000000000000", "00000000000000000000000000000000", "AB20072405AA8FC40265C6F1F3DC8BC0"}, {"00000000000000400000000000000000", "00000000000000000000000000000000", "6CFD2CF688F566B093F67B9B3839E80A"}, {"00000000000000200000000000000000", "00000000000000000000000000000000", "BD95977E6B7239D407A012C5544BF584"}, {"00000000000000100000000000000000", "00000000000000000000000000000000", "DF9C0130AC77E7C72C997F587B46DBE0"}, {"00000000000000080000000000000000", "00000000000000000000000000000000", "E7F1B82CADC53A648798945B34EFEFF2"}, {"00000000000000040000000000000000", "00000000000000000000000000000000", "932C6DBF69255CF13EDCDB72233ACEA3"}, {"00000000000000020000000000000000", "00000000000000000000000000000000", "5C76002BC7206560EFE550C80B8F12CC"}, {"00000000000000010000000000000000", "00000000000000000000000000000000", "F6B7BDD1CAEEBAB574683893C4475484"}, {"00000000000000008000000000000000", "00000000000000000000000000000000", "A920E37CC6DC6B31DA8C0169569F5034"}, {"00000000000000004000000000000000", "00000000000000000000000000000000", "919380ECD9C778BC513148B0C28D65FD"}, {"00000000000000002000000000000000", "00000000000000000000000000000000", "EE67308DD3F2D9E6C2170755E5784BE1"}, {"00000000000000001000000000000000", "00000000000000000000000000000000", "3CC73E53B85609023A05E149B223AE09"}, {"00000000000000000800000000000000", "00000000000000000000000000000000", "983E8AF7CF05EBB28D71EB841C9406E6"}, {"00000000000000000400000000000000", "00000000000000000000000000000000", "0F3099B2D31FA5299EE5BF43193287FC"}, {"00000000000000000200000000000000", "00000000000000000000000000000000", "B763D84F38C27FE6931DCEB6715D4DB6"}, {"00000000000000000100000000000000", "00000000000000000000000000000000", "5AE3C9B0E3CC29C0C61565CD01F8A248"}, {"00000000000000000080000000000000", "00000000000000000000000000000000", "F58083572CD90981958565D48D2DEE25"}, {"00000000000000000040000000000000", "00000000000000000000000000000000", "7E6255EEF8F70C0EF10337AAB1CCCEF8"}, {"00000000000000000020000000000000", "00000000000000000000000000000000", "AAD4BAC34DB22821841CE2F631961902"}, {"00000000000000000010000000000000", "00000000000000000000000000000000", "D7431C0409BB1441BA9C6858DC7D4E81"}, {"00000000000000000008000000000000", "00000000000000000000000000000000", "EF9298C65E339F6E801A59C626456993"}, {"00000000000000000004000000000000", "00000000000000000000000000000000", "53FE29F68FF541ABC3F0EF3350B72F7E"}, {"00000000000000000002000000000000", "00000000000000000000000000000000", "F6BBA5C10DB02529E2C2DA3FB582CC14"}, {"00000000000000000001000000000000", "00000000000000000000000000000000", "E4239AA37FC531A386DAD1126FC0E9CD"}, {"00000000000000000000800000000000", "00000000000000000000000000000000", "8F7758F857D15BBE7BFD0E416404C365"}, {"00000000000000000000400000000000", "00000000000000000000000000000000", "D273EB57C687BCD1B4EA7218A509E7B8"}, {"00000000000000000000200000000000", "00000000000000000000000000000000", "65D64F8D76E8B3423FA25C4EB58A210A"}, {"00000000000000000000100000000000", "00000000000000000000000000000000", "623D802B4EC450D66A16625702FCDBE0"}, {"00000000000000000000080000000000", "00000000000000000000000000000000", "7496460CB28E5791BAEAF9B68FB00022"}, {"00000000000000000000040000000000", "00000000000000000000000000000000", "34EA600F18BB0694B41681A49D510C1D"}, {"00000000000000000000020000000000", "00000000000000000000000000000000", "5F8FF0D47D5766D29B5D6E8F46423BD8"}, {"00000000000000000000010000000000", "00000000000000000000000000000000", "225F9286C5928BF09F84D3F93F541959"}, {"00000000000000000000008000000000", "00000000000000000000000000000000", "B21E90D25DF383416A5F072CEBEB1FFB"}, {"00000000000000000000004000000000", "00000000000000000000000000000000", "4AEFCDA089318125453EB9E8EB5E492E"}, {"00000000000000000000002000000000", "00000000000000000000000000000000", "4D3E75C6CD40EC4869BC85158591ADB8"}, {"00000000000000000000001000000000", "00000000000000000000000000000000", "63A8B904405436A1B99D7751866771B7"}, {"00000000000000000000000800000000", "00000000000000000000000000000000", "64F0DAAE47529199792EAE172BA53293"}, {"00000000000000000000000400000000", "00000000000000000000000000000000", "C3EEF84BEA18225D515A8C852A9047EE"}, {"00000000000000000000000200000000", "00000000000000000000000000000000", "A44AC422B47D47B81AF73B3E9AC9596E"}, {"00000000000000000000000100000000", "00000000000000000000000000000000", "D16E04A8FBC435094F8D53ADF25F5084"}, {"00000000000000000000000080000000", "00000000000000000000000000000000", "EF13DC34BAB03E124EEAD8B6BF44B532"}, {"00000000000000000000000040000000", "00000000000000000000000000000000", "D94799075C24DCC067AF0D392049250D"}, {"00000000000000000000000020000000", "00000000000000000000000000000000", "14F431771EDDCE4764C21A2254B5E3C8"}, {"00000000000000000000000010000000", "00000000000000000000000000000000", "7039329F36F2ED682B02991F28D64679"}, {"00000000000000000000000008000000", "00000000000000000000000000000000", "124EE24EDE5551639DB8B8B941F6141D"}, {"00000000000000000000000004000000", "00000000000000000000000000000000", "C2852879A34D5184E478EC918B993FEE"}, {"00000000000000000000000002000000", "00000000000000000000000000000000", "86A806A3525B93E432053C9AB5ABBEDF"}, {"00000000000000000000000001000000", "00000000000000000000000000000000", "C1609BF5A4F07E37C17A36366EC23ECC"}, {"00000000000000000000000000800000", "00000000000000000000000000000000", "7E81E7CB92159A51FFCEA331B1E8EA53"}, {"00000000000000000000000000400000", "00000000000000000000000000000000", "37A7BE002856C5A59A6E03EAFCE7729A"}, {"00000000000000000000000000200000", "00000000000000000000000000000000", "BDF98A5A4F91E890C9A1D1E5FAAB138F"}, {"00000000000000000000000000100000", "00000000000000000000000000000000", "4E96ACB66E051F2BC739CC3D3E34A26B"}, {"00000000000000000000000000080000", "00000000000000000000000000000000", "EE996CDD120EB86E21ECFA49E8E1FCF1"}, {"00000000000000000000000000040000", "00000000000000000000000000000000", "61B9E6B579DBF6070C351A1440DD85FF"}, {"00000000000000000000000000020000", "00000000000000000000000000000000", "AC369E484316440B40DFC83AA96E28E7"}, {"00000000000000000000000000010000", "00000000000000000000000000000000", "0A2D16DE985C76D45C579C1159413BBE"}, {"00000000000000000000000000008000", "00000000000000000000000000000000", "DA3FDC38DA1D374FA4802CDA1A1C6B0F"}, {"00000000000000000000000000004000", "00000000000000000000000000000000", "B842523D4C41C2211AFE43A5800ADCE3"}, {"00000000000000000000000000002000", "00000000000000000000000000000000", "9E2CDA90D8E992DBA6C73D8229567192"}, {"00000000000000000000000000001000", "00000000000000000000000000000000", "D49583B781D9E20F5BE101415957FC49"}, {"00000000000000000000000000000800", "00000000000000000000000000000000", "EF09DA5C12B376E458B9B8670032498E"}, {"00000000000000000000000000000400", "00000000000000000000000000000000", "A96BE0463DA774461A5E1D5A9DD1AC10"}, {"00000000000000000000000000000200", "00000000000000000000000000000000", "32CEE3341060790D2D4B1362EF397090"}, {"00000000000000000000000000000100", "00000000000000000000000000000000", "21CEA416A3D3359D2C4D58FB6A035F06"}, {"00000000000000000000000000000080", "00000000000000000000000000000000", "172AEAB3D507678ECAF455C12587ADB7"}, {"00000000000000000000000000000040", "00000000000000000000000000000000", "B6F897941EF8EBFF9FE80A567EF38478"}, {"00000000000000000000000000000020", "00000000000000000000000000000000", "A9723259D94A7DC662FB0C782CA3F1DD"}, {"00000000000000000000000000000010", "00000000000000000000000000000000", "2F91C984B9A4839F30001B9F430493B4"}, {"00000000000000000000000000000008", "00000000000000000000000000000000", "0472406345A610B048CB99EE0EF3FA0F"}, {"00000000000000000000000000000004", "00000000000000000000000000000000", "F5F39086646F8C05ED16EFA4B617957C"}, {"00000000000000000000000000000002", "00000000000000000000000000000000", "26D50F485A30408D5AF47A5736292450"}, {"00000000000000000000000000000001", "00000000000000000000000000000000", "0545AAD56DA2A97C3663D1432A3D1C84"}, {"800000000000000000000000000000000000000000000000", "00000000000000000000000000000000", "DE885DC87F5A92594082D02CC1E1B42C"}, {"400000000000000000000000000000000000000000000000", "00000000000000000000000000000000", "C749194F94673F9DD2AA1932849630C1"}, {"200000000000000000000000000000000000000000000000", "00000000000000000000000000000000", "0CEF643313912934D310297B90F56ECC"}, {"100000000000000000000000000000000000000000000000", "00000000000000000000000000000000", "C4495D39D4A553B225FBA02A7B1B87E1"}, {"080000000000000000000000000000000000000000000000", "00000000000000000000000000000000", "636D10B1A0BCAB541D680A7970ADC830"}, {"040000000000000000000000000000000000000000000000", "00000000000000000000000000000000", "07CF045786BD6AFCC147D99E45A901A7"}, {"020000000000000000000000000000000000000000000000", "00000000000000000000000000000000", "6A8E3F425A7599348F95398448827976"}, {"010000000000000000000000000000000000000000000000", "00000000000000000000000000000000", "5518276836148A00D91089A20D8BFF57"}, {"008000000000000000000000000000000000000000000000", "00000000000000000000000000000000", "F267E07B5E87E3BC20B969C61D4FCB06"}, {"004000000000000000000000000000000000000000000000", "00000000000000000000000000000000", "5A1CDE69571D401BFCD20DEBADA2212C"}, {"002000000000000000000000000000000000000000000000", "00000000000000000000000000000000", "70A9057263254701D12ADD7D74CD509E"}, {"001000000000000000000000000000000000000000000000", "00000000000000000000000000000000", "35713A7E108031279388A33A0FE2E190"}, {"000800000000000000000000000000000000000000000000", "00000000000000000000000000000000", "E74EDE82B1254714F0C7B4B243108655"}, {"000400000000000000000000000000000000000000000000", "00000000000000000000000000000000", "39272E3100FAA37B55B862320D1B3EB3"}, {"000200000000000000000000000000000000000000000000", "00000000000000000000000000000000", "6D6E24C659FC5AEF712F77BCA19C9DD0"}, {"000100000000000000000000000000000000000000000000", "00000000000000000000000000000000", "76D18212F972370D3CC2C6C372C6CF2F"}, {"000080000000000000000000000000000000000000000000", "00000000000000000000000000000000", "B21A1F0BAE39E55C7594ED570A7783EA"}, {"000040000000000000000000000000000000000000000000", "00000000000000000000000000000000", "77DE202111895AC48DD1C974B358B458"}, {"000020000000000000000000000000000000000000000000", "00000000000000000000000000000000", "67810B311969012AAF7B504FFAF39FD1"}, {"000010000000000000000000000000000000000000000000", "00000000000000000000000000000000", "C22EA2344D3E9417A6BA07843E713AEA"}, {"000008000000000000000000000000000000000000000000", "00000000000000000000000000000000", "C79CAF4B97BEE0BD0630AB354539D653"}, {"000004000000000000000000000000000000000000000000", "00000000000000000000000000000000", "135FD1AF761D9AE23DF4AA6B86760DB4"}, {"000002000000000000000000000000000000000000000000", "00000000000000000000000000000000", "D4659D0B06ACD4D56AB8D11A16FD83B9"}, {"000001000000000000000000000000000000000000000000", "00000000000000000000000000000000", "F7D270028FC188E4E4F35A4AAA25D4D4"}, {"000000800000000000000000000000000000000000000000", "00000000000000000000000000000000", "345CAE5A8C9620A9913D5473985852FF"}, {"000000400000000000000000000000000000000000000000", "00000000000000000000000000000000", "4E8980ADDE60B0E42C0B287FEA41E729"}, {"000000200000000000000000000000000000000000000000", "00000000000000000000000000000000", "F11B6D74E1F15155633DC39743C1A527"}, {"000000100000000000000000000000000000000000000000", "00000000000000000000000000000000", "9C87916C0180064F9D3179C6F5DD8C35"}, {"000000080000000000000000000000000000000000000000", "00000000000000000000000000000000", "71AB186BCAEA518E461D4F7FAD230E6A"}, {"000000040000000000000000000000000000000000000000", "00000000000000000000000000000000", "C4A31BBC3DAAF742F9141C2A5001A49C"}, {"000000020000000000000000000000000000000000000000", "00000000000000000000000000000000", "E7C47B7B1D40F182A8928C8A55671D07"}, {"000000010000000000000000000000000000000000000000", "00000000000000000000000000000000", "8E17F294B28FA373C6249538868A7EEF"}, {"000000008000000000000000000000000000000000000000", "00000000000000000000000000000000", "754404096A5CBC08AF09491BE249141A"}, {"000000004000000000000000000000000000000000000000", "00000000000000000000000000000000", "101CB56E55F05D86369B6D1069204F0A"}, {"000000002000000000000000000000000000000000000000", "00000000000000000000000000000000", "73F19BB6604205C6EE227B9759791E41"}, {"000000001000000000000000000000000000000000000000", "00000000000000000000000000000000", "6270C0028F0D136C37A56B2CB64D24D6"}, {"000000000800000000000000000000000000000000000000", "00000000000000000000000000000000", "A3BF7C2C38D1114A087ECF212E694346"}, {"000000000400000000000000000000000000000000000000", "00000000000000000000000000000000", "49CABFF2CEF7D9F95F5EFB1F7A1A7DDE"}, {"000000000200000000000000000000000000000000000000", "00000000000000000000000000000000", "EC7F8A47CC59B849469255AD49F62752"}, {"000000000100000000000000000000000000000000000000", "00000000000000000000000000000000", "68FAE55A13EFAF9B07B3552A8A0DC9D1"}, {"000000000080000000000000000000000000000000000000", "00000000000000000000000000000000", "211E6B19C69FAEF481F64F24099CDA65"}, {"000000000040000000000000000000000000000000000000", "00000000000000000000000000000000", "DBB918C75BC5732416F79FB0C8EE4C5C"}, {"000000000020000000000000000000000000000000000000", "00000000000000000000000000000000", "98D494E5D963A6C8B92536D3EC35E3FD"}, {"000000000010000000000000000000000000000000000000", "00000000000000000000000000000000", "C9A873404D403D6F074190851D67781A"}, {"000000000008000000000000000000000000000000000000", "00000000000000000000000000000000", "073AEF4A7C77D921928CB0DD9D27CAE7"}, {"000000000004000000000000000000000000000000000000", "00000000000000000000000000000000", "89BDE25CEE36FDE769A10E52298CF90F"}, {"000000000002000000000000000000000000000000000000", "00000000000000000000000000000000", "26D0842D37EAD38557C65E0A5E5F122E"}, {"000000000001000000000000000000000000000000000000", "00000000000000000000000000000000", "F8294BA375AF46B3F22905BBAFFAB107"}, {"000000000000800000000000000000000000000000000000", "00000000000000000000000000000000", "2AD63EB4D0D43813B979CF72B35BDB94"}, {"000000000000400000000000000000000000000000000000", "00000000000000000000000000000000", "7710C171EE0F4EFA39BE4C995180181D"}, {"000000000000200000000000000000000000000000000000", "00000000000000000000000000000000", "C0CB2B40DBA7BE8C0698FAE1E4B80FF8"}, {"000000000000100000000000000000000000000000000000", "00000000000000000000000000000000", "97970E505194622FD955CA1B80B784E9"}, {"000000000000080000000000000000000000000000000000", "00000000000000000000000000000000", "7CB1824B29F850900DF2CAD9CF04C1CF"}, {"000000000000040000000000000000000000000000000000", "00000000000000000000000000000000", "FDF4F036BB988E42F2F62DE63FE19A64"}, {"000000000000020000000000000000000000000000000000", "00000000000000000000000000000000", "08908CFE2C82606B2C15DF61B75CF3E2"}, {"000000000000010000000000000000000000000000000000", "00000000000000000000000000000000", "B3AA689EF2D07FF365ACB9ADBA2AF07A"}, {"000000000000008000000000000000000000000000000000", "00000000000000000000000000000000", "F2672CD8EAA3B98776660D0263656F5C"}, {"000000000000004000000000000000000000000000000000", "00000000000000000000000000000000", "5BDEAC00E986687B9E1D94A0DA7BF452"}, {"000000000000002000000000000000000000000000000000", "00000000000000000000000000000000", "E6D57BD66EA1627363EE0C4B711B0B21"}, {"000000000000001000000000000000000000000000000000", "00000000000000000000000000000000", "03730DD6ACB4AD9996A63BE7765EC06F"}, {"000000000000000800000000000000000000000000000000", "00000000000000000000000000000000", "A470E361AA5437B2BE8586D2F78DE582"}, {"000000000000000400000000000000000000000000000000", "00000000000000000000000000000000", "7567FEEFA559911FD479670246B484E3"}, {"000000000000000200000000000000000000000000000000", "00000000000000000000000000000000", "29829DEA15A4E7A4C049045E7B106E29"}, {"000000000000000100000000000000000000000000000000", "00000000000000000000000000000000", "A407834C3D89D48A2CB7A152208FA4ED"}, {"000000000000000080000000000000000000000000000000", "00000000000000000000000000000000", "68F948053F78FEF0D8F9FE7EF3A89819"}, {"000000000000000040000000000000000000000000000000", "00000000000000000000000000000000", "B605174CAB13AD8FE3B20DA3AE7B0234"}, {"000000000000000020000000000000000000000000000000", "00000000000000000000000000000000", "CCAB8F0AEBFF032893996D383CBFDBFA"}, {"000000000000000010000000000000000000000000000000", "00000000000000000000000000000000", "AF14BB8428C9730B7DC17B6C1CBEBCC8"}, {"000000000000000008000000000000000000000000000000", "00000000000000000000000000000000", "5A41A21332040877EB7B89E8E80D19FE"}, {"000000000000000004000000000000000000000000000000", "00000000000000000000000000000000", "AC1BA52EFCDDE368B1596F2F0AD893A0"}, {"000000000000000002000000000000000000000000000000", "00000000000000000000000000000000", "41B890E31B9045E6ECDC1BC3F2DB9BCC"}, {"000000000000000001000000000000000000000000000000", "00000000000000000000000000000000", "4D54A549728E55B19A23660424A0F146"}, {"000000000000000000800000000000000000000000000000", "00000000000000000000000000000000", "A917581F41C47C7DDCFFD5285E2D6A61"}, {"000000000000000000400000000000000000000000000000", "00000000000000000000000000000000", "604DF24BA6099B93A7405A524D764FCB"}, {"000000000000000000200000000000000000000000000000", "00000000000000000000000000000000", "78D9D156F28B190E232D1B7AE7FC730A"}, {"000000000000000000100000000000000000000000000000", "00000000000000000000000000000000", "5A12C39E442CD7F27B3CD77F5D029582"}, {"000000000000000000080000000000000000000000000000", "00000000000000000000000000000000", "FF2BF2F47CF7B0F28EE25AF95DBF790D"}, {"000000000000000000040000000000000000000000000000", "00000000000000000000000000000000", "1863BB7D193BDA39DF090659EB8AE48B"}, {"000000000000000000020000000000000000000000000000", "00000000000000000000000000000000", "38178F2FB4CFCF31E87E1ABCDC023EB5"}, {"000000000000000000010000000000000000000000000000", "00000000000000000000000000000000", "F5B13DC690CC0D541C6BA533023DC8C9"}, {"000000000000000000008000000000000000000000000000", "00000000000000000000000000000000", "48EC05238D7375D126DC9D08884D4827"}, {"000000000000000000004000000000000000000000000000", "00000000000000000000000000000000", "ACD0D81139691B310B92A6E377BACC87"}, {"000000000000000000002000000000000000000000000000", "00000000000000000000000000000000", "9A4AA43578B55CE9CC178F0D2E162C79"}, {"000000000000000000001000000000000000000000000000", "00000000000000000000000000000000", "08AD94BC737DB3C87D49B9E01B720D81"}, {"000000000000000000000800000000000000000000000000", "00000000000000000000000000000000", "3BCFB2D5D210E8332900C5991D551A2A"}, {"000000000000000000000400000000000000000000000000", "00000000000000000000000000000000", "C5F0C6B9397ACB29635CE1A0DA2D8D96"}, {"000000000000000000000200000000000000000000000000", "00000000000000000000000000000000", "844A29EFC693E2FA9900F87FBF5DCD5F"}, {"000000000000000000000100000000000000000000000000", "00000000000000000000000000000000", "5126A1C41051FEA158BE41200E1EA59D"}, {"000000000000000000000080000000000000000000000000", "00000000000000000000000000000000", "302123CA7B4F46D667FFFB0EB6AA7703"}, {"000000000000000000000040000000000000000000000000", "00000000000000000000000000000000", "A9D16BCE7DB5C024277709EE2A88D91A"}, {"000000000000000000000020000000000000000000000000", "00000000000000000000000000000000", "F013C5EC123A26CFC34B598C992A996B"}, {"000000000000000000000010000000000000000000000000", "00000000000000000000000000000000", "E38A825CD971A1D2E56FB1DBA248F2A8"}, {"000000000000000000000008000000000000000000000000", "00000000000000000000000000000000", "6E701773C0311E0BD4C5A097406D22B3"}, {"000000000000000000000004000000000000000000000000", "00000000000000000000000000000000", "754262CEF0C64BE4C3E67C35ABE439F7"}, {"000000000000000000000002000000000000000000000000", "00000000000000000000000000000000", "C9C2D4C47DF7D55CFA0EE5F1FE5070F4"}, {"000000000000000000000001000000000000000000000000", "00000000000000000000000000000000", "6AB4BEA85B172573D8BD2D5F4329F13D"}, {"000000000000000000000000800000000000000000000000", "00000000000000000000000000000000", "11F03EF28E2CC9AE5165C587F7396C8C"}, {"000000000000000000000000400000000000000000000000", "00000000000000000000000000000000", "0682F2EB1A68BAC7949922C630DD27FA"}, {"000000000000000000000000200000000000000000000000", "00000000000000000000000000000000", "ABB0FEC0413D659AFE8E3DCF6BA873BB"}, {"000000000000000000000000100000000000000000000000", "00000000000000000000000000000000", "FE86A32E19F805D6569B2EFADD9C92AA"}, {"000000000000000000000000080000000000000000000000", "00000000000000000000000000000000", "E434E472275D1837D3D717F2EECC88C3"}, {"000000000000000000000000040000000000000000000000", "00000000000000000000000000000000", "74E57DCD12A21D26EF8ADAFA5E60469A"}, {"000000000000000000000000020000000000000000000000", "00000000000000000000000000000000", "C275429D6DAD45DDD423FA63C816A9C1"}, {"000000000000000000000000010000000000000000000000", "00000000000000000000000000000000", "7F6EC1A9AE729E86F7744AED4B8F4F07"}, {"000000000000000000000000008000000000000000000000", "00000000000000000000000000000000", "48B5A71AB9292BD4F9E608EF102636B2"}, {"000000000000000000000000004000000000000000000000", "00000000000000000000000000000000", "076FB95D5F536C78CBED3181BCCF3CF1"}, {"000000000000000000000000002000000000000000000000", "00000000000000000000000000000000", "BFA76BEA1E684FD3BF9256119EE0BC0F"}, {"000000000000000000000000001000000000000000000000", "00000000000000000000000000000000", "7D395923D56577F3FF8670998F8C4A71"}, {"000000000000000000000000000800000000000000000000", "00000000000000000000000000000000", "BA02C986E529AC18A882C34BA389625F"}, {"000000000000000000000000000400000000000000000000", "00000000000000000000000000000000", "3DFCF2D882AFE75D3A191193013A84B5"}, {"000000000000000000000000000200000000000000000000", "00000000000000000000000000000000", "FAD1FDE1D0241784B63080D2C74D236C"}, {"000000000000000000000000000100000000000000000000", "00000000000000000000000000000000", "7D6C80D39E41F007A14FB9CD2B2C15CD"}, {"000000000000000000000000000080000000000000000000", "00000000000000000000000000000000", "7975F401FC10637BB33EA2DB058FF6EC"}, {"000000000000000000000000000040000000000000000000", "00000000000000000000000000000000", "657983865C55A818F02B7FCD52ED7E99"}, {"000000000000000000000000000020000000000000000000", "00000000000000000000000000000000", "B32BEB1776F9827FF4C3AC9997E84B20"}, {"000000000000000000000000000010000000000000000000", "00000000000000000000000000000000", "2AE2C7C374F0A41E3D46DBC3E66BB59F"}, {"000000000000000000000000000008000000000000000000", "00000000000000000000000000000000", "4D835E4ABDD4BDC6B88316A6E931A07F"}, {"000000000000000000000000000004000000000000000000", "00000000000000000000000000000000", "E07EFABFF1C353F7384EBB87B435A3F3"}, {"000000000000000000000000000002000000000000000000", "00000000000000000000000000000000", "ED3088DC3FAF89AD87B4356FF1BB09C2"}, {"000000000000000000000000000001000000000000000000", "00000000000000000000000000000000", "4324D01140C156FC898C2E32BA03FB05"}, {"000000000000000000000000000000800000000000000000", "00000000000000000000000000000000", "BE15D016FACB5BAFBC24FA9289132166"}, {"000000000000000000000000000000400000000000000000", "00000000000000000000000000000000", "AC9B7048EDB1ACF4D97A5B0B3F50884B"}, {"000000000000000000000000000000200000000000000000", "00000000000000000000000000000000", "448BECE1F86C7845DFA9A4BB2A016FB3"}, {"000000000000000000000000000000100000000000000000", "00000000000000000000000000000000", "10DD445E87686EB46EA9B1ABC49257F0"}, {"000000000000000000000000000000080000000000000000", "00000000000000000000000000000000", "B7FCCF7659FA756D4B7303EEA6C07458"}, {"000000000000000000000000000000040000000000000000", "00000000000000000000000000000000", "289117115CA3513BAA7640B1004872C2"}, {"000000000000000000000000000000020000000000000000", "00000000000000000000000000000000", "57CB42F7EE7186051F50B93FFA7B35BF"}, {"000000000000000000000000000000010000000000000000", "00000000000000000000000000000000", "F2741BFBFB81663B9136802FB9C3126A"}, {"000000000000000000000000000000008000000000000000", "00000000000000000000000000000000", "E32DDDC5C7398C096E3BD535B31DB5CE"}, {"000000000000000000000000000000004000000000000000", "00000000000000000000000000000000", "81D3C204E608AF9CC713EAEBCB72433F"}, {"000000000000000000000000000000002000000000000000", "00000000000000000000000000000000", "D4DEEF4BFC36AAA579496E6935F8F98E"}, {"000000000000000000000000000000001000000000000000", "00000000000000000000000000000000", "C356DB082B97802B038571C392C5C8F6"}, {"000000000000000000000000000000000800000000000000", "00000000000000000000000000000000", "A3919ECD4861845F2527B77F06AC6A4E"}, {"000000000000000000000000000000000400000000000000", "00000000000000000000000000000000", "A53858E17A2F802A20E40D44494FFDA0"}, {"000000000000000000000000000000000200000000000000", "00000000000000000000000000000000", "5D989E122B78C758921EDBEEB827F0C0"}, {"000000000000000000000000000000000100000000000000", "00000000000000000000000000000000", "4B1C0C8F9E7830CC3C4BE7BD226FA8DE"}, {"000000000000000000000000000000000080000000000000", "00000000000000000000000000000000", "82C40C5FD897FBCA7B899C70713573A1"}, {"000000000000000000000000000000000040000000000000", "00000000000000000000000000000000", "ED13EE2D45E00F75CCDB51EA8E3E36AD"}, {"000000000000000000000000000000000020000000000000", "00000000000000000000000000000000", "F121799EEFE8432423176A3CCF6462BB"}, {"000000000000000000000000000000000010000000000000", "00000000000000000000000000000000", "4FA0C06F07997E98271DD86F7B355C50"}, {"000000000000000000000000000000000008000000000000", "00000000000000000000000000000000", "849EB364B4E81D058649DC5B1BF029B9"}, {"000000000000000000000000000000000004000000000000", "00000000000000000000000000000000", "F48F9E0DE8DE7AD944A207809335D9B1"}, {"000000000000000000000000000000000002000000000000", "00000000000000000000000000000000", "E59E9205B5A81A4FD26DFCF308966022"}, {"000000000000000000000000000000000001000000000000", "00000000000000000000000000000000", "3A91A1BE14AAE9ED700BDF9D70018804"}, {"000000000000000000000000000000000000800000000000", "00000000000000000000000000000000", "8ABAD78DCB79A48D79070E7DA89664EC"}, {"000000000000000000000000000000000000400000000000", "00000000000000000000000000000000", "B68377D98AAE6044938A7457F6C649D9"}, {"000000000000000000000000000000000000200000000000", "00000000000000000000000000000000", "E4E1275C42F5F1B63D662C099D6CE33D"}, {"000000000000000000000000000000000000100000000000", "00000000000000000000000000000000", "7DEF32A34C6BE668F17DA1BB193B06EF"}, {"000000000000000000000000000000000000080000000000", "00000000000000000000000000000000", "78B6000CC3D30CB3A74B68D0EDBD2B53"}, {"000000000000000000000000000000000000040000000000", "00000000000000000000000000000000", "0A47531DE88DD8AE5C23EAE4F7D1F2D5"}, {"000000000000000000000000000000000000020000000000", "00000000000000000000000000000000", "667B24E8000CF68231EC484581D922E5"}, {"000000000000000000000000000000000000010000000000", "00000000000000000000000000000000", "39DAA5EBD4AACAE130E9C33236C52024"}, {"000000000000000000000000000000000000008000000000", "00000000000000000000000000000000", "E3C88760B3CB21360668A63E55BB45D1"}, {"000000000000000000000000000000000000004000000000", "00000000000000000000000000000000", "F131EE903C1CDB49D416866FD5D8DE51"}, {"000000000000000000000000000000000000002000000000", "00000000000000000000000000000000", "7A1916135B0447CF4033FC13047A583A"}, {"000000000000000000000000000000000000001000000000", "00000000000000000000000000000000", "F7D55FB27991143DCDFA90DDF0424FCB"}, {"000000000000000000000000000000000000000800000000", "00000000000000000000000000000000", "EA93E7D1CA1111DBD8F7EC111A848C0C"}, {"000000000000000000000000000000000000000400000000", "00000000000000000000000000000000", "2A689E39DFD3CBCBE221326E95888779"}, {"000000000000000000000000000000000000000200000000", "00000000000000000000000000000000", "C1CE399CA762318AC2C40D1928B4C57D"}, {"000000000000000000000000000000000000000100000000", "00000000000000000000000000000000", "D43FB6F2B2879C8BFAF0092DA2CA63ED"}, {"000000000000000000000000000000000000000080000000", "00000000000000000000000000000000", "224563E617158DF97650AF5D130E78A5"}, {"000000000000000000000000000000000000000040000000", "00000000000000000000000000000000", "6562FDF6833B7C4F7484AE6EBCC243DD"}, {"000000000000000000000000000000000000000020000000", "00000000000000000000000000000000", "93D58BA7BED22615D661D002885A7457"}, {"000000000000000000000000000000000000000010000000", "00000000000000000000000000000000", "9A0EF559003AD9E52D3E09ED3C1D3320"}, {"000000000000000000000000000000000000000008000000", "00000000000000000000000000000000", "96BAF5A7DC6F3DD27EB4C717A85D261C"}, {"000000000000000000000000000000000000000004000000", "00000000000000000000000000000000", "B8762E06884900E8452293190E19CCDB"}, {"000000000000000000000000000000000000000002000000", "00000000000000000000000000000000", "785416A22BD63CBABF4B1789355197D3"}, {"000000000000000000000000000000000000000001000000", "00000000000000000000000000000000", "A0D20CE1489BAA69A3612DCE90F7ABF6"}, {"000000000000000000000000000000000000000000800000", "00000000000000000000000000000000", "700244E93DC94230CC607FFBA0E48F32"}, {"000000000000000000000000000000000000000000400000", "00000000000000000000000000000000", "85329E476829F872A2B4A7E59F91FF2D"}, {"000000000000000000000000000000000000000000200000", "00000000000000000000000000000000", "E4219B4935D988DB719B8B8B2B53D247"}, {"000000000000000000000000000000000000000000100000", "00000000000000000000000000000000", "6ACDD04FD13D4DB4409FE8DD13FD737B"}, {"000000000000000000000000000000000000000000080000", "00000000000000000000000000000000", "9EB7A670AB59E15BE582378701C1EC14"}, {"000000000000000000000000000000000000000000040000", "00000000000000000000000000000000", "29DF2D6935FE657763BC7A9F22D3D492"}, {"000000000000000000000000000000000000000000020000", "00000000000000000000000000000000", "99303359D4A13AFDBE6C784028CE533A"}, {"000000000000000000000000000000000000000000010000", "00000000000000000000000000000000", "FF5C70A6334545F33B9DBF7BEA0417CA"}, {"000000000000000000000000000000000000000000008000", "00000000000000000000000000000000", "289F58A17E4C50EDA4269EFB3DF55815"}, {"000000000000000000000000000000000000000000004000", "00000000000000000000000000000000", "EA35DCB416E9E1C2861D1682F062B5EB"}, {"000000000000000000000000000000000000000000002000", "00000000000000000000000000000000", "3A47BF354BE775383C50B0C0A83E3A58"}, {"000000000000000000000000000000000000000000001000", "00000000000000000000000000000000", "BF6C1DC069FB95D05D43B01D8206D66B"}, {"000000000000000000000000000000000000000000000800", "00000000000000000000000000000000", "046D1D580D5898DA6595F32FD1F0C33D"}, {"000000000000000000000000000000000000000000000400", "00000000000000000000000000000000", "5F57803B7B82A110F7E9855D6A546082"}, {"000000000000000000000000000000000000000000000200", "00000000000000000000000000000000", "25336ECF34E7BE97862CDFF715FF05A8"}, {"000000000000000000000000000000000000000000000100", "00000000000000000000000000000000", "ACBAA2A943D8078022D693890E8C4FEF"}, {"000000000000000000000000000000000000000000000080", "00000000000000000000000000000000", "3947597879F6B58E4E2F0DF825A83A38"}, {"000000000000000000000000000000000000000000000040", "00000000000000000000000000000000", "4EB8CC3335496130655BF3CA570A4FC0"}, {"000000000000000000000000000000000000000000000020", "00000000000000000000000000000000", "BBDA7769AD1FDA425E18332D97868824"}, {"000000000000000000000000000000000000000000000010", "00000000000000000000000000000000", "5E7532D22DDB0829A29C868198397154"}, {"000000000000000000000000000000000000000000000008", "00000000000000000000000000000000", "E66DA67B630AB7AE3E682855E1A1698E"}, {"000000000000000000000000000000000000000000000004", "00000000000000000000000000000000", "4D93800F671B48559A64D1EA030A590A"}, {"000000000000000000000000000000000000000000000002", "00000000000000000000000000000000", "F33159FCC7D9AE30C062CD3B322AC764"}, {"000000000000000000000000000000000000000000000001", "00000000000000000000000000000000", "8BAE4EFB70D33A9792EEA9BE70889D72"}, {"8000000000000000000000000000000000000000000000000000000000000000", "00000000000000000000000000000000", "E35A6DCB19B201A01EBCFA8AA22B5759"}, {"4000000000000000000000000000000000000000000000000000000000000000", "00000000000000000000000000000000", "5075C2405B76F22F553488CAE47CE90B"}, {"2000000000000000000000000000000000000000000000000000000000000000", "00000000000000000000000000000000", "49DF95D844A0145A7DE01C91793302D3"}, {"1000000000000000000000000000000000000000000000000000000000000000", "00000000000000000000000000000000", "E7396D778E940B8418A86120E5F421FE"}, {"0800000000000000000000000000000000000000000000000000000000000000", "00000000000000000000000000000000", "05F535C36FCEDE4657BE37F4087DB1EF"}, {"0400000000000000000000000000000000000000000000000000000000000000", "00000000000000000000000000000000", "D0C1DDDD10DA777C68AB36AF51F2C204"}, {"0200000000000000000000000000000000000000000000000000000000000000", "00000000000000000000000000000000", "1C55FB811B5C6464C4E5DE1535A75514"}, {"0100000000000000000000000000000000000000000000000000000000000000", "00000000000000000000000000000000", "52917F3AE957D5230D3A2AF57C7B5A71"}, {"0080000000000000000000000000000000000000000000000000000000000000", "00000000000000000000000000000000", "C6E3D5501752DD5E9AEF086D6B45D705"}, {"0040000000000000000000000000000000000000000000000000000000000000", "00000000000000000000000000000000", "A24A9C7AF1D9B1E17E1C9A3E711B3FA7"}, {"0020000000000000000000000000000000000000000000000000000000000000", "00000000000000000000000000000000", "B881ECA724A6D43DBC6B96F6F59A0D20"}, {"0010000000000000000000000000000000000000000000000000000000000000", "00000000000000000000000000000000", "EC524D9A24DFFF2A9639879B83B8E137"}, {"0008000000000000000000000000000000000000000000000000000000000000", "00000000000000000000000000000000", "34C4F345F5466215A037F443635D6F75"}, {"0004000000000000000000000000000000000000000000000000000000000000", "00000000000000000000000000000000", "5BA5055BEDB8895F672E29F2EB5A355D"}, {"0002000000000000000000000000000000000000000000000000000000000000", "00000000000000000000000000000000", "B3F692AA3A435259EBBEF9B51AD1E08D"}, {"0001000000000000000000000000000000000000000000000000000000000000", "00000000000000000000000000000000", "414FEB4376F2C64A5D2FBB2ED531BA7D"}, {"0000800000000000000000000000000000000000000000000000000000000000", "00000000000000000000000000000000", "A20D519E3BCA3303F07E81719F61605E"}, {"0000400000000000000000000000000000000000000000000000000000000000", "00000000000000000000000000000000", "A08D10E520AF811F45BD60A2DC0DC4B1"}, {"0000200000000000000000000000000000000000000000000000000000000000", "00000000000000000000000000000000", "B06893A8C563C430E6F3858826EFBBE4"}, {"0000100000000000000000000000000000000000000000000000000000000000", "00000000000000000000000000000000", "0FFEE26AE2D3929C6BD9C6BEDFF84409"}, {"0000080000000000000000000000000000000000000000000000000000000000", "00000000000000000000000000000000", "4D0F5E906ED77801FC0EF53EDC5F9E2B"}, {"0000040000000000000000000000000000000000000000000000000000000000", "00000000000000000000000000000000", "8B6EC00119AD8B026DCE56EA7DEFE930"}, {"0000020000000000000000000000000000000000000000000000000000000000", "00000000000000000000000000000000", "69026591D43363EE9D83B5007F0B484E"}, {"0000010000000000000000000000000000000000000000000000000000000000", "00000000000000000000000000000000", "27135D86950C6A2F86872706279A4761"}, {"0000008000000000000000000000000000000000000000000000000000000000", "00000000000000000000000000000000", "35E6DB8723F281DA410C3AC8535ED77C"}, {"0000004000000000000000000000000000000000000000000000000000000000", "00000000000000000000000000000000", "57427CF214B8C28E4BBF487CCB8D0E09"}, {"0000002000000000000000000000000000000000000000000000000000000000", "00000000000000000000000000000000", "6DF01BF56E5131AC87F96E99CAB86367"}, {"0000001000000000000000000000000000000000000000000000000000000000", "00000000000000000000000000000000", "3856C5B55790B768BBF7D43031579BCF"}, {"0000000800000000000000000000000000000000000000000000000000000000", "00000000000000000000000000000000", "1E6ED8FB7C15BC4D2F63BA7037ED44D0"}, {"0000000400000000000000000000000000000000000000000000000000000000", "00000000000000000000000000000000", "E1B2ED6CD8D93D455534E401156D4BCF"}, {"0000000200000000000000000000000000000000000000000000000000000000", "00000000000000000000000000000000", "EFBCCA5BDFDAD10E875F02336212CE36"}, {"0000000100000000000000000000000000000000000000000000000000000000", "00000000000000000000000000000000", "0B777F02FD18DCE2646DCFE868DFAFAD"}, {"0000000080000000000000000000000000000000000000000000000000000000", "00000000000000000000000000000000", "C8A104B5693D1B14F5BF1F10100BF508"}, {"0000000040000000000000000000000000000000000000000000000000000000", "00000000000000000000000000000000", "4CCE6615244AFCB38408FECE219962EA"}, {"0000000020000000000000000000000000000000000000000000000000000000", "00000000000000000000000000000000", "F99E7845D3A255B394C9C050CBA258B1"}, {"0000000010000000000000000000000000000000000000000000000000000000", "00000000000000000000000000000000", "B4AFBB787F9BCFB7B55FDF447F611295"}, {"0000000008000000000000000000000000000000000000000000000000000000", "00000000000000000000000000000000", "AE1C426A697FAF2808B7EF6ADDB5C020"}, {"0000000004000000000000000000000000000000000000000000000000000000", "00000000000000000000000000000000", "7572F92811A85B9BDD38DEAD9945BCAE"}, {"0000000002000000000000000000000000000000000000000000000000000000", "00000000000000000000000000000000", "71BC7AA46E43FB95A181527D9F6A360F"}, {"0000000001000000000000000000000000000000000000000000000000000000", "00000000000000000000000000000000", "5542EF2923066F1EC8F546DD0D8E7CA8"}, {"0000000000800000000000000000000000000000000000000000000000000000", "00000000000000000000000000000000", "6B92317C7D623790B748FDD7EFC42422"}, {"0000000000400000000000000000000000000000000000000000000000000000", "00000000000000000000000000000000", "0FE7C097E899C71EF045360F8D6C25CF"}, {"0000000000200000000000000000000000000000000000000000000000000000", "00000000000000000000000000000000", "4ECE7EE107D0264D04693151C25B9DF6"}, {"0000000000100000000000000000000000000000000000000000000000000000", "00000000000000000000000000000000", "FD6AE687CBFCA9E301045888D3BB9605"}, {"0000000000080000000000000000000000000000000000000000000000000000", "00000000000000000000000000000000", "476B579C8556C7254424902CC1D6D36E"}, {"0000000000040000000000000000000000000000000000000000000000000000", "00000000000000000000000000000000", "4133CBCDFDD6B8860A1FC18665D6D71B"}, {"0000000000020000000000000000000000000000000000000000000000000000", "00000000000000000000000000000000", "3B36EC2664798C108B816812C65DFDC7"}, {"0000000000010000000000000000000000000000000000000000000000000000", "00000000000000000000000000000000", "364E20A234FEA385D48DC5A09C9E70CF"}, {"0000000000008000000000000000000000000000000000000000000000000000", "00000000000000000000000000000000", "4A4BA25969DE3F5EE5642C71AAD0EFD1"}, {"0000000000004000000000000000000000000000000000000000000000000000", "00000000000000000000000000000000", "E42CBAAE43297F67A76C1C501BB79E36"}, {"0000000000002000000000000000000000000000000000000000000000000000", "00000000000000000000000000000000", "23CEDEDA4C15B4C037E8C61492217937"}, {"0000000000001000000000000000000000000000000000000000000000000000", "00000000000000000000000000000000", "A1719147A1F4A1A1180BD16E8593DCDE"}, {"0000000000000800000000000000000000000000000000000000000000000000", "00000000000000000000000000000000", "AB82337E9FB0EC60D1F25A1D0014192C"}, {"0000000000000400000000000000000000000000000000000000000000000000", "00000000000000000000000000000000", "74BF2D8FC5A8388DF1A3A4D7D33FC164"}, {"0000000000000200000000000000000000000000000000000000000000000000", "00000000000000000000000000000000", "D5B493317E6FBC6FFFD664B3C491368A"}, {"0000000000000100000000000000000000000000000000000000000000000000", "00000000000000000000000000000000", "BA767381586DA56A2A8D503D5F7ADA0B"}, {"0000000000000080000000000000000000000000000000000000000000000000", "00000000000000000000000000000000", "E8E6BC57DFE9CCADB0DECABF4E5CF91F"}, {"0000000000000040000000000000000000000000000000000000000000000000", "00000000000000000000000000000000", "3C8E5A5CDC9CEED90815D1F84BB2998C"}, {"0000000000000020000000000000000000000000000000000000000000000000", "00000000000000000000000000000000", "283843020BA38F056001B2FD585F7CC9"}, {"0000000000000010000000000000000000000000000000000000000000000000", "00000000000000000000000000000000", "D8ADC7426F623ECE8741A70621D28870"}, {"0000000000000008000000000000000000000000000000000000000000000000", "00000000000000000000000000000000", "D7C5C215592D06F00E6A80DA69A28EA9"}, {"0000000000000004000000000000000000000000000000000000000000000000", "00000000000000000000000000000000", "52CF6FA433C3C870CAC70190358F7F16"}, {"0000000000000002000000000000000000000000000000000000000000000000", "00000000000000000000000000000000", "F63D442A584DA71786ADEC9F3346DF75"}, {"0000000000000001000000000000000000000000000000000000000000000000", "00000000000000000000000000000000", "549078F4B0CA7079B45F9A5ADAFAFD99"}, {"0000000000000000800000000000000000000000000000000000000000000000", "00000000000000000000000000000000", "F2A5986EE4E9984BE2BAFB79EA8152FA"}, {"0000000000000000400000000000000000000000000000000000000000000000", "00000000000000000000000000000000", "8A74535017B4DB2776668A1FAE64384C"}, {"0000000000000000200000000000000000000000000000000000000000000000", "00000000000000000000000000000000", "E613342F57A97FD95DC088711A5D0ECD"}, {"0000000000000000100000000000000000000000000000000000000000000000", "00000000000000000000000000000000", "3FFAEBF6B22CF1DC82AE17CD48175B01"}, {"0000000000000000080000000000000000000000000000000000000000000000", "00000000000000000000000000000000", "BAFD52EFA15C248CCBF9757735E6B1CE"}, {"0000000000000000040000000000000000000000000000000000000000000000", "00000000000000000000000000000000", "7AF94BC018D9DDD4539D2DD1C6F4000F"}, {"0000000000000000020000000000000000000000000000000000000000000000", "00000000000000000000000000000000", "FE177AD61CA0FDB281086FBA8FE76803"}, {"0000000000000000010000000000000000000000000000000000000000000000", "00000000000000000000000000000000", "74DBEA15E2E9285BAD163D7D534251B6"}, {"0000000000000000008000000000000000000000000000000000000000000000", "00000000000000000000000000000000", "23DD21331B3A92F200FE56FF050FFE74"}, {"0000000000000000004000000000000000000000000000000000000000000000", "00000000000000000000000000000000", "A69C5AA34AB20A858CAFA766EACED6D8"}, {"0000000000000000002000000000000000000000000000000000000000000000", "00000000000000000000000000000000", "3F72BB4DF2A4F941A4A09CB78F04B97A"}, {"0000000000000000001000000000000000000000000000000000000000000000", "00000000000000000000000000000000", "72CC43577E1FD5FD14622D24D97FCDCC"}, {"0000000000000000000800000000000000000000000000000000000000000000", "00000000000000000000000000000000", "D83AF8EBE93E0B6B99CAFADE224937D1"}, {"0000000000000000000400000000000000000000000000000000000000000000", "00000000000000000000000000000000", "44042329128D56CAA8D084C8BD769D1E"}, {"0000000000000000000200000000000000000000000000000000000000000000", "00000000000000000000000000000000", "14102D72290DE4F2C430ADD1ED64BA1D"}, {"0000000000000000000100000000000000000000000000000000000000000000", "00000000000000000000000000000000", "449124097B1ECD0AE7065206DF06F03C"}, {"0000000000000000000080000000000000000000000000000000000000000000", "00000000000000000000000000000000", "D060A99F8CC153A42E11E5F97BD7584A"}, {"0000000000000000000040000000000000000000000000000000000000000000", "00000000000000000000000000000000", "65605B3EA9261488D53E48602ADEA299"}, {"0000000000000000000020000000000000000000000000000000000000000000", "00000000000000000000000000000000", "C5E5CAD7A208DE8EA6BE049EFE5C7346"}, {"0000000000000000000010000000000000000000000000000000000000000000", "00000000000000000000000000000000", "4C280C46D2181646048DD5BC0C0831A5"}, {"0000000000000000000008000000000000000000000000000000000000000000", "00000000000000000000000000000000", "5DD65CF37F2A0929559AABAFDA08E730"}, {"0000000000000000000004000000000000000000000000000000000000000000", "00000000000000000000000000000000", "31F2335CAAF264172F69A693225E6D22"}, {"0000000000000000000002000000000000000000000000000000000000000000", "00000000000000000000000000000000", "3E28B35F99A72662590DA96426DD377F"}, {"0000000000000000000001000000000000000000000000000000000000000000", "00000000000000000000000000000000", "570F40F5D7B20441486578ED344343BE"}, {"0000000000000000000000800000000000000000000000000000000000000000", "00000000000000000000000000000000", "C54308AD1C9E3B19F8B7417873045A8C"}, {"0000000000000000000000400000000000000000000000000000000000000000", "00000000000000000000000000000000", "CBF335E39CE13ADE2B696179E8FD0CE1"}, {"0000000000000000000000200000000000000000000000000000000000000000", "00000000000000000000000000000000", "9C2FBF422355D8293083D51F4A3C18A9"}, {"0000000000000000000000100000000000000000000000000000000000000000", "00000000000000000000000000000000", "5ED8B5A31ECEFAB16C9AA6986DA67BCE"}, {"0000000000000000000000080000000000000000000000000000000000000000", "00000000000000000000000000000000", "627815DCFC814ABC75900041B1DD7B59"}, {"0000000000000000000000040000000000000000000000000000000000000000", "00000000000000000000000000000000", "9EF3E82A50A59F166260494F7A7F2CC3"}, {"0000000000000000000000020000000000000000000000000000000000000000", "00000000000000000000000000000000", "878CD0D8D920888B5935D6C351128737"}, {"0000000000000000000000010000000000000000000000000000000000000000", "00000000000000000000000000000000", "E44429474D6FC3084EB2A6B8B46AF754"}, {"0000000000000000000000008000000000000000000000000000000000000000", "00000000000000000000000000000000", "EBAACF9641D54E1FB18D0A2BE4F19BE5"}, {"0000000000000000000000004000000000000000000000000000000000000000", "00000000000000000000000000000000", "13B3BF497CEE780E123C7E193DEA3A01"}, {"0000000000000000000000002000000000000000000000000000000000000000", "00000000000000000000000000000000", "6E8F381DE00A41161F0DF03B4155BFD4"}, {"0000000000000000000000001000000000000000000000000000000000000000", "00000000000000000000000000000000", "35E4F29BBA2BAE01144910783C3FEF49"}, {"0000000000000000000000000800000000000000000000000000000000000000", "00000000000000000000000000000000", "55B17BD66788CEAC366398A31F289FFB"}, {"0000000000000000000000000400000000000000000000000000000000000000", "00000000000000000000000000000000", "11341F56C0D6D1008D28741DAA7679CE"}, {"0000000000000000000000000200000000000000000000000000000000000000", "00000000000000000000000000000000", "4DF7253DF421D83358BDBE924745D98C"}, {"0000000000000000000000000100000000000000000000000000000000000000", "00000000000000000000000000000000", "BAE2EE651116D93EDC8E83B5F3347BE1"}, {"0000000000000000000000000080000000000000000000000000000000000000", "00000000000000000000000000000000", "F9721ABD06709157183AF3965A659D9D"}, {"0000000000000000000000000040000000000000000000000000000000000000", "00000000000000000000000000000000", "19A1C252A613FE2860A4AE6D75CE6FA3"}, {"0000000000000000000000000020000000000000000000000000000000000000", "00000000000000000000000000000000", "B5DDB2F5D9752C949FBDE3FFF5556C6E"}, {"0000000000000000000000000010000000000000000000000000000000000000", "00000000000000000000000000000000", "81B044FCFFC78ECCFCD171AAD0405C66"}, {"0000000000000000000000000008000000000000000000000000000000000000", "00000000000000000000000000000000", "C640566D3C06020EB2C42F1D62E56A9B"}, {"0000000000000000000000000004000000000000000000000000000000000000", "00000000000000000000000000000000", "EA6C4BCF425291679FDFFD26A424FBCC"}, {"0000000000000000000000000002000000000000000000000000000000000000", "00000000000000000000000000000000", "57F6901465D9440D9F15EE2CBA5A4090"}, {"0000000000000000000000000001000000000000000000000000000000000000", "00000000000000000000000000000000", "FBCFA74CADC7406260F63D96C8AAB6B1"}, {"0000000000000000000000000000800000000000000000000000000000000000", "00000000000000000000000000000000", "DFF4F096CEA211D4BBDACA033D0EC7D1"}, {"0000000000000000000000000000400000000000000000000000000000000000", "00000000000000000000000000000000", "1EE5190D551F0F42F675227A381296A9"}, {"0000000000000000000000000000200000000000000000000000000000000000", "00000000000000000000000000000000", "F98E1905012E580F097623C10B93054F"}, {"0000000000000000000000000000100000000000000000000000000000000000", "00000000000000000000000000000000", "E7D43743D21DD3C9F168C86856558B9A"}, {"0000000000000000000000000000080000000000000000000000000000000000", "00000000000000000000000000000000", "632A9DDA730DAB67593C5D08D8AC1059"}, {"0000000000000000000000000000040000000000000000000000000000000000", "00000000000000000000000000000000", "E084317000715B9057BC9DE9F3AB6124"}, {"0000000000000000000000000000020000000000000000000000000000000000", "00000000000000000000000000000000", "61F9EF33A0BB4E666C2ED99101919FAB"}, {"0000000000000000000000000000010000000000000000000000000000000000", "00000000000000000000000000000000", "6DC1D68A11834657D46703C22578D59A"}, {"0000000000000000000000000000008000000000000000000000000000000000", "00000000000000000000000000000000", "53AC1548863D3D16F1D4DC7242E05F2C"}, {"0000000000000000000000000000004000000000000000000000000000000000", "00000000000000000000000000000000", "E82CD587A408306AD78CEAE0916B9F8C"}, {"0000000000000000000000000000002000000000000000000000000000000000", "00000000000000000000000000000000", "0FD2D40EA6AD17A3A767F0A8600D6295"}, {"0000000000000000000000000000001000000000000000000000000000000000", "00000000000000000000000000000000", "AD84CC8255ADB39DFCA23F92761AE7E9"}, {"0000000000000000000000000000000800000000000000000000000000000000", "00000000000000000000000000000000", "F4F20CF7D51BEE7DA024A2B11A7ECA0B"}, {"0000000000000000000000000000000400000000000000000000000000000000", "00000000000000000000000000000000", "5057691B85D9CE93A193214DB0A016B6"}, {"0000000000000000000000000000000200000000000000000000000000000000", "00000000000000000000000000000000", "0F58C960876390BDEF4BB6BE95CAA1EE"}, {"0000000000000000000000000000000100000000000000000000000000000000", "00000000000000000000000000000000", "9A3E66EEBC21BC0BD9430B341EF465FA"}, {"0000000000000000000000000000000080000000000000000000000000000000", "00000000000000000000000000000000", "20415035F34B8BCBCB28ABF07F78F0D4"}, {"0000000000000000000000000000000040000000000000000000000000000000", "00000000000000000000000000000000", "AC89FC7BA10479EBF10DE65BCEF89B3C"}, {"0000000000000000000000000000000020000000000000000000000000000000", "00000000000000000000000000000000", "068FA75A30BE443171AF3F6FEB1A20D2"}, {"0000000000000000000000000000000010000000000000000000000000000000", "00000000000000000000000000000000", "50E02F213246C525A8C27700CA34B502"}, {"0000000000000000000000000000000008000000000000000000000000000000", "00000000000000000000000000000000", "227DA47D5A0906DB3AB042BB0A695FB6"}, {"0000000000000000000000000000000004000000000000000000000000000000", "00000000000000000000000000000000", "8663AC30ED12514F1DE46777F4514BFC"}, {"0000000000000000000000000000000002000000000000000000000000000000", "00000000000000000000000000000000", "A987D4BC12E1DE9F4B6DF43567C34A8B"}, {"0000000000000000000000000000000001000000000000000000000000000000", "00000000000000000000000000000000", "6D5A0370F599ACA605F63B04E5143D0C"}, {"0000000000000000000000000000000000800000000000000000000000000000", "00000000000000000000000000000000", "9809266E378B07B7AFDB3BAA97B7E442"}, {"0000000000000000000000000000000000400000000000000000000000000000", "00000000000000000000000000000000", "8F753252B30CCCACE12D9A301F4D5090"}, {"0000000000000000000000000000000000200000000000000000000000000000", "00000000000000000000000000000000", "032465F6C0CE34D41962F561692A1AFF"}, {"0000000000000000000000000000000000100000000000000000000000000000", "00000000000000000000000000000000", "C50E9AD5BEB8F3B00821DD47FF8AC093"}, {"0000000000000000000000000000000000080000000000000000000000000000", "00000000000000000000000000000000", "9C6FEA3D46268D54A6829B2AD25BB276"}, {"0000000000000000000000000000000000040000000000000000000000000000", "00000000000000000000000000000000", "0FD8575E87706F561343D7B3A41E044A"}, {"0000000000000000000000000000000000020000000000000000000000000000", "00000000000000000000000000000000", "BEE9BEB3739540D88CBCE77925F0A114"}, {"0000000000000000000000000000000000010000000000000000000000000000", "00000000000000000000000000000000", "D24EAEE7FFFBAC3D6F26C2DCE0DCDE28"}, {"0000000000000000000000000000000000008000000000000000000000000000", "00000000000000000000000000000000", "47771A90398FF0F7FA821C2F8F5E1398"}, {"0000000000000000000000000000000000004000000000000000000000000000", "00000000000000000000000000000000", "4639741B6F84B135AD118C8249B64ED0"}, {"0000000000000000000000000000000000002000000000000000000000000000", "00000000000000000000000000000000", "8EE5505EC85567697A3306F250A27720"}, {"0000000000000000000000000000000000001000000000000000000000000000", "00000000000000000000000000000000", "7C8A19AC1AEFBC5E0119D91A5F05D4C2"}, {"0000000000000000000000000000000000000800000000000000000000000000", "00000000000000000000000000000000", "5141B9B672E54773B672E3A6C424887B"}, {"0000000000000000000000000000000000000400000000000000000000000000", "00000000000000000000000000000000", "B5A2D3CD206653C6402F34FB0AE3613D"}, {"0000000000000000000000000000000000000200000000000000000000000000", "00000000000000000000000000000000", "0F5BD9408738231D114B0A82753279A3"}, {"0000000000000000000000000000000000000100000000000000000000000000", "00000000000000000000000000000000", "FEF033FF4268EA487FC74C5E43A45338"}, {"0000000000000000000000000000000000000080000000000000000000000000", "00000000000000000000000000000000", "A3EDC09DCD529B113910D904AD855581"}, {"0000000000000000000000000000000000000040000000000000000000000000", "00000000000000000000000000000000", "AB8FBB6F27A0AC7C55B59FDD36B72F1C"}, {"0000000000000000000000000000000000000020000000000000000000000000", "00000000000000000000000000000000", "EEA44D5ED4D769CC930CD83D8999EC46"}, {"0000000000000000000000000000000000000010000000000000000000000000", "00000000000000000000000000000000", "6972276803AE9AA7C6F431AB10979C34"}, {"0000000000000000000000000000000000000008000000000000000000000000", "00000000000000000000000000000000", "86DEAA9F39244101818178474D7DBDE9"}, {"0000000000000000000000000000000000000004000000000000000000000000", "00000000000000000000000000000000", "88C6B466EA361D662D8D08CBF181F4FE"}, {"0000000000000000000000000000000000000002000000000000000000000000", "00000000000000000000000000000000", "91AB2C6B7C63FF59F7CBEEBF91B20B95"}, {"0000000000000000000000000000000000000001000000000000000000000000", "00000000000000000000000000000000", "2DFE6C146AD5B3D8C3C1718F13B48E01"}, {"0000000000000000000000000000000000000000800000000000000000000000", "00000000000000000000000000000000", "C7CFF1623451711391A302EEC3584AAA"}, {"0000000000000000000000000000000000000000400000000000000000000000", "00000000000000000000000000000000", "089FE845CC05011686C66019D18BE050"}, {"0000000000000000000000000000000000000000200000000000000000000000", "00000000000000000000000000000000", "08C8410B9B427211A67124B0DCCEAD48"}, {"0000000000000000000000000000000000000000100000000000000000000000", "00000000000000000000000000000000", "8D91592F5566085254784606334D7629"}, {"0000000000000000000000000000000000000000080000000000000000000000", "00000000000000000000000000000000", "3298FEAAF2E1201D6299FF8846639C97"}, {"0000000000000000000000000000000000000000040000000000000000000000", "00000000000000000000000000000000", "C497CB9F0BDFE0EFC8C2F3F90760AA72"}, {"0000000000000000000000000000000000000000020000000000000000000000", "00000000000000000000000000000000", "2788AFD046E0309CBE4424690DA2AB89"}, {"0000000000000000000000000000000000000000010000000000000000000000", "00000000000000000000000000000000", "E9891707F25EF29FEE372890D4258982"}, {"0000000000000000000000000000000000000000008000000000000000000000", "00000000000000000000000000000000", "DB041D94A23D45D4D4DCED5A030CAF61"}, {"0000000000000000000000000000000000000000004000000000000000000000", "00000000000000000000000000000000", "FFAFDBF0ECB18DF9EA02C27077448E6D"}, {"0000000000000000000000000000000000000000002000000000000000000000", "00000000000000000000000000000000", "2DAAA42A7D0A1D3B0E4761D99CF2150A"}, {"0000000000000000000000000000000000000000001000000000000000000000", "00000000000000000000000000000000", "3B7A54CB7CF30ABE263DD6ED5BFE8D63"}, {"0000000000000000000000000000000000000000000800000000000000000000", "00000000000000000000000000000000", "EEFA090174C590C448A55D43648F534A"}, {"0000000000000000000000000000000000000000000400000000000000000000", "00000000000000000000000000000000", "9E15798731ED42F43EA2740A691DA872"}, {"0000000000000000000000000000000000000000000200000000000000000000", "00000000000000000000000000000000", "31FBD661540A5DEAAD1017CFD3909EC8"}, {"0000000000000000000000000000000000000000000100000000000000000000", "00000000000000000000000000000000", "CDA9AE05F224140E28CB951721B44D6A"}, {"0000000000000000000000000000000000000000000080000000000000000000", "00000000000000000000000000000000", "0C5BC512C60A1EAC3434EFB1A8FBB182"}, {"0000000000000000000000000000000000000000000040000000000000000000", "00000000000000000000000000000000", "AA863610DEEEEB62D045E87EA30B59B5"}, {"0000000000000000000000000000000000000000000020000000000000000000", "00000000000000000000000000000000", "6AC2448DE568D279C7EEBE1DF403920C"}, {"0000000000000000000000000000000000000000000010000000000000000000", "00000000000000000000000000000000", "E2011E3D292B26888AE801215FD0CB40"}, {"0000000000000000000000000000000000000000000008000000000000000000", "00000000000000000000000000000000", "E06F3E15EE3A61672D1C99BADE5B9DBE"}, {"0000000000000000000000000000000000000000000004000000000000000000", "00000000000000000000000000000000", "BB7027F0548CF6712CEB4C7A4B28E178"}, {"0000000000000000000000000000000000000000000002000000000000000000", "00000000000000000000000000000000", "061EC21FB70FADBDF87C3BD2AE23825B"}, {"0000000000000000000000000000000000000000000001000000000000000000", "00000000000000000000000000000000", "4C21F26FE94ABBAC381352375314C3EB"}, {"0000000000000000000000000000000000000000000000800000000000000000", "00000000000000000000000000000000", "F7CEE6DD99909C2B569EEDA61ED8942E"}, {"0000000000000000000000000000000000000000000000400000000000000000", "00000000000000000000000000000000", "CE98C4A876C65E4CCB261EBB1D9DF7F5"}, {"0000000000000000000000000000000000000000000000200000000000000000", "00000000000000000000000000000000", "A5491881CF833C3604ABC08044F402AC"}, {"0000000000000000000000000000000000000000000000100000000000000000", "00000000000000000000000000000000", "A1BA16E64CCCB3087D57A768507B0BFC"}, {"0000000000000000000000000000000000000000000000080000000000000000", "00000000000000000000000000000000", "D55951E202D2949EBD3BE43120C738BF"}, {"0000000000000000000000000000000000000000000000040000000000000000", "00000000000000000000000000000000", "EBB8E43069E69F450EFEC65DCD52B7FD"}, {"0000000000000000000000000000000000000000000000020000000000000000", "00000000000000000000000000000000", "2B292135663B4AA5ABFE9423D57E7EE9"}, {"0000000000000000000000000000000000000000000000010000000000000000", "00000000000000000000000000000000", "E91BF974B3BE3AD966249D8655292A85"}, {"0000000000000000000000000000000000000000000000008000000000000000", "00000000000000000000000000000000", "384365998EAA9562236CC58F6ADF9610"}, {"0000000000000000000000000000000000000000000000004000000000000000", "00000000000000000000000000000000", "C2E997012AA3D4D8D359C9A947CBE69F"}, {"0000000000000000000000000000000000000000000000002000000000000000", "00000000000000000000000000000000", "F49421204148BA213BE87E2D5C22B0BF"}, {"0000000000000000000000000000000000000000000000001000000000000000", "00000000000000000000000000000000", "82ED0ED9953AA92E4DF30929CA65C00F"}, {"0000000000000000000000000000000000000000000000000800000000000000", "00000000000000000000000000000000", "291EB1D11653C8479437C74A977F5106"}, {"0000000000000000000000000000000000000000000000000400000000000000", "00000000000000000000000000000000", "BCB997B1939B8983ABD550D6025683E3"}, {"0000000000000000000000000000000000000000000000000200000000000000", "00000000000000000000000000000000", "1FBA2592C6F489775CAADA71F9B983E9"}, {"0000000000000000000000000000000000000000000000000100000000000000", "00000000000000000000000000000000", "969F66F217AF1A3DB9E41C1B29039824"}, {"0000000000000000000000000000000000000000000000000080000000000000", "00000000000000000000000000000000", "A54BB7D6B17E423AC0A7744C19073CB8"}, {"0000000000000000000000000000000000000000000000000040000000000000", "00000000000000000000000000000000", "B0AC6E6578D1021F47DCF9748A32EAD5"}, {"0000000000000000000000000000000000000000000000000020000000000000", "00000000000000000000000000000000", "B87B361C3B7B194C77A4358D4669153E"}, {"0000000000000000000000000000000000000000000000000010000000000000", "00000000000000000000000000000000", "46A133847F96EAA8282A799DC8899D58"}, {"0000000000000000000000000000000000000000000000000008000000000000", "00000000000000000000000000000000", "2265EC3A9F2D5C9547A091CC8CFB18EA"}, {"0000000000000000000000000000000000000000000000000004000000000000", "00000000000000000000000000000000", "54CBF3A6FC4FE56D426117AA1FFD1DDE"}, {"0000000000000000000000000000000000000000000000000002000000000000", "00000000000000000000000000000000", "5312877CCEAB6CFB0905394A370A8003"}, {"0000000000000000000000000000000000000000000000000001000000000000", "00000000000000000000000000000000", "7190BD6EC613FE38B84ECFE28F702FE4"}, {"0000000000000000000000000000000000000000000000000000800000000000", "00000000000000000000000000000000", "D1FA5B9CA89A43B04C05F0EF29EF68CD"}, {"0000000000000000000000000000000000000000000000000000400000000000", "00000000000000000000000000000000", "808285751548ED934FD1056D2D9AE8BA"}, {"0000000000000000000000000000000000000000000000000000200000000000", "00000000000000000000000000000000", "2758DEF3E7B95A9AE89777BE64D5A6CF"}, {"0000000000000000000000000000000000000000000000000000100000000000", "00000000000000000000000000000000", "07D81F87DB3E0ACC82B01E08FB22F3C1"}, {"0000000000000000000000000000000000000000000000000000080000000000", "00000000000000000000000000000000", "8DA250E5553D650711A75EE1CB4FD1C7"}, {"0000000000000000000000000000000000000000000000000000040000000000", "00000000000000000000000000000000", "A93D946BD0E87F32719DF5F158CEE669"}, {"0000000000000000000000000000000000000000000000000000020000000000", "00000000000000000000000000000000", "03945236EC2A4D4EAF30B8ABEB54330D"}, {"0000000000000000000000000000000000000000000000000000010000000000", "00000000000000000000000000000000", "11CC35301F24B79DDE31AEA2D1354F88"}, {"0000000000000000000000000000000000000000000000000000008000000000", "00000000000000000000000000000000", "E73715B3E8D9A290F44AE6FFBF247E5D"}, {"0000000000000000000000000000000000000000000000000000004000000000", "00000000000000000000000000000000", "7345E07732B71CB158BBF64CCA5C5B96"}, {"0000000000000000000000000000000000000000000000000000002000000000", "00000000000000000000000000000000", "6E128F296D24705A1924FD9B70C4ED04"}, {"0000000000000000000000000000000000000000000000000000001000000000", "00000000000000000000000000000000", "95A789776F036783FBD330947083F54F"}, {"0000000000000000000000000000000000000000000000000000000800000000", "00000000000000000000000000000000", "360DEC2533EA4AA2E3E54FD3DE2906EB"}, {"0000000000000000000000000000000000000000000000000000000400000000", "00000000000000000000000000000000", "E68EFD7FECF4D601EA22727BD764965B"}, {"0000000000000000000000000000000000000000000000000000000200000000", "00000000000000000000000000000000", "9065C64A8BFF44AC33EDBB611CF83D7B"}, {"0000000000000000000000000000000000000000000000000000000100000000", "00000000000000000000000000000000", "8F33C8DF2A7A51CE8090E8F123BC3723"}, {"0000000000000000000000000000000000000000000000000000000080000000", "00000000000000000000000000000000", "807F391FFBA8291BA625623210F99018"}, {"0000000000000000000000000000000000000000000000000000000040000000", "00000000000000000000000000000000", "5E8B3F3A701522CE5CAA761C929D6292"}, {"0000000000000000000000000000000000000000000000000000000020000000", "00000000000000000000000000000000", "3BA404DC38735A78289E3809E8364835"}, {"0000000000000000000000000000000000000000000000000000000010000000", "00000000000000000000000000000000", "D23BEDBAD229F8305DC425B6B759DCC9"}, {"0000000000000000000000000000000000000000000000000000000008000000", "00000000000000000000000000000000", "44880F21CF5913040AE376AEE2A10AD8"}, {"0000000000000000000000000000000000000000000000000000000004000000", "00000000000000000000000000000000", "9BC98E29D057C0E828C3B5CCE69256C1"}, {"0000000000000000000000000000000000000000000000000000000002000000", "00000000000000000000000000000000", "B293CC7A975DA141A68279368057CC41"}, {"0000000000000000000000000000000000000000000000000000000001000000", "00000000000000000000000000000000", "8D60FB87ACD91385B313BE5F1D7BD30F"}, {"0000000000000000000000000000000000000000000000000000000000800000", "00000000000000000000000000000000", "2C8E56132D70291B303C48FDF75543CD"}, {"0000000000000000000000000000000000000000000000000000000000400000", "00000000000000000000000000000000", "D1F80035B826791F6CE4E59B7DB1BB0D"}, {"0000000000000000000000000000000000000000000000000000000000200000", "00000000000000000000000000000000", "42CE6224FC36469339A133DD08173BD4"}, {"0000000000000000000000000000000000000000000000000000000000100000", "00000000000000000000000000000000", "61817155EA41BCBA2AF7F06AE7CBF585"}, {"0000000000000000000000000000000000000000000000000000000000080000", "00000000000000000000000000000000", "D1923A9866068D2EF5FB77D57C3315B6"}, {"0000000000000000000000000000000000000000000000000000000000040000", "00000000000000000000000000000000", "B37CBDB5D719F49691CA968EF2E84140"}, {"0000000000000000000000000000000000000000000000000000000000020000", "00000000000000000000000000000000", "EC974E653A055D7F8F22171030F68E1D"}, {"0000000000000000000000000000000000000000000000000000000000010000", "00000000000000000000000000000000", "DDE5D3B9AAD9C32213BB3675A822499C"}, {"0000000000000000000000000000000000000000000000000000000000008000", "00000000000000000000000000000000", "D3B6E9216EA1AE57EB1C628A3C38AB78"}, {"0000000000000000000000000000000000000000000000000000000000004000", "00000000000000000000000000000000", "82C99ECC69472B7E96324B042AE8B87A"}, {"0000000000000000000000000000000000000000000000000000000000002000", "00000000000000000000000000000000", "97144DC5338C43600F84439C0AA0D147"}, {"0000000000000000000000000000000000000000000000000000000000001000", "00000000000000000000000000000000", "400AC4A0BBADA1DB2121EB144C7E5209"}, {"0000000000000000000000000000000000000000000000000000000000000800", "00000000000000000000000000000000", "EFD9D550EB419ED278F4885A490AB54C"}, {"0000000000000000000000000000000000000000000000000000000000000400", "00000000000000000000000000000000", "2AB7816E149B7C0404C88A8857793670"}, {"0000000000000000000000000000000000000000000000000000000000000200", "00000000000000000000000000000000", "5B591DFF9E8DEE15BAD24C025DBCA481"}, {"0000000000000000000000000000000000000000000000000000000000000100", "00000000000000000000000000000000", "0C06633E30721C3749F49AD8CBF2B754"}, {"0000000000000000000000000000000000000000000000000000000000000080", "00000000000000000000000000000000", "96D6D31A41B5123B2035FD91A921D4CA"}, {"0000000000000000000000000000000000000000000000000000000000000040", "00000000000000000000000000000000", "E7F6C34D86668BC2805CA7793C5E86AD"}, {"0000000000000000000000000000000000000000000000000000000000000020", "00000000000000000000000000000000", "F46DFF5FF500D6879C4D3E45CF0CF0F3"}, {"0000000000000000000000000000000000000000000000000000000000000010", "00000000000000000000000000000000", "60D842D9C61DA7495C116197B7CECBBE"}, {"0000000000000000000000000000000000000000000000000000000000000008", "00000000000000000000000000000000", "D45B24EDB673353EBDF248B8FA06B67A"}, {"0000000000000000000000000000000000000000000000000000000000000004", "00000000000000000000000000000000", "119EAEBCC165D0BD02C0D35DC82EF992"}, {"0000000000000000000000000000000000000000000000000000000000000002", "00000000000000000000000000000000", "E673143680414ADA301D0ED34626B9FE"}, {"0000000000000000000000000000000000000000000000000000000000000001", "00000000000000000000000000000000", "6B6CFE160A6263631B292F879EEFF926"}, {"00000000000000000000000000000000", "80000000000000000000000000000000", "3AD78E726C1EC02B7EBFE92B23D9EC34"}, {"00000000000000000000000000000000", "40000000000000000000000000000000", "45BC707D29E8204D88DFBA2F0B0CAD9B"}, {"00000000000000000000000000000000", "20000000000000000000000000000000", "161556838018F52805CDBD6202002E3F"}, {"00000000000000000000000000000000", "10000000000000000000000000000000", "F5569B3AB6A6D11EFDE1BF0A64C6854A"}, {"00000000000000000000000000000000", "08000000000000000000000000000000", "64E82B50E501FBD7DD4116921159B83E"}, {"00000000000000000000000000000000", "04000000000000000000000000000000", "BAAC12FB613A7DE11450375C74034041"}, {"00000000000000000000000000000000", "02000000000000000000000000000000", "BCF176A7EAAD8085EBACEA362462A281"}, {"00000000000000000000000000000000", "01000000000000000000000000000000", "47711816E91D6FF059BBBF2BF58E0FD3"}, {"00000000000000000000000000000000", "00800000000000000000000000000000", "B970DFBE40698AF1638FE38BD3DF3B2F"}, {"00000000000000000000000000000000", "00400000000000000000000000000000", "F95B59A44F391E14CF20B74BDC32FCFF"}, {"00000000000000000000000000000000", "00200000000000000000000000000000", "720F74AE04A2A435B9A7256E49378F5B"}, {"00000000000000000000000000000000", "00100000000000000000000000000000", "2A0445F61D36BFA7E277070730CF76DA"}, {"00000000000000000000000000000000", "00080000000000000000000000000000", "8D0536B997AEFEC1D94011BAB6699A03"}, {"00000000000000000000000000000000", "00040000000000000000000000000000", "674F002E19F6ED47EFF319E51FAD4498"}, {"00000000000000000000000000000000", "00020000000000000000000000000000", "292C02C5CB9163C80AC0F6CF1DD8E92D"}, {"00000000000000000000000000000000", "00010000000000000000000000000000", "FA321CF18EF5FE727DD82A5C1E945141"}, {"00000000000000000000000000000000", "00008000000000000000000000000000", "A5A7AFE1034C39CCCEBE3C584BC0BE05"}, {"00000000000000000000000000000000", "00004000000000000000000000000000", "4FF5A52E697E77D081205DBDB21CEA39"}, {"00000000000000000000000000000000", "00002000000000000000000000000000", "209E88DC94C9003000CE0769AF7B7166"}, {"00000000000000000000000000000000", "00001000000000000000000000000000", "5DEE41AF864CB4B650E5F51551824D38"}, {"00000000000000000000000000000000", "00000800000000000000000000000000", "A79A63FA7E4503AE6D6E09F5F9053030"}, {"00000000000000000000000000000000", "00000400000000000000000000000000", "A48316749FAE7FAC7002031A6AFD8BA7"}, {"00000000000000000000000000000000", "00000200000000000000000000000000", "D6EEE8A7357A0E1D64262CA9C337AC42"}, {"00000000000000000000000000000000", "00000100000000000000000000000000", "B013CA8A62A858053E9FB667ED39829E"}, {"00000000000000000000000000000000", "00000080000000000000000000000000", "DF6EA9E4538A45A52D5C1A43C88F4B55"}, {"00000000000000000000000000000000", "00000040000000000000000000000000", "7D03BA451371591D3FD5547D9165C73B"}, {"00000000000000000000000000000000", "00000020000000000000000000000000", "0E0426281A6277E186499D365D5F49FF"}, {"00000000000000000000000000000000", "00000010000000000000000000000000", "DBC02169DD2059E6CC4C57C1FEDF5AB4"}, {"00000000000000000000000000000000", "00000008000000000000000000000000", "826590E05D167DA6F00DCC75E22788EB"}, {"00000000000000000000000000000000", "00000004000000000000000000000000", "34A73F21A04421D9786335FAAB49423A"}, {"00000000000000000000000000000000", "00000002000000000000000000000000", "ED347D0E0128EE1A7392A1D36AB78AA9"}, {"00000000000000000000000000000000", "00000001000000000000000000000000", "EE944B2FE6E9FC888042608DA9615F75"}, {"00000000000000000000000000000000", "00000000800000000000000000000000", "9E7C85A909EF7218BA7947CFB4718F46"}, {"00000000000000000000000000000000", "00000000400000000000000000000000", "811AE07A0B2B1F816587FA73699AE77D"}, {"00000000000000000000000000000000", "00000000200000000000000000000000", "68466FBF43C2FE13D4B18F7EC5EA745F"}, {"00000000000000000000000000000000", "00000000100000000000000000000000", "D20B015C7191B219780956E6101F9354"}, {"00000000000000000000000000000000", "00000000080000000000000000000000", "5939D5C1BBF54EE1B3E326D757BDDE25"}, {"00000000000000000000000000000000", "00000000040000000000000000000000", "B1FDAFE9A0240E8FFEA19CE94B5105D3"}, {"00000000000000000000000000000000", "00000000020000000000000000000000", "D62962ECE02CDD68C06BDFEFB2F9495B"}, {"00000000000000000000000000000000", "00000000010000000000000000000000", "B3BB2DE6F3C26587BA8BAC4F7AD9499A"}, {"00000000000000000000000000000000", "00000000008000000000000000000000", "E0B1072D6D9FF703D6FBEF77852B0A6B"}, {"00000000000000000000000000000000", "00000000004000000000000000000000", "D8DD51C907F478DE0228E83E61FD1758"}, {"00000000000000000000000000000000", "00000000002000000000000000000000", "A42DFFE6E7C1671C06A25236FDD10017"}, {"00000000000000000000000000000000", "00000000001000000000000000000000", "25ACF141550BFAB9EF451B6C6A5B2163"}, {"00000000000000000000000000000000", "00000000000800000000000000000000", "4DA7FCA3949B16E821DBC84F19581018"}, {"00000000000000000000000000000000", "00000000000400000000000000000000", "7D49B6347CBCC8919C7FA96A37A7A215"}, {"00000000000000000000000000000000", "00000000000200000000000000000000", "900024B29A08C6721B95BA3B753DDB4D"}, {"00000000000000000000000000000000", "00000000000100000000000000000000", "6D2182FB283B6934D90BA7848CAB5E66"}, {"00000000000000000000000000000000", "00000000000080000000000000000000", "F73EF01B448D23A4D90DE8B2F9666E7A"}, {"00000000000000000000000000000000", "00000000000040000000000000000000", "4AD9CDA2418643E9A3D926AF5E6B0412"}, {"00000000000000000000000000000000", "00000000000020000000000000000000", "7CAEC8E7E5953997D545B033201C8C5B"}, {"00000000000000000000000000000000", "00000000000010000000000000000000", "3C43CA1F6B6864503E27B48D88230CF5"}, {"00000000000000000000000000000000", "00000000000008000000000000000000", "44F779B93108FE9FEEC880D79BA74488"}, {"00000000000000000000000000000000", "00000000000004000000000000000000", "9E50E8D9CFD3A682A78E527C9072A1CF"}, {"00000000000000000000000000000000", "00000000000002000000000000000000", "68D000CBC838BBE3C505D6F814C01F28"}, {"00000000000000000000000000000000", "00000000000001000000000000000000", "2CB2A9FEC1ACD1D9B0FA05205E304F57"}, {"00000000000000000000000000000000", "00000000000000800000000000000000", "01EB2806606E46444520A5CC6180CD4B"}, {"00000000000000000000000000000000", "00000000000000400000000000000000", "DAA9B25168CC702326F217F1A0C0B162"}, {"00000000000000000000000000000000", "00000000000000200000000000000000", "3E07E648975D9578D03555B1755807ED"}, {"00000000000000000000000000000000", "00000000000000100000000000000000", "0B45F52E802C8B8DE09579425B80B711"}, {"00000000000000000000000000000000", "00000000000000080000000000000000", "659595DA0B68F6DF0DD6CA77202986E1"}, {"00000000000000000000000000000000", "00000000000000040000000000000000", "05FF42873893536E58C8FA98A45C73C4"}, {"00000000000000000000000000000000", "00000000000000020000000000000000", "B5B03421DE8BBFFC4EADEC767339A9BD"}, {"00000000000000000000000000000000", "00000000000000010000000000000000", "788BCD111ECF73D4E78D2E21BEF55460"}, {"00000000000000000000000000000000", "00000000000000008000000000000000", "909CD9EC6790359F982DC6F2393D5315"}, {"00000000000000000000000000000000", "00000000000000004000000000000000", "332950F361535FF24EFAC8C76293F12C"}, {"00000000000000000000000000000000", "00000000000000002000000000000000", "A68CCD4E330FFDA9D576DA436DB53D75"}, {"00000000000000000000000000000000", "00000000000000001000000000000000", "27C8A1CCFDB0B015D1ED5B3E77143791"}, {"00000000000000000000000000000000", "00000000000000000800000000000000", "D76A4B95887A77DF610DD3E1D3B20325"}, {"00000000000000000000000000000000", "00000000000000000400000000000000", "C068AB0DE71C66DAE83C361EF4B2D989"}, {"00000000000000000000000000000000", "00000000000000000200000000000000", "C2120BCD49EDA9A288B3B4BE79AC8158"}, {"00000000000000000000000000000000", "00000000000000000100000000000000", "0C546F62BF2773CD0F564FCECA7BA688"}, {"00000000000000000000000000000000", "00000000000000000080000000000000", "18F3462BEDE4920213CCB66DAB1640AA"}, {"00000000000000000000000000000000", "00000000000000000040000000000000", "FE42F245EDD0E24B216AEBD8B392D690"}, {"00000000000000000000000000000000", "00000000000000000020000000000000", "3D3EEBC8D3D1558A194C2D00C337FF2B"}, {"00000000000000000000000000000000", "00000000000000000010000000000000", "29AAEDF043E785DB42836F79BE6CBA28"}, {"00000000000000000000000000000000", "00000000000000000008000000000000", "215F90C6744E2944358E78619159A611"}, {"00000000000000000000000000000000", "00000000000000000004000000000000", "8606B1AA9E1D548E5442B06551E2C6DC"}, {"00000000000000000000000000000000", "00000000000000000002000000000000", "987BB4B8740EC0EDE7FEA97DF033B5B1"}, {"00000000000000000000000000000000", "00000000000000000001000000000000", "C0A3500DA5B0AE07D2F450930BEEDF1B"}, {"00000000000000000000000000000000", "00000000000000000000800000000000", "525FDF8312FE8F32C781481A8DAAAE37"}, {"00000000000000000000000000000000", "00000000000000000000400000000000", "BFD2C56AE5FB9C9DE33A6944572A6487"}, {"00000000000000000000000000000000", "00000000000000000000200000000000", "7975A57A425CDF5AA1FA929101F650B0"}, {"00000000000000000000000000000000", "00000000000000000000100000000000", "BF174BC49609A8709B2CD8366DAA79FE"}, {"00000000000000000000000000000000", "00000000000000000000080000000000", "06C50C43222F56C874B1704E9F44BF7D"}, {"00000000000000000000000000000000", "00000000000000000000040000000000", "0CEC48CD34043EA29CA3B8ED5278721E"}, {"00000000000000000000000000000000", "00000000000000000000020000000000", "9548EA34A1560197B304D0ACB8A1698D"}, {"00000000000000000000000000000000", "00000000000000000000010000000000", "22F9E9B1BD73B6B5B7D3062C986272F3"}, {"00000000000000000000000000000000", "00000000000000000000008000000000", "FEE8E934BD0873295059002230E298D4"}, {"00000000000000000000000000000000", "00000000000000000000004000000000", "1B08E2E3EB820D139CB4ABBDBE81D00D"}, {"00000000000000000000000000000000", "00000000000000000000002000000000", "0021177681E4D90CEAF69DCED0145125"}, {"00000000000000000000000000000000", "00000000000000000000001000000000", "4A8E314452CA8A8A3619FC54BC423643"}, {"00000000000000000000000000000000", "00000000000000000000000800000000", "65047474F7222C94C6965425FF1BFD0A"}, {"00000000000000000000000000000000", "00000000000000000000000400000000", "E123F551A9C4A8489622B16F961A9AA4"}, {"00000000000000000000000000000000", "00000000000000000000000200000000", "EF05530948B80915028BB2B6FE429380"}, {"00000000000000000000000000000000", "00000000000000000000000100000000", "72535B7FE0F0F777CEDCD55CD77E2DDF"}, {"00000000000000000000000000000000", "00000000000000000000000080000000", "3423D8EFC31FA2F4C365C77D8F3B5C63"}, {"00000000000000000000000000000000", "00000000000000000000000040000000", "DE0E51C264663F3C5DBC59580A98D8E4"}, {"00000000000000000000000000000000", "00000000000000000000000020000000", "B2D9391166680947AB09264156719679"}, {"00000000000000000000000000000000", "00000000000000000000000010000000", "10DB79F23B06D263835C424AF749ADB7"}, {"00000000000000000000000000000000", "00000000000000000000000008000000", "DDF72D27E6B01EC107EA3E005B59563B"}, {"00000000000000000000000000000000", "00000000000000000000000004000000", "8266B57485A5954A4236751DE07F6694"}, {"00000000000000000000000000000000", "00000000000000000000000002000000", "669A501E1F1ADE6E5523DE01D6DBC987"}, {"00000000000000000000000000000000", "00000000000000000000000001000000", "C20C48F2989725D461D1DB589DC0896E"}, {"00000000000000000000000000000000", "00000000000000000000000000800000", "DE35158E7810ED1191825D2AA98FA97D"}, {"00000000000000000000000000000000", "00000000000000000000000000400000", "4FE294F2C0F34D0671B693A237EBDDC8"}, {"00000000000000000000000000000000", "00000000000000000000000000200000", "087AE74B10CCBFDF6739FEB9559C01A4"}, {"00000000000000000000000000000000", "00000000000000000000000000100000", "5DC278970B7DEF77A5536C77AB59C207"}, {"00000000000000000000000000000000", "00000000000000000000000000080000", "7607F078C77085184EAA9B060C1FBFFF"}, {"00000000000000000000000000000000", "00000000000000000000000000040000", "9DB841531BCBE7998DAD19993FB3CC00"}, {"00000000000000000000000000000000", "00000000000000000000000000020000", "D6A089B654854A94560BAE13298835B8"}, {"00000000000000000000000000000000", "00000000000000000000000000010000", "E1E223C4CF90CC5D195B370D65114622"}, {"00000000000000000000000000000000", "00000000000000000000000000008000", "1CBED73C50D053BDAD372CEEE54836A1"}, {"00000000000000000000000000000000", "00000000000000000000000000004000", "D309E69376D257ADF2BFDA152B26555F"}, {"00000000000000000000000000000000", "00000000000000000000000000002000", "740F7649117F0DEE6EAA7789A9994C36"}, {"00000000000000000000000000000000", "00000000000000000000000000001000", "76AE64417C297184D668C5FD908B3CE5"}, {"00000000000000000000000000000000", "00000000000000000000000000000800", "6095FEA4AA8035591F1787A819C48787"}, {"00000000000000000000000000000000", "00000000000000000000000000000400", "D1FF4E7ACD1C79967FEBAB0F7465D450"}, {"00000000000000000000000000000000", "00000000000000000000000000000200", "5F5AD3C42B9489557BB63BF49ECF5F8A"}, {"00000000000000000000000000000000", "00000000000000000000000000000100", "FB56CC09B680B1D07C5A52149E29F07C"}, {"00000000000000000000000000000000", "00000000000000000000000000000080", "FF49B8DF4A97CBE03833E66197620DAD"}, {"00000000000000000000000000000000", "00000000000000000000000000000040", "5E070ADE533D2E090ED0F5BE13BC0983"}, {"00000000000000000000000000000000", "00000000000000000000000000000020", "3AB4FB1D2B7BA376590A2C241D1F508D"}, {"00000000000000000000000000000000", "00000000000000000000000000000010", "58B2431BC0BEDE02550F40238969EC78"}, {"00000000000000000000000000000000", "00000000000000000000000000000008", "0253786E126504F0DAB90C48A30321DE"}, {"00000000000000000000000000000000", "00000000000000000000000000000004", "200211214E7394DA2089B6ACD093ABE0"}, {"00000000000000000000000000000000", "00000000000000000000000000000002", "0388DACE60B6A392F328C2B971B2FE78"}, {"00000000000000000000000000000000", "00000000000000000000000000000001", "58E2FCCEFA7E3061367F1D57A4E7455A"}, {"000000000000000000000000000000000000000000000000", "80000000000000000000000000000000", "6CD02513E8D4DC986B4AFE087A60BD0C"}, {"000000000000000000000000000000000000000000000000", "40000000000000000000000000000000", "423D2772A0CA56DAABB48D2129062987"}, {"000000000000000000000000000000000000000000000000", "20000000000000000000000000000000", "1021F2A8DA70EB2219DC16804445FF98"}, {"000000000000000000000000000000000000000000000000", "10000000000000000000000000000000", "C636E35B402577F96974D8804295EBB8"}, {"000000000000000000000000000000000000000000000000", "08000000000000000000000000000000", "1566D2E57E8393C19E29F892EA28A9A7"}, {"000000000000000000000000000000000000000000000000", "04000000000000000000000000000000", "883C878FED70B36CC09D040F9619DD19"}, {"000000000000000000000000000000000000000000000000", "02000000000000000000000000000000", "06734593A974965790E715594FC34AA9"}, {"000000000000000000000000000000000000000000000000", "01000000000000000000000000000000", "F19B389948D9A45534E5BD36C984134A"}, {"000000000000000000000000000000000000000000000000", "00800000000000000000000000000000", "D8410DFC14FA6D175EC968EA8CAC514C"}, {"000000000000000000000000000000000000000000000000", "00400000000000000000000000000000", "7E6C6EBB4029A177CF7B2FDD9AC6BB7A"}, {"000000000000000000000000000000000000000000000000", "00200000000000000000000000000000", "4B51DD4850DC0A6C3A46D924003D2C27"}, {"000000000000000000000000000000000000000000000000", "00100000000000000000000000000000", "2E510A9D917B15BE32A192B12A668F23"}, {"000000000000000000000000000000000000000000000000", "00080000000000000000000000000000", "88F6F79962B0FB77FEA8E7C632D3108E"}, {"000000000000000000000000000000000000000000000000", "00040000000000000000000000000000", "A3A35AB1D88DAF07B52794A0F065383A"}, {"000000000000000000000000000000000000000000000000", "00020000000000000000000000000000", "DC6CC878433E2B3BB193049A4ECBFC53"}, {"000000000000000000000000000000000000000000000000", "00010000000000000000000000000000", "EFCD3763EB7B1A415938248A9A5B4FD5"}, {"000000000000000000000000000000000000000000000000", "00008000000000000000000000000000", "AB7E9FB9A66DBE5BB44854F07D9015EE"}, {"000000000000000000000000000000000000000000000000", "00004000000000000000000000000000", "8B8E9D3365F8F6743ECF7E33E99255A4"}, {"000000000000000000000000000000000000000000000000", "00002000000000000000000000000000", "54D37B4F176FF3D8F6AFC866066D8572"}, {"000000000000000000000000000000000000000000000000", "00001000000000000000000000000000", "E83310889480FBF3C00342E3126D0D02"}, {"000000000000000000000000000000000000000000000000", "00000800000000000000000000000000", "D321AB2511F92F098174AA2DE6E85DA2"}, {"000000000000000000000000000000000000000000000000", "00000400000000000000000000000000", "D8E3F40B1112D5149D58C481DFA9983F"}, {"000000000000000000000000000000000000000000000000", "00000200000000000000000000000000", "2454C4E0806639DDF19854D6C68054AD"}, {"000000000000000000000000000000000000000000000000", "00000100000000000000000000000000", "A5506D410F7CA32F3955DD79D9D09418"}, {"000000000000000000000000000000000000000000000000", "00000080000000000000000000000000", "7908EE40677699568A7DC1AA317C7E4E"}, {"000000000000000000000000000000000000000000000000", "00000040000000000000000000000000", "B4B7B29DD43B2F5CF765E25192273982"}, {"000000000000000000000000000000000000000000000000", "00000020000000000000000000000000", "92AFE9668159BEFFE2A86F8503260164"}, {"000000000000000000000000000000000000000000000000", "00000010000000000000000000000000", "5C36A232FBA6D187A84657AD4028B18F"}, {"000000000000000000000000000000000000000000000000", "00000008000000000000000000000000", "A2E994DFAB3A798DF8F54F6DA87E58E2"}, {"000000000000000000000000000000000000000000000000", "00000004000000000000000000000000", "6CDAB10A72ADF77D71D0765BAAE95631"}, {"000000000000000000000000000000000000000000000000", "00000002000000000000000000000000", "9FE3C801BCAAF7BB800F2E6BF3278E21"}, {"000000000000000000000000000000000000000000000000", "00000001000000000000000000000000", "B459D90D9A6C392E5493BC91CF5A0863"}, {"000000000000000000000000000000000000000000000000", "00000000800000000000000000000000", "0518A9FA5007F6787E0FB4E5AC27D758"}, {"000000000000000000000000000000000000000000000000", "00000000400000000000000000000000", "BED9795415D28599700ED7952384A963"}, {"000000000000000000000000000000000000000000000000", "00000000200000000000000000000000", "F0140421173D60251EF6CAB0229B1B50"}, {"000000000000000000000000000000000000000000000000", "00000000100000000000000000000000", "460EB4652B3F6779EA28CB11B37529ED"}, {"000000000000000000000000000000000000000000000000", "00000000080000000000000000000000", "C4283D351C960A6AC13CD19CCF03AE38"}, {"000000000000000000000000000000000000000000000000", "00000000040000000000000000000000", "6815A10047B2C834A798EBDCC6786C75"}, {"000000000000000000000000000000000000000000000000", "00000000020000000000000000000000", "99BA19F0CDD5990D0386B32CE56C9C4C"}, {"000000000000000000000000000000000000000000000000", "00000000010000000000000000000000", "DE76F62C61E07915162DA13E79679DEC"}, {"000000000000000000000000000000000000000000000000", "00000000008000000000000000000000", "DD0325D6854803D06D1D2277D5FB8D67"}, {"000000000000000000000000000000000000000000000000", "00000000004000000000000000000000", "580B71A41DE37D6FAC83CCB0B3BB1C97"}, {"000000000000000000000000000000000000000000000000", "00000000002000000000000000000000", "E9B1AB470A1B02EF0FF5E6754A092C96"}, {"000000000000000000000000000000000000000000000000", "00000000001000000000000000000000", "8590620F5AF5993B7410282F4126BC1F"}, {"000000000000000000000000000000000000000000000000", "00000000000800000000000000000000", "8D4914D2F1B22B2E268E66E532D29D7C"}, {"000000000000000000000000000000000000000000000000", "00000000000400000000000000000000", "FD826CE48E62C5E30867044B86BA4B56"}, {"000000000000000000000000000000000000000000000000", "00000000000200000000000000000000", "100E7B831C9F35FA1271F5F1316C6FCF"}, {"000000000000000000000000000000000000000000000000", "00000000000100000000000000000000", "0A2DD0C17F68B996AA96C007003D0B31"}, {"000000000000000000000000000000000000000000000000", "00000000000080000000000000000000", "C95F68C57E06B0A2E1F623C83C5D80BF"}, {"000000000000000000000000000000000000000000000000", "00000000000040000000000000000000", "571CAFC92C7C8A5EC54C0741E186905C"}, {"000000000000000000000000000000000000000000000000", "00000000000020000000000000000000", "22514353E95312C112255E1EED0B2DF6"}, {"000000000000000000000000000000000000000000000000", "00000000000010000000000000000000", "791A8BF462BD17580BD9152C6D11C6C5"}, {"000000000000000000000000000000000000000000000000", "00000000000008000000000000000000", "5882A0178D548F84A165DB809C60DC28"}, {"000000000000000000000000000000000000000000000000", "00000000000004000000000000000000", "3CE4A90EED4458CA6039E42DDADB71C3"}, {"000000000000000000000000000000000000000000000000", "00000000000002000000000000000000", "D3CBAB261207A16BE2751E77044FD7C9"}, {"000000000000000000000000000000000000000000000000", "00000000000001000000000000000000", "24E32B698A7B32217093628B01F424AB"}, {"000000000000000000000000000000000000000000000000", "00000000000000800000000000000000", "9F6AFC0AF27CF565110C77E3C24F4F5B"}, {"000000000000000000000000000000000000000000000000", "00000000000000400000000000000000", "E088AA5CDA20EF267BB039B00C72C45B"}, {"000000000000000000000000000000000000000000000000", "00000000000000200000000000000000", "5CF1018B7E0BA1775601C2E279900360"}, {"000000000000000000000000000000000000000000000000", "00000000000000100000000000000000", "3B1A7388B89FB9416AD8753CF5AF35D2"}, {"000000000000000000000000000000000000000000000000", "00000000000000080000000000000000", "137FA4ED00AFCD9F5D8BC0D14BD5837A"}, {"000000000000000000000000000000000000000000000000", "00000000000000040000000000000000", "806F5C9B663559BB56F234881E4A3E60"}, {"000000000000000000000000000000000000000000000000", "00000000000000020000000000000000", "8069A449152292DF2DE8642992C632B6"}, {"000000000000000000000000000000000000000000000000", "00000000000000010000000000000000", "37C6CF2A1ABD1B1F1922B46C7B4A280D"}, {"000000000000000000000000000000000000000000000000", "00000000000000008000000000000000", "7A2835260E5A0AA2B5DC301800EC8438"}, {"000000000000000000000000000000000000000000000000", "00000000000000004000000000000000", "EE81FAF2F9058213FFCACF281CB8509E"}, {"000000000000000000000000000000000000000000000000", "00000000000000002000000000000000", "57F22D93C37129BA331FDBA38E005A1E"}, {"000000000000000000000000000000000000000000000000", "00000000000000001000000000000000", "EC798782E87B7D9F780CC3C3A46519B5"}, {"000000000000000000000000000000000000000000000000", "00000000000000000800000000000000", "43EA28497F5D40E3A4744FA2EDAA42DE"}, {"000000000000000000000000000000000000000000000000", "00000000000000000400000000000000", "91F004E7DEBF41B3414DD8C5C317372C"}, {"000000000000000000000000000000000000000000000000", "00000000000000000200000000000000", "C249EAE54E7B4DF43B938C1B4CC28314"}, {"000000000000000000000000000000000000000000000000", "00000000000000000100000000000000", "32C289D7EEFB99D2F17AD7B7D45FE1EC"}, {"000000000000000000000000000000000000000000000000", "00000000000000000080000000000000", "A675FB2E8DDBF810CEF01CF2B728CD2B"}, {"000000000000000000000000000000000000000000000000", "00000000000000000040000000000000", "A418AAAB6E6921CC731AA8A349386080"}, {"000000000000000000000000000000000000000000000000", "00000000000000000020000000000000", "2E2B0F44863E67D9B0215C4ABD60417F"}, {"000000000000000000000000000000000000000000000000", "00000000000000000010000000000000", "F0AF7CB19E911D481F6426DAEFDD2240"}, {"000000000000000000000000000000000000000000000000", "00000000000000000008000000000000", "CB1304DAAA2DF6878F56AC2E0F887E04"}, {"000000000000000000000000000000000000000000000000", "00000000000000000004000000000000", "B1B70A7E6A0CD1916D9B78BEA19084AE"}, {"000000000000000000000000000000000000000000000000", "00000000000000000002000000000000", "0CDE9F9BE646A5FCE3436B794A9CFC65"}, {"000000000000000000000000000000000000000000000000", "00000000000000000001000000000000", "68C7946D476A0A36674B36AFD7E5DF33"}, {"000000000000000000000000000000000000000000000000", "00000000000000000000800000000000", "48770159A07DD8DFFF06C80105F8D57C"}, {"000000000000000000000000000000000000000000000000", "00000000000000000000400000000000", "665E62801B3260E3C45BD3BE34DFDEBE"}, {"000000000000000000000000000000000000000000000000", "00000000000000000000200000000000", "4159C1F686BFBE5B0E50BDB0DA532B69"}, {"000000000000000000000000000000000000000000000000", "00000000000000000000100000000000", "6333100A5A4AD917DC2D4E78A04869A3"}, {"000000000000000000000000000000000000000000000000", "00000000000000000000080000000000", "866A4519AB1D199F25886B89D0539ACC"}, {"000000000000000000000000000000000000000000000000", "00000000000000000000040000000000", "EC0CFD37E4CBC7E8BE385283F7AEA75A"}, {"000000000000000000000000000000000000000000000000", "00000000000000000000020000000000", "CA2F383AACCA0810AA13F3E710621422"}, {"000000000000000000000000000000000000000000000000", "00000000000000000000010000000000", "1D0EEF6870444F950937831EC0A55D98"}, {"000000000000000000000000000000000000000000000000", "00000000000000000000008000000000", "37839B35ED6801E7670496D479A95017"}, {"000000000000000000000000000000000000000000000000", "00000000000000000000004000000000", "02317C8C7098C4F94AB867AC7A49DD8D"}, {"000000000000000000000000000000000000000000000000", "00000000000000000000002000000000", "FFB4CB4E3F7F8BF3367EBD43236518B4"}, {"000000000000000000000000000000000000000000000000", "00000000000000000000001000000000", "36BEDEF1E4AA3E4A40A305741713FCBF"}, {"000000000000000000000000000000000000000000000000", "00000000000000000000000800000000", "B2DFE3C4870269C1E3FEEC39161540D9"}, {"000000000000000000000000000000000000000000000000", "00000000000000000000000400000000", "147EF2518AD45DA0026056ECBF6A3DFA"}, {"000000000000000000000000000000000000000000000000", "00000000000000000000000200000000", "027A75E4DE635790E47ACE90D7928804"}, {"000000000000000000000000000000000000000000000000", "00000000000000000000000100000000", "C4CF3CCB59BF87D0AFBD629F48CFBB7B"}, {"000000000000000000000000000000000000000000000000", "00000000000000000000000080000000", "35165C93F564C97E1C32EF97E8151A87"}, {"000000000000000000000000000000000000000000000000", "00000000000000000000000040000000", "449DE37F7D5A1BBD628ABBE7E061701D"}, {"000000000000000000000000000000000000000000000000", "00000000000000000000000020000000", "B1D45EAF218F1799B149BAD677FE129F"}, {"000000000000000000000000000000000000000000000000", "00000000000000000000000010000000", "BE08AC6DB6BD0583AA9D2ABC71C73DCD"}, {"000000000000000000000000000000000000000000000000", "00000000000000000000000008000000", "BCC835BD3DF1A79E4C7C145B899A5C25"}, {"000000000000000000000000000000000000000000000000", "00000000000000000000000004000000", "3D311EA611FF5AF371301C58A8E9912D"}, {"000000000000000000000000000000000000000000000000", "00000000000000000000000002000000", "A5A1BEA594ACC7CA80F09EA5ADDB5C71"}, {"000000000000000000000000000000000000000000000000", "00000000000000000000000001000000", "0F09492429FE7222D6CD8190D9F2FFBF"}, {"000000000000000000000000000000000000000000000000", "00000000000000000000000000800000", "816D2220A16B8AAEE71364FD43636C6F"}, {"000000000000000000000000000000000000000000000000", "00000000000000000000000000400000", "D7E8702408419ED73191B107EAF75A0B"}, {"000000000000000000000000000000000000000000000000", "00000000000000000000000000200000", "9B170EFB1E235B433C78E276BEA082F0"}, {"000000000000000000000000000000000000000000000000", "00000000000000000000000000100000", "03BBECC5598AE974430F29395522F096"}, {"000000000000000000000000000000000000000000000000", "00000000000000000000000000080000", "DB53517766C0E8CF42059607CBA89380"}, {"000000000000000000000000000000000000000000000000", "00000000000000000000000000040000", "2E2AF4B7931F0AEFFAC5471148A5BB97"}, {"000000000000000000000000000000000000000000000000", "00000000000000000000000000020000", "C872C0408266403B984F635FF5683DE4"}, {"000000000000000000000000000000000000000000000000", "00000000000000000000000000010000", "15DCF750B0E3A68AD1F4EFD07E8967B4"}, {"000000000000000000000000000000000000000000000000", "00000000000000000000000000008000", "B41092048E9E6A749F6FD8CE515A23A3"}, {"000000000000000000000000000000000000000000000000", "00000000000000000000000000004000", "4DA9267D62507994312BD5C99ADDE730"}, {"000000000000000000000000000000000000000000000000", "00000000000000000000000000002000", "9E2FCA6D1D626E9C6A924EBF7DBF618A"}, {"000000000000000000000000000000000000000000000000", "00000000000000000000000000001000", "E092E8D7EF2C2465AEFB2493C3063590"}, {"000000000000000000000000000000000000000000000000", "00000000000000000000000000000800", "1C0E58DA37D1068378A88DBE2EDE4E10"}, {"000000000000000000000000000000000000000000000000", "00000000000000000000000000000400", "19063F854232B8509A6A3A6D46809959"}, {"000000000000000000000000000000000000000000000000", "00000000000000000000000000000200", "447FB09E54EFA285F7530F25C4EA0022"}, {"000000000000000000000000000000000000000000000000", "00000000000000000000000000000100", "F6ABE86321BE40E1FBFDAFED37CC1D9B"}, {"000000000000000000000000000000000000000000000000", "00000000000000000000000000000080", "4E8506CD006666341D6CF51F98B41F35"}, {"000000000000000000000000000000000000000000000000", "00000000000000000000000000000040", "53995DE0009CA18BECAFB8307C54C14C"}, {"000000000000000000000000000000000000000000000000", "00000000000000000000000000000020", "2006BF99F4C58B6CC2627856593FAEEA"}, {"000000000000000000000000000000000000000000000000", "00000000000000000000000000000010", "2DA697D2737CB30B744A4644FA1CBC6E"}, {"000000000000000000000000000000000000000000000000", "00000000000000000000000000000008", "47A22ACDB60C3A986A8F76ECD0EA3433"}, {"000000000000000000000000000000000000000000000000", "00000000000000000000000000000004", "FDAA17C2CDE20268FE36E164EA532151"}, {"000000000000000000000000000000000000000000000000", "00000000000000000000000000000002", "98E7247C07F0FE411C267E4384B0F600"}, {"000000000000000000000000000000000000000000000000", "00000000000000000000000000000001", "CD33B28AC773F74BA00ED1F312572435"}, {"0000000000000000000000000000000000000000000000000000000000000000", "80000000000000000000000000000000", "DDC6BF790C15760D8D9AEB6F9A75FD4E"}, {"0000000000000000000000000000000000000000000000000000000000000000", "40000000000000000000000000000000", "C7098C217C334D0C9BDF37EA13B0822C"}, {"0000000000000000000000000000000000000000000000000000000000000000", "20000000000000000000000000000000", "60F0FB0D4C56A8D4EEFEC5264204042D"}, {"0000000000000000000000000000000000000000000000000000000000000000", "10000000000000000000000000000000", "73376FBBF654D0686E0E84001477106B"}, {"0000000000000000000000000000000000000000000000000000000000000000", "08000000000000000000000000000000", "2F443B52BA5F0C6EA0602C7C4FD259B6"}, {"0000000000000000000000000000000000000000000000000000000000000000", "04000000000000000000000000000000", "75D11B0E3A68C4223D88DBF017977DD7"}, {"0000000000000000000000000000000000000000000000000000000000000000", "02000000000000000000000000000000", "779B38D15BFFB63D8D609D551A5CC98E"}, {"0000000000000000000000000000000000000000000000000000000000000000", "01000000000000000000000000000000", "5275F3D86B4FB8684593133EBFA53CD3"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00800000000000000000000000000000", "1CEF2074B336CEC62F12DEA2F6AB1481"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00400000000000000000000000000000", "1AEF5ABBAD9D7160874578DCD8BAE172"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00200000000000000000000000000000", "46C525DB17E72F26BF03216846B6F609"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00100000000000000000000000000000", "E24411F941BBE08788781E3EC52CBAA4"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00080000000000000000000000000000", "83A3DEDD1DD27018F6A6477E40527581"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00040000000000000000000000000000", "B68F8A2CDBAB0C923C67FC8F0F1087DE"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00020000000000000000000000000000", "649944A70C32BF87A7409E7AE128FDE8"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00010000000000000000000000000000", "2846526D67387539C89314DE9E0C2D02"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00008000000000000000000000000000", "A9A0B8402E53C70DD1688054BA58DDFD"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00004000000000000000000000000000", "4A72E6E1B79C83AC4BE3EBA5699EED48"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00002000000000000000000000000000", "B0E36B867BA4FF2B77D0614B0E364E4C"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00001000000000000000000000000000", "49B57DE141F6418E3090F24DDD4014B6"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00000800000000000000000000000000", "A6C0D5B9797258E1987AC5F6CD20146D"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00000400000000000000000000000000", "426CF4BDCAA369175965D26E7C71EEA2"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00000200000000000000000000000000", "E27F484CE54BC99BC1A52BDA3B518A26"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00000100000000000000000000000000", "D16D186284C7E6EE64B8104E0EF20BA5"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00000080000000000000000000000000", "6431F8538AD54E1E044A9F71F8EF556B"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00000040000000000000000000000000", "ECD57CEB451D27EB96C55B2042257E8E"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00000020000000000000000000000000", "4F0F188DC911B1954AFBC734C9F68872"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00000010000000000000000000000000", "B54DEF0337626B65614E81EDFDE620F3"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00000008000000000000000000000000", "6655D8074CAE0B90B0D3A3FE72D4D9DB"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00000004000000000000000000000000", "C6B74B6B9EB4FC0C9A237DB1B616D09A"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00000002000000000000000000000000", "D7B5D076EA56EC2B20791D7AD51CCF8F"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00000001000000000000000000000000", "FE160C224BF003CE3BDDC90CB52ED22C"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00000000800000000000000000000000", "5E00DA9BA94B5EC0D258D8A8002E0F6A"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00000000400000000000000000000000", "09AC6DCFF4DACFF1651E2BA212A292A3"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00000000200000000000000000000000", "B283617E318D99AF83A05D9810BA89F7"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00000000100000000000000000000000", "0B5F70CCB40B0EF2538AE9B4A9770B35"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00000000080000000000000000000000", "43282BF180248FB517839B37F4DDAAE4"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00000000040000000000000000000000", "DDBD534C8B2E6D30A268F88C55AD765B"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00000000020000000000000000000000", "A41A164E50EC2D9F175E752B755E0B5C"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00000000010000000000000000000000", "37BFF99FF2F7AA97779E4ADF6F13FB10"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00000000008000000000000000000000", "9BA4F7BD298152903A683C4CEC669216"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00000000004000000000000000000000", "5FB750C7CE10DE7B4504248914D0DA06"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00000000002000000000000000000000", "3E748BFA108E086F51D56EC74A9E0FB9"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00000000001000000000000000000000", "31D4E56B99F5B73C1B8437DF332AFB98"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00000000000800000000000000000000", "9DC6717B84FC55D266E7B1D9B5C52A5F"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00000000000400000000000000000000", "8EF8BA007F23C0A50FC120E07041BCCD"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00000000000200000000000000000000", "C58F38E1839FC1918A12B8C9E88C66B6"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00000000000100000000000000000000", "B695D72A3FCF508C4050E12E40061C2D"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00000000000080000000000000000000", "5D2736AD478A50583BC8C11BEFF16D7A"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00000000000040000000000000000000", "DF0EACA8F17847AD41F9578F14C7B56B"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00000000000020000000000000000000", "E5AA14AD48AD0A3C47CC35D5F8020E51"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00000000000010000000000000000000", "11BE6C8F58EBD8CEF1A53F591A68E8CE"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00000000000008000000000000000000", "ECFE7BAFCBF42C1FEE015488770B3053"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00000000000004000000000000000000", "E552649F8D8EC4A1E1CD6DF50B6E6777"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00000000000002000000000000000000", "521C0629DE93B9119CDB1DDC5809DDEA"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00000000000001000000000000000000", "CB38A62A0BAB1784156BA038CBA99BF6"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00000000000000800000000000000000", "76CCEE8AAACD394DE1EEF3DDA10CB54B"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00000000000000400000000000000000", "6AFF910FA1D5673140E2DB59B8416049"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00000000000000200000000000000000", "064A12C0EF73FB386801BF4F35F3120D"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00000000000000100000000000000000", "2240E374929D5B1BB8FF0FFDDDF640EC"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00000000000000080000000000000000", "D4BA15C904C7692185DE85C02052E180"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00000000000000040000000000000000", "1714A315AB0166728A44CD91D4AE9018"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00000000000000020000000000000000", "6C970BDD9F0E222722EA31A1D12DD0AD"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00000000000000010000000000000000", "F5956EDF02BD36A401BBB6CE77C3D3FB"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00000000000000008000000000000000", "0CA11F122CCD7C259DC597EED3DF9BC4"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00000000000000004000000000000000", "50109AB4912AD2560B206F331B62EB6C"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00000000000000002000000000000000", "DBE7C91A4175614889A2D4BEFD64845E"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00000000000000001000000000000000", "0D3322853A571A6B46B79C0228E0DD25"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00000000000000000800000000000000", "96E4EE0BB9A11C6FB8522F285BADDEB6"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00000000000000000400000000000000", "96705C52D2CFCE82E630C93477C79C49"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00000000000000000200000000000000", "C50130AED6A126149D71F3888C83C232"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00000000000000000100000000000000", "4816EFE3DEB380566EBA0C17BF582090"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00000000000000000080000000000000", "0390857B4C8C98E4CF7A2B6F3394C507"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00000000000000000040000000000000", "422E73A02025EBE8B8B5D6E0FA24FCB2"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00000000000000000020000000000000", "3271AA7F4BF1D7C38050A43076D4FF76"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00000000000000000010000000000000", "D2074946F0D37B8975607BFC2E70234C"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00000000000000000008000000000000", "1A509194C1270AB92E5A42D3A9F8D98B"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00000000000000000004000000000000", "512438946360CCC4A5C6D73F6EED7130"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00000000000000000002000000000000", "98CFCDEC46EBEA1A286B3004F2746A0D"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00000000000000000001000000000000", "A1CF369949677A3AF3D58E3EABF2741B"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00000000000000000000800000000000", "D84C2E1A0E4A52166FA8FF6889D1E5E2"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00000000000000000000400000000000", "4AD91CCEEF60119B5078FD162D2735DE"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00000000000000000000200000000000", "2860793D818E97AAFF1D339D7702438D"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00000000000000000000100000000000", "6F9068BE73364AE250D89D78A6C9CE6F"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00000000000000000000080000000000", "024FC3FEF4883FEB1A8DD005305FECCE"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00000000000000000000040000000000", "08A61FE0816D75EA15EB3C9FB9CCDED6"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00000000000000000000020000000000", "449C86DFA13F260175CE39797686FFA4"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00000000000000000000010000000000", "4FFFFC29A59858E1133F2BFB1A8A4817"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00000000000000000000008000000000", "19425D1F6480B25096561295697DC2B7"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00000000000000000000004000000000", "31974727ECDD2C77C3A428FC3A8CB3FC"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00000000000000000000002000000000", "A57CD704B3C95E744D08DF443458F2F5"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00000000000000000000001000000000", "486D8C193DB1ED73ACB17990442FC40B"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00000000000000000000000800000000", "5E4DBF4E83AB3BC055B9FCC7A6B3A763"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00000000000000000000000400000000", "ACF2E0A693FBBCBA4D41B861E0D89E37"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00000000000000000000000200000000", "32A7CB2AE066A51D2B78FC4B4CFCB608"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00000000000000000000000100000000", "677D494DBB73CAF55C1990158DA12F14"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00000000000000000000000080000000", "082A0D2367512ADF0D75A151BFBE0A17"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00000000000000000000000040000000", "5E5BB7337923C482CE8CBA249E6A8C7D"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00000000000000000000000020000000", "D3001BA7C7026EE3E5003179530AFCFC"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00000000000000000000000010000000", "46EC44F8931E629FE8FD8961312EDDE1"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00000000000000000000000008000000", "C5F8ECD79C7B30E81D17E32079969310"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00000000000000000000000004000000", "5B8AD6919E24CAEBCC55401AEE0C9802"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00000000000000000000000002000000", "C2302B7E701B5CC7F8B29E3516DBBFA6"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00000000000000000000000001000000", "A1D04D6A76F9F7A94D49FAA64A87F244"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00000000000000000000000000800000", "7FB6F92D35B5CB6C631600EDB9E860BA"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00000000000000000000000000400000", "B2EF7078BCFACE07AEEC3F9B48830EB3"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00000000000000000000000000200000", "F475A7493D24C7036E53390374C378B3"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00000000000000000000000000100000", "B36802AC987377A37BD8EADC97C57D60"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00000000000000000000000000080000", "ADDCD3D19689C4DDC738CE5F69DC9505"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00000000000000000000000000040000", "0DAF8CA22884915403C0F0BB1F4BD74F"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00000000000000000000000000020000", "4AF36BAE2660503B3248E4685059FD05"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00000000000000000000000000010000", "7D5631814DD8E917D97A0D514C743971"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00000000000000000000000000008000", "BC3352500FC0CBB9DB5B5F6B491C1BE8"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00000000000000000000000000004000", "6A4A30BA87E87AF65C90AEB7AFEDC76B"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00000000000000000000000000002000", "77E6125897668AC8E73E8C79A6FF8336"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00000000000000000000000000001000", "3FA9D39104EBB323C7AAAA248960DD1E"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00000000000000000000000000000800", "FAD75AD76AB10ADC49036B250E229D39"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00000000000000000000000000000400", "2FACAA5FE35B228A16AC74088D702EC4"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00000000000000000000000000000200", "88B6CBCFDFEF8AD91720A1BB69A1F33E"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00000000000000000000000000000100", "C7E9D250998632D444356242EF04058D"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00000000000000000000000000000080", "B14DAD8D3D9153F46C0D3A1AD63C7A05"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00000000000000000000000000000040", "60ABA678A506608D0845966D29B5F790"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00000000000000000000000000000020", "482DC43F2388EF25D24144E144BD834E"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00000000000000000000000000000010", "1490A05A7CEE43BDE98B56E309DC0126"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00000000000000000000000000000008", "ABFA77CD6E85DA245FB0BDC5E52CFC29"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00000000000000000000000000000004", "DD4AB1284D4AE17B41E85924470C36F7"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00000000000000000000000000000002", "CEA7403D4D606B6E074EC5D3BAF39D18"}, {"0000000000000000000000000000000000000000000000000000000000000000", "00000000000000000000000000000001", "530F8AFBC74536B9A963B4F1C4CB738B"}};

    protected void doIt() throws Exception {
        Security.addProvider((Provider)new Cryptix());
        this.testCipher(TEST_VALUES);
    }

    protected TestRijndael() {
        super(NAME);
    }
}

