/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.test;

import cryptix.jce.provider.Cryptix;
import cryptix.jce.test.Test;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.security.interfaces.RSAPublicKey;
import javax.crypto.Cipher;

class TestRSA
extends Test {
    private static SecureRandom random = new SecureRandom();

    protected void doIt() {
        Security.addProvider((Provider)new Cryptix());
        while (true) {
            long start = System.currentTimeMillis();
            this.doItPrivate2();
            this.doItPrivate1();
            long delta = (System.currentTimeMillis() - start) / 1000L;
            System.out.println("duration: " + delta + "s");
        }
    }

    /*
     * WARNING - void declaration
     */
    private void doItPrivate1() {
        void var1_1;
        this.beginTest("RSA Signing");
        boolean res = false;
        try {
            KeyPairGenerator gen = KeyPairGenerator.getInstance("RSA");
            gen.initialize(768);
            KeyPair pair = gen.generateKeyPair();
            System.out.println(pair);
            System.out.println(((RSAPublicKey)pair.getPublic()).getModulus());
            Signature sig = Signature.getInstance("SHA1withRSA");
            System.out.println("sig: " + sig);
            sig.initSign(pair.getPrivate());
            System.out.println("sig: " + sig);
            sig.update((byte)0);
            byte[] signed = sig.sign();
            System.out.println("signed: " + signed);
            sig.initVerify(pair.getPublic());
            System.out.println("sig: " + sig);
            sig.update((byte)0);
            System.out.println("" + sig.verify(signed));
            signed[0] = ~signed[0];
            System.out.println("" + sig.verify(signed));
            res = true;
        }
        catch (Throwable t) {
            void var2_3;
            var2_3.printStackTrace();
        }
        this.passIf((boolean)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void doItPrivate2() {
        void var1_1;
        this.beginTest("RSA Crypting");
        boolean res = false;
        try {
            KeyPairGenerator gen = KeyPairGenerator.getInstance("RSA");
            gen.initialize(768);
            KeyPair pair = gen.generateKeyPair();
            System.out.println(pair);
            System.out.println(((RSAPublicKey)pair.getPublic()).getModulus());
            Cipher c = Cipher.getInstance("RSA/ECB/PKCS#1");
            System.out.println("c: " + c);
            res = true;
        }
        catch (Throwable t) {
            void var2_3;
            var2_3.printStackTrace();
        }
        this.passIf((boolean)var1_1);
    }

    TestRSA() {
        super("RSA");
    }
}

