/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.test;

import cryptix.jce.provider.Cryptix;
import cryptix.jce.test.Test;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.security.Provider;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;

final class TestCipherStream
extends Test {
    private static final String name = "CipherStreams";
    private Cipher c;
    private Cipher d;
    private final String s;
    private String algo;
    private int KEY_SIZE;

    protected void doIt() throws Exception {
        this.init();
        this.beginTest("COS(file, ENCRYPT) -> CIS(file, DECRYPT)");
        this.passIf(this.test1(this.c, this.d, "ThisIsASecretSecretMessageOfNull"));
        this.beginTest("CIS(CIS(file, ENCRYPT), DECRYPT)");
        this.passIf(this.test2(this.c, this.d, "ThisIsASecretSecretMessageOfNull"));
        this.beginTest("COS(COS(file, DECRYPT), ENCRYPT)");
        this.passIf(this.test3(this.c, this.d, "ThisIsASecretSecretMessageOfNull"));
    }

    private void init() throws Exception {
        Security.addProvider((Provider)new Cryptix());
        KeyGenerator kg = KeyGenerator.getInstance(this.algo);
        kg.init(this.KEY_SIZE);
        SecretKey sk = kg.generateKey();
        this.algo = this.algo + "/ECB/NoPadding";
        this.c = Cipher.getInstance(this.algo);
        this.d = Cipher.getInstance(this.algo);
        this.c.init(1, sk);
        this.d.init(2, sk);
    }

    private boolean test1(Cipher c, Cipher d, String s) throws Exception {
        int i;
        File file = File.createTempFile("slask", null);
        byte[] b = s.getBytes();
        FileOutputStream fos = new FileOutputStream(file);
        CipherOutputStream cos = new CipherOutputStream(fos, c);
        cos.write(b);
        cos.flush();
        cos.close();
        fos.close();
        FileInputStream fis = new FileInputStream(file);
        CipherInputStream cis = new CipherInputStream(fis, d);
        byte[] rb = new byte[8];
        StringBuffer sb = new StringBuffer();
        int a = 0;
        while ((i = cis.read(rb)) != -1) {
            sb.append(new String(rb, 0, i));
            a += i;
        }
        return sb.toString().equals(s);
    }

    private boolean test2(Cipher c, Cipher d, String s) throws Exception {
        int i;
        File file1 = File.createTempFile("slask1", null);
        File file2 = File.createTempFile("slask2", null);
        FileWriter fw = new FileWriter(file1);
        fw.write(s);
        fw.close();
        FileInputStream fis = new FileInputStream(file1);
        CipherInputStream cis1 = new CipherInputStream(fis, c);
        CipherInputStream cis2 = new CipherInputStream(cis1, d);
        FileOutputStream fos = new FileOutputStream(file2);
        byte[] b = new byte[8];
        while ((i = cis2.read(b)) != -1) {
            fos.write(b, 0, i);
        }
        cis1.close();
        cis2.close();
        fis.close();
        fos.close();
        FileReader fr = new FileReader(file2);
        char[] rb = new char[8];
        StringBuffer sb = new StringBuffer();
        while ((i = fr.read(rb)) != -1) {
            sb.append(new String(rb, 0, i));
        }
        fr.close();
        return sb.toString().equals(s);
    }

    private boolean test3(Cipher c, Cipher d, String s) throws Exception {
        int i;
        File file1 = File.createTempFile("slask1", null);
        File file2 = File.createTempFile("slask2", null);
        FileWriter fw = new FileWriter(file1);
        fw.write(s);
        fw.close();
        FileInputStream fis = new FileInputStream(file1);
        FileOutputStream fos = new FileOutputStream(file2);
        CipherOutputStream cos1 = new CipherOutputStream(fos, d);
        CipherOutputStream cos2 = new CipherOutputStream(cos1, c);
        byte[] b = new byte[8];
        while ((i = fis.read(b)) != -1) {
            cos2.write(b, 0, i);
        }
        cos2.flush();
        cos2.close();
        FileReader fr = new FileReader(file2);
        char[] rb = new char[8];
        StringBuffer sb = new StringBuffer();
        while ((i = fr.read(rb)) != -1) {
            sb.append(new String(rb, 0, i));
        }
        fr.close();
        return sb.toString().equals(s);
    }

    protected TestCipherStream(String algo, int KEY_SIZE) {
        super(name);
        this.s = "ThisIsASecretSecretMessageOfNull";
        this.algo = algo;
        this.KEY_SIZE = KEY_SIZE;
    }

    protected TestCipherStream() {
        super(name);
        this.s = "ThisIsASecretSecretMessageOfNull";
        this.algo = "DES";
        this.KEY_SIZE = 56;
    }
}

