/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.test;

import cryptix.jce.provider.Cryptix;
import cryptix.jce.test.Test;
import java.security.AlgorithmParameters;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;

final class TestAlgorithmParameters
extends Test {
    private static final String name = "AlgorithmParameters";
    private Cipher c;
    private SecretKey sk;
    private String algo;
    private int KEY_SIZE;

    protected void doIt() throws Exception {
        this.init();
        this.beginTest("test with parameters only AlgorithmParameters");
        this.passIf(this.test1());
        this.beginTest("test with parameters from Cipher");
        this.passIf(this.test2(this.c) && this.test3(this.c));
    }

    private void init() throws Exception {
        Security.addProvider((Provider)new Cryptix());
        KeyGenerator kg = KeyGenerator.getInstance(this.algo);
        kg.init(this.KEY_SIZE);
        this.sk = kg.generateKey();
        this.c = Cipher.getInstance(this.algo + "/CBC/NONE");
        this.c.init(1, this.sk);
    }

    private boolean test1() throws Exception {
        byte[] iv = new byte[8];
        new SecureRandom().nextBytes(iv);
        AlgorithmParameters ap1 = AlgorithmParameters.getInstance("DES");
        ap1.init(new IvParameterSpec(iv));
        String a = ap1.getAlgorithm();
        String ivs = ap1.toString();
        String p = ap1.getProvider().getName();
        byte[] enc = ap1.getEncoded();
        AlgorithmParameters ap2 = AlgorithmParameters.getInstance(a, p);
        ap2.init(enc);
        return a.equals(ap2.getAlgorithm()) && ivs.equals(ap2.toString()) && p.equals(ap2.getProvider().getName());
    }

    private boolean test2(Cipher c) throws Exception {
        AlgorithmParameters ap1 = c.getParameters();
        String a = ap1.getAlgorithm();
        String ivs = ap1.toString();
        String p = ap1.getProvider().getName();
        byte[] enc = ap1.getEncoded();
        AlgorithmParameters ap2 = AlgorithmParameters.getInstance(this.algo);
        ap2.init(enc);
        return a.equals(ap2.getAlgorithm()) && ivs.equals(ap2.toString()) && p.equals(ap2.getProvider().getName());
    }

    private boolean test3(Cipher c) throws Exception {
        byte[] iv = c.getIV();
        AlgorithmParameters ap1 = c.getParameters();
        String a = ap1.getAlgorithm();
        String ivs = ap1.toString();
        String p = ap1.getProvider().getName();
        AlgorithmParameters ap2 = AlgorithmParameters.getInstance(this.algo);
        ap2.init(new IvParameterSpec(iv));
        return a.equals(ap2.getAlgorithm()) && ivs.equals(ap2.toString()) && p.equals(ap2.getProvider().getName());
    }

    protected TestAlgorithmParameters(String algo, int KEY_SIZE) {
        super(name);
        this.algo = algo;
        this.KEY_SIZE = KEY_SIZE;
    }

    protected TestAlgorithmParameters() {
        super(name);
        this.algo = "DES";
        this.KEY_SIZE = 56;
    }
}

