/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.test;

public abstract class Test {
    private static final String CLASS_PREFIX = "cryptix.jce.test.Test";
    private static final String VERSION = "$Revision: 1.15 $";
    private static boolean verbose = true;
    private static String[] TESTS = new String[]{"DSA", "MD2", "MD4", "RIPEMD128", "RIPEMD160", "SHA0", "SHA1", "Tiger", "Blowfish", "CAST5", "DES", "IDEA", "MARS", "RC2", "RC6", "Rijndael", "Serpent", "SKIPJACK", "Square", "TripleDES", "Twofish", "ModeAndPadding", "AlgorithmParameters", "CipherStream", "SealedObject"};
    private static String currentTest;

    /*
     * WARNING - void declaration
     */
    public static void main(String[] argv) {
        Test.printVerbose("Cryptix JCE Test Driver - $Revision: 1.15 $ - http://www.cryptix.org/");
        Test.printVerbose("");
        Test.printVerbose("Platform: JDK " + System.getProperty("java.version") + " (" + System.getProperty("java.vendor") + ") on " + System.getProperty("os.name") + " (" + System.getProperty("os.version") + ", " + System.getProperty("os.arch") + ")");
        Test.printVerbose("Classpath: " + System.getProperty("java.class.path"));
        Test.printVerbose("");
        if (argv.length == 0) {
            System.out.println("Usage: Test <testname>  or  Test All");
            System.exit(0);
        }
        try {
            String[] tests = argv[0].equalsIgnoreCase("All") ? TESTS : argv;
            int i = 0;
            while (i < tests.length) {
                void var3_5;
                Test t = Test.getTest(tests[i]);
                var3_5.doIt();
                ++i;
            }
        }
        catch (ClassNotFoundException e) {
            System.out.println("Test not found.");
            System.exit(1);
        }
        catch (Throwable t) {
            System.out.println("Failed");
            t.printStackTrace();
            System.exit(1);
        }
        System.exit(10);
    }

    private static void printVerbose(String s) {
        if (verbose) {
            System.out.println(s);
        }
    }

    private static Test getTest(String name) throws Exception {
        Class<?> c = Class.forName(CLASS_PREFIX + name);
        Object o = c.newInstance();
        return (Test)o;
    }

    protected void beginTest(String s) {
        System.out.print("Testing " + currentTest + " (" + s + ")... ");
    }

    protected void passIf(boolean success) {
        if (!success) {
            throw new RuntimeException("Test failed");
        }
        System.out.println("Ok");
    }

    protected abstract void doIt() throws Exception;

    protected Test(String name) {
        currentTest = name;
    }
}

