/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.test;

import cryptix.jce.test.Test;
import cryptix.jce.test.Util;
import java.security.MessageDigest;

abstract class MessageDigestTest
extends Test {
    /*
     * WARNING - void declaration
     */
    protected void testExistence(String alg) throws Exception {
        void var2_2;
        this.beginTest("Algorithm available as " + alg);
        boolean res = true;
        try {
            MessageDigest md = MessageDigest.getInstance(alg, "Cryptix");
        }
        catch (Exception e) {
            e.printStackTrace();
            res = false;
        }
        this.passIf((boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    protected void testCloning(String alg) throws Exception {
        void var2_2;
        this.beginTest("Cloning");
        boolean res = true;
        try {
            MessageDigest md1 = MessageDigest.getInstance(alg, "Cryptix");
            MessageDigest md2 = (MessageDigest)md1.clone();
            md1.update((byte)97);
            MessageDigest md3 = (MessageDigest)md1.clone();
            md1.update((byte)97);
            md2.update((byte)97);
            md2.update((byte)97);
            md3.update((byte)97);
            byte[] res1 = md1.digest();
            byte[] res2 = md2.digest();
            byte[] res3 = md3.digest();
            if (!Util.areEqual(res1, res2) || !Util.areEqual(res1, res3)) {
                res = false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            res = false;
        }
        this.passIf((boolean)var2_2);
    }

    protected void testLargeString(String alg, byte c, int count, String result) throws Exception {
        this.beginTest("Test Values (Large String)");
        boolean res = true;
        try {
            byte[] hash = Util.hexFromString(result);
            MessageDigest md = MessageDigest.getInstance(alg, "Cryptix");
            int i = 0;
            while (i < count) {
                md.update(c);
                ++i;
            }
            byte[] out = md.digest();
            if (!Util.areEqual(out, hash)) {
                res = false;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            res = false;
        }
        this.passIf(res);
    }

    /*
     * WARNING - void declaration
     */
    protected void testValues(String alg, String[][] testValues) throws Exception {
        void var3_3;
        this.beginTest("Test Values");
        boolean res = true;
        try {
            int i = 0;
            while (i < testValues.length) {
                byte[] pt = testValues[i][0].getBytes();
                byte[] hash = Util.hexFromString(testValues[i][1]);
                MessageDigest md = MessageDigest.getInstance(alg, "Cryptix");
                byte[] out = md.digest(pt);
                if (!Util.areEqual(out, hash)) {
                    res = false;
                }
                ++i;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            res = false;
        }
        this.passIf((boolean)var3_3);
    }

    protected MessageDigestTest(String name) {
        super(name);
    }
}

