/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.test;

import cryptix.jce.test.Test;
import cryptix.jce.test.Util;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;

abstract class CipherTest
extends Test {
    private static SecureRandom random = new SecureRandom();
    private final String alg;

    /*
     * WARNING - void declaration
     */
    protected void testExistence(String alg) throws Exception {
        void var2_2;
        this.beginTest("Algorithm available as " + alg);
        boolean res = true;
        try {
            Cipher c = Cipher.getInstance(alg, "Cryptix");
        }
        catch (NoSuchAlgorithmException e) {
            res = false;
        }
        this.passIf((boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    protected void testValuesECB(String alg, String[][] testValues) throws Exception {
        void var3_3;
        this.beginTest("ECB Test Values");
        boolean res = true;
        try {
            int i = 0;
            while (i < testValues.length) {
                byte[] key = Util.hexFromString(testValues[i][0]);
                byte[] pt = Util.hexFromString(testValues[i][1]);
                byte[] ct = Util.hexFromString(testValues[i][2]);
                Cipher c = Cipher.getInstance(alg + "/ECB/None");
                CipherTest cipherTest = this;
                if (cipherTest == null) {
                    throw null;
                }
                c.init(1, cipherTest.new K(alg, key));
                byte[] trial_ct = c.doFinal(pt);
                CipherTest cipherTest2 = this;
                if (cipherTest2 == null) {
                    throw null;
                }
                c.init(2, cipherTest2.new K(alg, key));
                byte[] trial_pt = c.doFinal(ct);
                if (!Util.areEqual(ct, trial_ct) || !Util.areEqual(pt, trial_pt)) {
                    res = false;
                }
                ++i;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            res = false;
        }
        this.passIf((boolean)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    protected void testKeyGenExistence(String alg) throws Exception {
        void var2_2;
        this.beginTest("KeyGenerator available");
        boolean res = true;
        try {
            KeyGenerator keygen = KeyGenerator.getInstance(alg);
        }
        catch (NoSuchAlgorithmException e) {
            res = false;
        }
        this.passIf((boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    protected void testKeyGenWorks(String alg) throws Exception {
        void var2_2;
        boolean res = true;
        this.beginTest("KeyGenerator works");
        try {
            KeyGenerator keygen = KeyGenerator.getInstance(alg);
            keygen.init(random);
            Cipher c = Cipher.getInstance(alg + "/ECB/None");
            int block_size = c.getBlockSize();
            byte[] pt = new byte[block_size];
            int i = 0;
            while (i < pt.length) {
                pt[i] = (byte)i;
                ++i;
            }
            i = 0;
            while (i < 1000) {
                SecretKey k = keygen.generateKey();
                c.init(1, k);
                byte[] tmp = c.doFinal(pt);
                c.init(2, k);
                tmp = c.doFinal(tmp);
                res = Util.areEqual(tmp, pt);
                if (res) {
                    ++i;
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            res = false;
        }
        this.passIf((boolean)var2_2);
    }

    protected void testCipher(String[][] testValues) throws Exception {
        this.testExistence(this.alg);
        this.testValuesECB(this.alg, testValues);
        this.testKeyGenExistence(this.alg);
        this.testKeyGenWorks(this.alg);
    }

    protected CipherTest(String name) {
        super(name);
        this.alg = name;
    }

    private class K
    implements Key {
        private final byte[] keyBytes;
        private final String alg;

        public String getAlgorithm() {
            return this.alg;
        }

        public String getFormat() {
            return "RAW";
        }

        public byte[] getEncoded() {
            return (byte[])this.keyBytes.clone();
        }

        K(String alg, byte[] keyBytes) {
            this.alg = alg;
            this.keyBytes = keyBytes;
        }
    }
}

