/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.util.der;

import cryptix.jce.util.der.ASNObject;
import java.io.IOException;
import java.io.OutputStream;

public final class DEROutputStream {
    private final OutputStream os;

    public void close() throws IOException {
        this.os.close();
    }

    public void flush() throws IOException {
        this.os.flush();
    }

    public void write(ASNObject o) throws IOException {
        o.write(this);
    }

    void writeType(byte type) throws IOException {
        this.os.write(type & 0xFF);
    }

    void writeLength(int len) throws IOException {
        if (len < 0) {
            throw new IllegalArgumentException("len: < 0");
        }
        int lenOfLen = len <= 127 ? 1 : (len <= 65535 ? 2 : (len <= 0xFFFFFF ? 3 : 4));
        if (lenOfLen != 1) {
            this.os.write((byte)(lenOfLen | 0x80));
        }
        while (lenOfLen-- > 0) {
            this.os.write((byte)(len >>> lenOfLen * 8));
        }
    }

    void writeBytes(byte[] bytes) throws IOException {
        this.os.write(bytes);
    }

    public DEROutputStream(OutputStream os) {
        this.os = os;
    }
}

