/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.rsa;

import cryptix.jce.util.der.ASNBitString;
import cryptix.jce.util.der.ASNInteger;
import cryptix.jce.util.der.ASNObject;
import cryptix.jce.util.der.ASNObjectIdentifier;
import cryptix.jce.util.der.ASNSequence;
import cryptix.jce.util.der.DEROutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.interfaces.RSAPublicKey;

final class RSAPublicKeyX509
implements RSAPublicKey {
    private final BigInteger n;
    private final BigInteger e;

    public BigInteger getModulus() {
        return this.n;
    }

    public BigInteger getPublicExponent() {
        return this.e;
    }

    public String getAlgorithm() {
        return "RSA";
    }

    public String getFormat() {
        return "X.509";
    }

    public byte[] getEncoded() {
        ASNObject[] spkData = new ASNObject[]{new ASNInteger(this.n), new ASNInteger(this.e)};
        ASNBitString subjectPublicKey = new ASNBitString(new ASNSequence(spkData));
        ASNObject[] algData = new ASNObject[]{ASNObjectIdentifier.RSA};
        ASNSequence algorithm = new ASNSequence(algData);
        ASNObject[] spkiData = new ASNObject[]{algorithm, subjectPublicKey};
        ASNSequence subjectPublicKeyInfo = new ASNSequence(spkiData);
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DEROutputStream dos = new DEROutputStream(baos);
            dos.write(subjectPublicKeyInfo);
            dos.flush();
            dos.close();
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException("PANIC");
        }
    }

    RSAPublicKeyX509(BigInteger n, BigInteger e) {
        this.n = n;
        this.e = e;
    }
}

