/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.rsa;

import cryptix.jce.provider.rsa.PaddingPKCS1;
import cryptix.jce.provider.rsa.RSAAlgorithm;
import cryptix.jce.util.Util;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;

public final class RSACipher_ECB_PKCS1
extends CipherSpi {
    private static final int UNITIALIZED = 3;
    private byte[] buf;
    private int bufOffset;
    private int bufSize;
    private int modulusSize;
    private BigInteger n;
    private BigInteger c;
    private SecureRandom random;
    private int mode = 3;

    protected void engineSetMode(String mode) throws NoSuchAlgorithmException {
        if (!mode.equalsIgnoreCase("ECB")) {
            throw new NoSuchAlgorithmException("Only ECB is supported.");
        }
    }

    protected void engineSetPadding(String padding) throws NoSuchPaddingException {
        if (!padding.equalsIgnoreCase("PKCS#1")) {
            throw new NoSuchPaddingException("Only PKCS#1 is supported.");
        }
    }

    protected int engineGetBlockSize() {
        return this.bufSize;
    }

    protected int engineGetOutputSize(int inputLen) {
        if (this.mode == 3) {
            throw new IllegalStateException();
        }
        int bufLeft = this.bufSize - this.bufOffset;
        throw new RuntimeException("NYI");
    }

    protected byte[] engineGetIV() {
        return null;
    }

    protected AlgorithmParameters engineGetParameters() {
        throw new RuntimeException("NYI");
    }

    protected void engineInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        switch (opmode) {
            case 1: {
                if (!(key instanceof RSAPublicKey)) {
                    throw new InvalidKeyException("key: not an RSAPublicKey");
                }
                RSAPublicKey pub = (RSAPublicKey)key;
                this.n = pub.getModulus();
                this.c = pub.getPublicExponent();
                break;
            }
            case 2: {
                if (!(key instanceof RSAPrivateKey)) {
                    throw new InvalidKeyException("key: not an RSAPrivateKey");
                }
                RSAPrivateKey priv = (RSAPrivateKey)key;
                this.n = priv.getModulus();
                this.c = priv.getPrivateExponent();
                break;
            }
            default: {
                throw new IllegalArgumentException("opmode: " + opmode);
            }
        }
        this.modulusSize = (this.n.bitLength() + 7) / 8;
        this.random = random;
    }

    protected void engineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        throw new RuntimeException("NYI");
    }

    protected void engineInit(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        throw new RuntimeException("NYI");
    }

    protected byte[] engineUpdate(byte[] input, int inputOffset, int inputLen) {
        if (this.mode == 3) {
            throw new IllegalStateException();
        }
        byte[] out = new byte[this.getUpdateOutputSize(inputLen)];
        this.update(input, inputOffset, inputLen, out, 0);
        return out;
    }

    protected int engineUpdate(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException {
        if (this.mode == 3) {
            throw new IllegalStateException();
        }
        int lengthRequired = this.getUpdateOutputSize(inputLen);
        if (output.length - outputOffset < lengthRequired) {
            throw new ShortBufferException(lengthRequired + "bytes needed");
        }
        return this.update(input, inputOffset, inputLen, output, outputOffset);
    }

    protected byte[] engineDoFinal(byte[] input, int inputOffset, int inputLen) throws IllegalBlockSizeException, BadPaddingException {
        if (this.mode == 3) {
            throw new IllegalStateException();
        }
        throw new RuntimeException("NYI");
    }

    protected int engineDoFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        if (this.mode == 3) {
            throw new IllegalStateException();
        }
        throw new RuntimeException("NYI");
    }

    private int getUpdateOutputSize(int inputLen) {
        throw new RuntimeException("NYI");
    }

    /*
     * WARNING - void declaration
     */
    private int update(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) {
        int todo;
        while ((todo = this.bufSize - this.bufOffset) <= inputLen) {
            void var6_6;
            System.arraycopy(input, inputOffset, this.buf, this.bufOffset, (int)var6_6);
            if (this.mode == 1) {
                byte[] padded = PaddingPKCS1.pad(this.buf, this.modulusSize, this.random);
                BigInteger res = RSAAlgorithm.rsa(new BigInteger(padded), this.n, this.c);
                byte[] resBytes = Util.toByteArray(res, this.modulusSize);
                System.arraycopy(resBytes, 0, output, outputOffset, resBytes.length);
                outputOffset += resBytes.length;
            } else {
                throw new RuntimeException("NYI");
            }
            inputLen -= var6_6;
            inputOffset += var6_6;
            this.bufOffset = 0;
        }
        System.arraycopy(input, inputOffset, this.buf, this.bufOffset, inputLen);
        this.bufOffset = 0;
        throw new RuntimeException();
    }
}

