/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.rsa;

import java.security.SecureRandom;
import javax.crypto.BadPaddingException;

final class PaddingPKCS1 {
    private static final int MIN_PADDING_SIZE = 11;

    static byte[] pad(byte[] unpaddedBytes, int outLen, SecureRandom random) {
        int unpaddedBytesLen = unpaddedBytes.length;
        if (unpaddedBytesLen + 11 > outLen) {
            throw new IllegalArgumentException();
        }
        byte[] out = new byte[outLen];
        random.nextBytes(out);
        out[0] = 0;
        out[1] = 2;
        int i = 2;
        while (i < outLen - unpaddedBytesLen - 1) {
            if (out[i] == 0) {
                out[i] = 1;
            }
            ++i;
        }
        out[i] = 0;
        System.arraycopy(unpaddedBytes, 0, out, outLen - unpaddedBytesLen, unpaddedBytesLen);
        return out;
    }

    static byte[] unpad(byte[] paddedBytes) throws BadPaddingException {
        int paddedBytesLen = paddedBytes.length;
        if (paddedBytesLen < 11) {
            throw new BadPaddingException();
        }
        if (paddedBytes[0] != 0 || paddedBytes[1] != 2) {
            throw new BadPaddingException();
        }
        int i = 2;
        while (i < paddedBytesLen) {
            if (paddedBytes[i] == 0) break;
            ++i;
        }
        if (paddedBytes[i] != 0) {
            throw new BadPaddingException();
        }
        int unpaddedLen = paddedBytesLen - i - 1;
        byte[] unpadded = new byte[unpaddedLen];
        System.arraycopy(paddedBytes, i + 1, unpadded, 0, unpaddedLen);
        return unpadded;
    }

    public static void main(String[] argv) {
        while (true) {
            PaddingPKCS1.doIt();
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void doIt() {
        try {
            byte[] unpadded = new byte[]{};
            int i = 0;
            while (i < unpadded.length) {
                unpadded[i] = (byte)(i + 1);
                ++i;
            }
            byte[] padded = PaddingPKCS1.pad(unpadded, 35, new SecureRandom());
            int i2 = 0;
            while (i2 < padded.length) {
                System.out.print(padded[i2] + " ");
                ++i2;
            }
            System.out.println();
            unpadded = PaddingPKCS1.unpad(padded);
            i2 = 0;
            while (i2 < unpadded.length) {
                System.out.print(unpadded[i2] + " ");
                ++i2;
            }
            System.out.println();
        }
        catch (Exception e) {
            void var0_1;
            var0_1.printStackTrace();
        }
    }

    PaddingPKCS1() {
    }
}

