/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.md;

import java.security.DigestException;
import java.security.MessageDigestSpi;

abstract class PaddingMD
extends MessageDigestSpi {
    private static final int BLOCKSIZE = 64;
    static final int MODE_MD = 0;
    static final int MODE_SHA = 1;
    static final int MODE_TIGER = 2;
    private final int hashSize;
    private final byte[] buf;
    private int bufOff;
    private long byteCount;
    private final int mode;

    protected int engineGetDigestLength() {
        return this.hashSize;
    }

    protected void engineUpdate(byte input) {
        ++this.byteCount;
        this.buf[this.bufOff++] = input;
        if (this.bufOff == 64) {
            this.coreUpdate(this.buf, 0);
            this.bufOff = 0;
        }
    }

    protected void engineUpdate(byte[] input, int offset, int length) {
        int todo;
        this.byteCount += (long)length;
        while (length >= (todo = 64 - this.bufOff)) {
            System.arraycopy(input, offset, this.buf, this.bufOff, todo);
            this.coreUpdate(this.buf, 0);
            length -= todo;
            offset += todo;
            this.bufOff = 0;
        }
        System.arraycopy(input, offset, this.buf, this.bufOff, length);
        this.bufOff += length;
    }

    protected byte[] engineDigest() {
        try {
            byte[] tmp = new byte[this.hashSize];
            this.engineDigest(tmp, 0, this.hashSize);
            return tmp;
        }
        catch (DigestException e) {
            throw new RuntimeException("PANIC, this should never happen. Giving up...");
        }
    }

    protected int engineDigest(byte[] buf, int offset, int len) throws DigestException {
        if (len < this.hashSize) {
            throw new DigestException();
        }
        int n = this.buf[this.bufOff++] = this.mode == 2 ? 1 : -128;
        if (this.bufOff > 56) {
            while (this.bufOff < 64) {
                this.buf[this.bufOff++] = 0;
            }
            this.coreUpdate(this.buf, 0);
            this.bufOff = 0;
        }
        while (this.bufOff < 56) {
            this.buf[this.bufOff++] = 0;
        }
        this.byteCount *= 8L;
        if (this.mode == 1) {
            int i = 56;
            while (i >= 0) {
                this.buf[this.bufOff++] = (byte)(this.byteCount >>> i);
                i -= 8;
            }
        } else {
            int i = 0;
            while (i < 64) {
                this.buf[this.bufOff++] = (byte)(this.byteCount >>> i);
                i += 8;
            }
        }
        this.coreUpdate(this.buf, 0);
        this.coreDigest(buf, offset);
        this.engineReset();
        return this.hashSize;
    }

    protected void engineReset() {
        this.bufOff = 0;
        this.byteCount = 0L;
        this.coreReset();
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    protected abstract void coreDigest(byte[] var1, int var2);

    protected abstract void coreReset();

    protected abstract void coreUpdate(byte[] var1, int var2);

    protected PaddingMD(int hashSize, int mode) {
        this.hashSize = hashSize;
        this.buf = new byte[64];
        this.bufOff = 0;
        this.byteCount = 0L;
        this.mode = mode;
    }
}

