/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.elgamal;

import cryptix.jce.ElGamalParams;
import cryptix.jce.ElGamalPublicKey;
import cryptix.jce.util.MPIOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;

final class ElGamalPublicKeyCryptix
implements ElGamalPublicKey {
    private final BigInteger y;
    private final ElGamalParams params;

    public BigInteger getY() {
        return this.y;
    }

    public ElGamalParams getParams() {
        return this.params;
    }

    public String getAlgorithm() {
        return "ElGamal";
    }

    public String getFormat() {
        return "Cryptix";
    }

    public byte[] getEncoded() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            MPIOutputStream mos = new MPIOutputStream(baos);
            mos.write(this.params.getP());
            mos.write(this.params.getQ());
            mos.write(this.params.getG());
            mos.write(this.y);
            mos.flush();
            mos.close();
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException("PANIC");
        }
    }

    ElGamalPublicKeyCryptix(BigInteger y, ElGamalParams params) {
        this.y = y;
        this.params = params;
    }
}

