/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.elgamal;

import cryptix.jce.ElGamalParams;
import cryptix.jce.ElGamalPrivateKey;
import cryptix.jce.util.MPIOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;

final class ElGamalPrivateKeyCryptix
implements ElGamalPrivateKey {
    private final BigInteger x;
    private final ElGamalParams params;

    public BigInteger getX() {
        return this.x;
    }

    public ElGamalParams getParams() {
        return this.params;
    }

    public String getAlgorithm() {
        return "ElGamal";
    }

    public String getFormat() {
        return "Cryptix";
    }

    public byte[] getEncoded() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            MPIOutputStream mos = new MPIOutputStream(baos);
            mos.write(this.params.getP());
            mos.write(this.params.getQ());
            mos.write(this.params.getG());
            mos.write(this.x);
            mos.flush();
            mos.close();
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException("PANIC");
        }
    }

    ElGamalPrivateKeyCryptix(BigInteger x, ElGamalParams params) {
        this.x = x;
        this.params = params;
    }
}

