/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.elgamal;

import cryptix.jce.ElGamalParams;
import cryptix.jce.provider.elgamal.ElGamalPrivateKeyCryptix;
import cryptix.jce.provider.elgamal.ElGamalPublicKeyCryptix;
import cryptix.jce.provider.elgamal.PrecomputedParams;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;

public final class ElGamalKeyPairGenerator
extends KeyPairGeneratorSpi {
    private static final int KEYSIZE_MIN = 384;
    private static final int KEYSIZE_MAX = 16384;
    private static final int KEYSIZE_DEFAULT = 1536;
    private static final BigInteger TWO = BigInteger.valueOf(2L);
    private SecureRandom random;
    private int keysize;
    private boolean initialized = false;

    public void initialize(int keysize, SecureRandom random) {
        System.out.println("keysize: " + keysize + ", random: " + random);
        if (keysize < 384 || keysize > 16384) {
            throw new IllegalArgumentException("keysize: invalid size (" + keysize + ")");
        }
        this.keysize = keysize;
        this.random = random;
        this.initialized = true;
    }

    public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        throw new RuntimeException("NYI");
    }

    public KeyPair generateKeyPair() {
        BigInteger x;
        ElGamalParams params;
        if (!this.initialized) {
            this.initialize();
        }
        if ((params = PrecomputedParams.get(this.keysize)) == null) {
            throw new RuntimeException("NYI");
        }
        BigInteger p = params.getP();
        BigInteger g = params.getG();
        BigInteger xMin = TWO;
        BigInteger xMax = p.subtract(TWO);
        int xLen = p.bitLength();
        do {
            System.out.println("Generating x...");
        } while ((x = new BigInteger(xLen, this.random)).compareTo(xMin) == -1 || x.compareTo(xMax) == 1);
        BigInteger y = g.modPow(x, p);
        System.out.println("p.length: " + p.bitLength());
        System.out.println("g: " + g);
        System.out.println("p: " + p);
        System.out.println("x: " + x);
        System.out.println("y: " + y);
        ElGamalPublicKeyCryptix pub = new ElGamalPublicKeyCryptix(y, params);
        ElGamalPrivateKeyCryptix priv = new ElGamalPrivateKeyCryptix(x, params);
        return new KeyPair(pub, priv);
    }

    private void initialize() {
        this.initialize(1536, new SecureRandom());
    }
}

