/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.dsa;

import cryptix.jce.util.MPIOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPublicKey;

final class DSAPublicKeyOpenPGP
implements DSAPublicKey {
    private final BigInteger y;
    private final DSAParams params;

    public BigInteger getY() {
        return this.y;
    }

    public DSAParams getParams() {
        return this.params;
    }

    public String getAlgorithm() {
        return "DSA";
    }

    public String getFormat() {
        return "Cryptix";
    }

    public byte[] getEncoded() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            MPIOutputStream mos = new MPIOutputStream(baos);
            mos.write(this.params.getP());
            mos.write(this.params.getQ());
            mos.write(this.params.getG());
            mos.write(this.y);
            mos.flush();
            mos.close();
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException("PANIC");
        }
    }

    DSAPublicKeyOpenPGP(BigInteger y, DSAParams params) {
        this.y = y;
        this.params = params;
    }
}

