/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.dh;

import cryptix.jce.util.MPIOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;

final class DHPublicKeyCryptix
implements DHPublicKey {
    private final BigInteger y;
    private final DHParameterSpec params;

    public BigInteger getY() {
        return this.y;
    }

    public DHParameterSpec getParams() {
        return this.params;
    }

    public String getAlgorithm() {
        return "DH";
    }

    public String getFormat() {
        return "Cryptix";
    }

    public byte[] getEncoded() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            MPIOutputStream mos = new MPIOutputStream(baos);
            mos.write(this.params.getP());
            mos.write(BigInteger.valueOf(this.params.getL()));
            mos.write(this.params.getG());
            mos.write(this.y);
            mos.flush();
            mos.close();
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException("PANIC");
        }
    }

    DHPublicKeyCryptix(BigInteger y, DHParameterSpec params) {
        this.y = y;
        this.params = params;
    }
}

