/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.dh;

import cryptix.jce.util.MPIOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.spec.DHParameterSpec;

final class DHPrivateKeyCryptix
implements DHPrivateKey {
    private final BigInteger x;
    private final DHParameterSpec params;

    public BigInteger getX() {
        return this.x;
    }

    public DHParameterSpec getParams() {
        return this.params;
    }

    public String getAlgorithm() {
        return "DH";
    }

    public String getFormat() {
        return "Cryptix";
    }

    public byte[] getEncoded() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            MPIOutputStream mos = new MPIOutputStream(baos);
            mos.write(this.params.getP());
            mos.write(BigInteger.valueOf(this.params.getL()));
            mos.write(this.params.getG());
            mos.write(this.x);
            mos.flush();
            mos.close();
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException("PANIC");
        }
    }

    DHPrivateKeyCryptix(BigInteger x, DHParameterSpec params) {
        this.x = x;
        this.params = params;
    }
}

