/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.dh;

import cryptix.jce.provider.dh.DHPrivateKeyCryptix;
import cryptix.jce.provider.dh.DHPublicKeyCryptix;
import cryptix.jce.util.Group;
import cryptix.jce.util.Precomputed;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.DHParameterSpec;

public final class DHKeyPairGenerator
extends KeyPairGeneratorSpi {
    private static final BigInteger ZERO = BigInteger.valueOf(0L);
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private static final int KEYSIZE_MIN = 384;
    private static final int KEYSIZE_MAX = 16384;
    private static final int KEYSIZE_DEFAULT = 16384;
    private static final int CERTAINTY = 80;
    private int keysize;
    private SecureRandom random;
    private boolean initialized = false;

    public void initialize(int keysize, SecureRandom random) {
        if (keysize < 384 || keysize > 16384) {
            throw new IllegalArgumentException("keysize: invalid size (" + keysize + ")");
        }
        this.keysize = keysize;
        this.random = random;
        this.initialized = true;
    }

    public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        throw new RuntimeException("NYI");
    }

    public KeyPair generateKeyPair() {
        BigInteger x;
        Group group;
        if (!this.initialized) {
            this.initialize();
        }
        if ((group = Precomputed.getStrongGroup(this.keysize)) == null) {
            throw new RuntimeException("NYI");
        }
        BigInteger p = group.getP();
        BigInteger g = group.getG();
        while ((x = new BigInteger(p.bitLength(), this.random)).compareTo(ZERO) != 1 || x.compareTo(p.subtract(ONE)) != -1) {
        }
        BigInteger y = g.modPow(x, p);
        DHParameterSpec params = new DHParameterSpec(p, g);
        DHPrivateKeyCryptix priv = new DHPrivateKeyCryptix(x, params);
        DHPublicKeyCryptix pub = new DHPublicKeyCryptix(y, params);
        return new KeyPair(pub, priv);
    }

    private void initialize() {
        this.initialize(16384, new SecureRandom());
    }
}

