/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.cipher;

import cryptix.jce.provider.cipher.BlockCipher;
import java.security.InvalidKeyException;
import java.security.Key;

public final class Serpent
extends BlockCipher {
    private static final int BLOCK_SIZE = 16;
    private static final int ROUNDS = 32;
    private static final int PHI = -1640531527;
    private static final byte[][] Sbox = new byte[8][16];
    private boolean decrypt;
    private int[] K = new int[132];

    protected void coreInit(Key key, boolean decrypt) throws InvalidKeyException {
        if (key == null) {
            throw new InvalidKeyException("key: key is null");
        }
        if (!key.getFormat().equalsIgnoreCase("RAW")) {
            throw new InvalidKeyException("key: wrong format, RAW needed");
        }
        byte[] userkey = key.getEncoded();
        if (userkey == null) {
            throw new InvalidKeyException("RAW bytes missing");
        }
        int len = userkey.length;
        if (len != 16 && len != 24 && len != 32) {
            throw new InvalidKeyException("Invalid user key length");
        }
        this.generateSubKeys(userkey);
        this.decrypt = decrypt;
    }

    protected void coreCrypt(byte[] in, int inOffset, byte[] out, int outOffset) {
        if (this.decrypt) {
            this.blockDecrypt(in, inOffset, out, outOffset);
        } else {
            this.blockEncrypt(in, inOffset, out, outOffset);
        }
    }

    private final void generateSubKeys(byte[] key) throws InvalidKeyException {
        int t;
        int[] w = this.K = new int[132];
        int limit = key.length / 4;
        int offset = key.length - 1;
        int i = 0;
        while (i < limit) {
            w[i] = key[offset--] & 0xFF | (key[offset--] & 0xFF) << 8 | (key[offset--] & 0xFF) << 16 | (key[offset--] & 0xFF) << 24;
            ++i;
        }
        if (i < 8) {
            w[i++] = 1;
        }
        i = 8;
        int j = 0;
        while (i < 16) {
            t = w[j] ^ w[i - 5] ^ w[i - 3] ^ w[i - 1] ^ 0x9E3779B9 ^ j++;
            w[i] = t << 11 | t >>> 21;
            ++i;
        }
        i = 0;
        j = 8;
        while (i < 8) {
            w[i++] = w[j++];
        }
        limit = 132;
        while (i < limit) {
            t = w[i - 8] ^ w[i - 5] ^ w[i - 3] ^ w[i - 1] ^ 0x9E3779B9 ^ i;
            w[i] = t << 11 | t >>> 21;
            ++i;
        }
        i = 0;
        while (i < 33) {
            int x0 = w[4 * i];
            int x1 = w[4 * i + 1];
            int x2 = w[4 * i + 2];
            int x3 = w[4 * i + 3];
            int y3 = 0;
            int y2 = 0;
            int y1 = 0;
            int y0 = 0;
            byte[] sb = Sbox[(35 - i) % 8];
            j = 0;
            while (j < 32) {
                byte z = sb[x0 >>> j & 1 | (x1 >>> j & 1) << 1 | (x2 >>> j & 1) << 2 | (x3 >>> j & 1) << 3];
                y0 |= (z & 1) << j;
                y1 |= (z >>> 1 & 1) << j;
                y2 |= (z >>> 2 & 1) << j;
                y3 |= (z >>> 3 & 1) << j;
                ++j;
            }
            w[4 * i] = y0;
            w[4 * i + 1] = y1;
            w[4 * i + 2] = y2;
            w[4 * i + 3] = y3;
            ++i;
        }
    }

    private final void blockEncrypt(byte[] in, int inOffset, byte[] out, int outOffset) {
        int x3 = (in[inOffset++] & 0xFF) << 24 | (in[inOffset++] & 0xFF) << 16 | (in[inOffset++] & 0xFF) << 8 | in[inOffset++] & 0xFF;
        int x2 = (in[inOffset++] & 0xFF) << 24 | (in[inOffset++] & 0xFF) << 16 | (in[inOffset++] & 0xFF) << 8 | in[inOffset++] & 0xFF;
        int x1 = (in[inOffset++] & 0xFF) << 24 | (in[inOffset++] & 0xFF) << 16 | (in[inOffset++] & 0xFF) << 8 | in[inOffset++] & 0xFF;
        int x0 = (in[inOffset++] & 0xFF) << 24 | (in[inOffset++] & 0xFF) << 16 | (in[inOffset++] & 0xFF) << 8 | in[inOffset++] & 0xFF;
        int y0 = 0;
        int y1 = 0;
        int y2 = 0;
        int y3 = 0;
        int idxK = 0;
        int i = 0;
        while (i < 4) {
            x0 ^= this.K[idxK++];
            int n = idxK++;
            int n2 = idxK++;
            int n3 = idxK++;
            int t01 = (x1 ^= this.K[n]) ^ (x2 ^= this.K[n2]);
            int t02 = x0 | (x3 ^= this.K[n3]);
            int t03 = x0 ^ x1;
            y3 = t02 ^ t01;
            int t05 = x2 | y3;
            int t06 = x0 ^ x3;
            int t07 = x1 | x2;
            int t08 = x3 & t05;
            int t09 = t03 & t07;
            y2 = t09 ^ t08;
            int t11 = t09 & y2;
            int t12 = x2 ^ x3;
            int t13 = t07 ^ t11;
            int t14 = x1 & t06;
            int t15 = t06 ^ t13;
            y0 = ~t15;
            int t17 = y0 ^ t14;
            y1 = t12 ^ t17;
            x0 = y0 << 13 | y0 >>> 19;
            x2 = y2 << 3 | y2 >>> 29;
            x1 = y1 ^ x0 ^ x2;
            x3 = y3 ^ x2 ^ x0 << 3;
            x1 = x1 << 1 | x1 >>> 31;
            x3 = x3 << 7 | x3 >>> 25;
            x0 = x0 ^ x1 ^ x3;
            x2 = x2 ^ x3 ^ x1 << 7;
            x0 = x0 << 5 | x0 >>> 27;
            x2 = x2 << 22 | x2 >>> 10;
            x0 ^= this.K[idxK++];
            int n4 = idxK++;
            int n5 = idxK++;
            t01 = x0 | (x3 ^= this.K[idxK++]);
            t02 = (x2 ^= this.K[n5]) ^ x3;
            t03 = ~(x1 ^= this.K[n4]);
            int t04 = x0 ^ x2;
            t05 = x0 | t03;
            t06 = x3 & t04;
            t07 = t01 & t02;
            t08 = x1 | t06;
            y2 = t02 ^ t05;
            int t10 = t07 ^ t08;
            t11 = t01 ^ t10;
            t12 = y2 ^ t11;
            t13 = x1 & x3;
            y3 = ~t10;
            y1 = t13 ^ t12;
            int t16 = t10 | y1;
            t17 = t05 & t16;
            y0 = x2 ^ t17;
            x0 = y0 << 13 | y0 >>> 19;
            x2 = y2 << 3 | y2 >>> 29;
            x1 = y1 ^ x0 ^ x2;
            x3 = y3 ^ x2 ^ x0 << 3;
            x1 = x1 << 1 | x1 >>> 31;
            x3 = x3 << 7 | x3 >>> 25;
            x0 = x0 ^ x1 ^ x3;
            x2 = x2 ^ x3 ^ x1 << 7;
            x0 = x0 << 5 | x0 >>> 27;
            x2 = x2 << 22 | x2 >>> 10;
            x0 ^= this.K[idxK++];
            int n6 = idxK++;
            int n7 = idxK++;
            int n8 = idxK++;
            t01 = x0 | (x2 ^= this.K[n7]);
            t02 = x0 ^ (x1 ^= this.K[n6]);
            t03 = (x3 ^= this.K[n8]) ^ t01;
            y0 = t02 ^ t03;
            t05 = x2 ^ y0;
            t06 = x1 ^ t05;
            t07 = x1 | t05;
            t08 = t01 & t06;
            t09 = t03 ^ t07;
            t10 = t02 | t09;
            y1 = t10 ^ t08;
            t12 = x0 | x3;
            t13 = t09 ^ y1;
            t14 = x1 ^ t13;
            y3 = ~t09;
            y2 = t12 ^ t14;
            x0 = y0 << 13 | y0 >>> 19;
            x2 = y2 << 3 | y2 >>> 29;
            x1 = y1 ^ x0 ^ x2;
            x3 = y3 ^ x2 ^ x0 << 3;
            x1 = x1 << 1 | x1 >>> 31;
            x3 = x3 << 7 | x3 >>> 25;
            x0 = x0 ^ x1 ^ x3;
            x2 = x2 ^ x3 ^ x1 << 7;
            x0 = x0 << 5 | x0 >>> 27;
            x2 = x2 << 22 | x2 >>> 10;
            x0 ^= this.K[idxK++];
            x1 ^= this.K[idxK++];
            int n9 = idxK++;
            int n10 = idxK++;
            t01 = x0 ^ (x2 ^= this.K[n9]);
            t02 = x0 | (x3 ^= this.K[n10]);
            t03 = x0 & x3;
            t04 = t01 & t02;
            t05 = x1 | t03;
            t06 = x0 & x1;
            t07 = x3 ^ t04;
            t08 = x2 | t06;
            t09 = x1 ^ t07;
            t10 = x3 & t05;
            t11 = t02 ^ t10;
            y3 = t08 ^ t09;
            t13 = x3 | y3;
            t14 = x0 | t07;
            t15 = x1 & t13;
            y2 = t08 ^ t11;
            y0 = t14 ^ t15;
            y1 = t05 ^ t04;
            x0 = y0 << 13 | y0 >>> 19;
            x2 = y2 << 3 | y2 >>> 29;
            x1 = y1 ^ x0 ^ x2;
            x3 = y3 ^ x2 ^ x0 << 3;
            x1 = x1 << 1 | x1 >>> 31;
            x3 = x3 << 7 | x3 >>> 25;
            x0 = x0 ^ x1 ^ x3;
            x2 = x2 ^ x3 ^ x1 << 7;
            x0 = x0 << 5 | x0 >>> 27;
            x2 = x2 << 22 | x2 >>> 10;
            x0 ^= this.K[idxK++];
            int n11 = idxK++;
            int n12 = idxK++;
            int n13 = idxK++;
            t01 = x0 | (x1 ^= this.K[n11]);
            t02 = x1 | (x2 ^= this.K[n12]);
            t03 = x0 ^ t02;
            t04 = x1 ^ (x3 ^= this.K[n13]);
            t05 = x3 | t03;
            t06 = x3 & t01;
            y3 = t03 ^ t06;
            t08 = y3 & t04;
            t09 = t04 & t05;
            t10 = x2 ^ t06;
            t11 = x1 & x2;
            t12 = t04 ^ t08;
            t13 = t11 | t03;
            t14 = t10 ^ t09;
            t15 = x0 & t05;
            t16 = t11 | t12;
            y2 = t13 ^ t08;
            y1 = t15 ^ t16;
            y0 = ~t14;
            x0 = y0 << 13 | y0 >>> 19;
            x2 = y2 << 3 | y2 >>> 29;
            x1 = y1 ^ x0 ^ x2;
            x3 = y3 ^ x2 ^ x0 << 3;
            x1 = x1 << 1 | x1 >>> 31;
            x3 = x3 << 7 | x3 >>> 25;
            x0 = x0 ^ x1 ^ x3;
            x2 = x2 ^ x3 ^ x1 << 7;
            x0 = x0 << 5 | x0 >>> 27;
            x2 = x2 << 22 | x2 >>> 10;
            x0 ^= this.K[idxK++];
            int n14 = idxK++;
            int n15 = idxK++;
            t01 = (x1 ^= this.K[n14]) ^ (x3 ^= this.K[idxK++]);
            t02 = x1 | x3;
            t03 = x0 & t01;
            t04 = (x2 ^= this.K[n15]) ^ t02;
            t05 = t03 ^ t04;
            y0 = ~t05;
            t07 = x0 ^ t01;
            t08 = x3 | y0;
            t09 = x1 | t05;
            t10 = x3 ^ t08;
            t11 = x1 | t07;
            t12 = t03 | y0;
            t13 = t07 | t10;
            t14 = t01 ^ t11;
            y2 = t09 ^ t13;
            y1 = t07 ^ t08;
            y3 = t12 ^ t14;
            x0 = y0 << 13 | y0 >>> 19;
            x2 = y2 << 3 | y2 >>> 29;
            x1 = y1 ^ x0 ^ x2;
            x3 = y3 ^ x2 ^ x0 << 3;
            x1 = x1 << 1 | x1 >>> 31;
            x3 = x3 << 7 | x3 >>> 25;
            x0 = x0 ^ x1 ^ x3;
            x2 = x2 ^ x3 ^ x1 << 7;
            x0 = x0 << 5 | x0 >>> 27;
            x2 = x2 << 22 | x2 >>> 10;
            x0 ^= this.K[idxK++];
            int n16 = idxK++;
            int n17 = idxK++;
            t01 = x0 & (x3 ^= this.K[idxK++]);
            t02 = (x1 ^= this.K[n16]) ^ (x2 ^= this.K[n17]);
            t03 = x0 ^ x3;
            t04 = t01 ^ t02;
            t05 = x1 | x2;
            y1 = ~t04;
            t07 = t03 & t05;
            t08 = x1 & y1;
            t09 = x0 | x2;
            t10 = t07 ^ t08;
            t11 = x1 | x3;
            t12 = x2 ^ t11;
            t13 = t09 ^ t10;
            y2 = ~t13;
            t15 = y1 & t03;
            y3 = t12 ^ t07;
            t17 = x0 ^ x1;
            int t18 = y2 ^ t15;
            y0 = t17 ^ t18;
            x0 = y0 << 13 | y0 >>> 19;
            x2 = y2 << 3 | y2 >>> 29;
            x1 = y1 ^ x0 ^ x2;
            x3 = y3 ^ x2 ^ x0 << 3;
            x1 = x1 << 1 | x1 >>> 31;
            x3 = x3 << 7 | x3 >>> 25;
            x0 = x0 ^ x1 ^ x3;
            x2 = x2 ^ x3 ^ x1 << 7;
            x0 = x0 << 5 | x0 >>> 27;
            x2 = x2 << 22 | x2 >>> 10;
            x0 ^= this.K[idxK++];
            x1 ^= this.K[idxK++];
            int n18 = idxK++;
            int n19 = idxK++;
            t01 = x0 & (x2 ^= this.K[n18]);
            t02 = ~(x3 ^= this.K[n19]);
            t03 = x0 & t02;
            t04 = x1 | t01;
            t05 = x0 & x1;
            t06 = x2 ^ t04;
            y3 = t03 ^ t06;
            t08 = x2 | y3;
            t09 = x3 | t05;
            t10 = x0 ^ t08;
            t11 = t04 & y3;
            y1 = t09 ^ t10;
            t13 = x1 ^ y1;
            t14 = t01 ^ y1;
            t15 = x2 ^ t05;
            t16 = t11 | t13;
            t17 = t02 | t14;
            y0 = t15 ^ t17;
            y2 = x0 ^ t16;
            if (i == 3) break;
            x0 = y0 << 13 | y0 >>> 19;
            x2 = y2 << 3 | y2 >>> 29;
            x1 = y1 ^ x0 ^ x2;
            x3 = y3 ^ x2 ^ x0 << 3;
            x1 = x1 << 1 | x1 >>> 31;
            x3 = x3 << 7 | x3 >>> 25;
            x0 = x0 ^ x1 ^ x3;
            x2 = x2 ^ x3 ^ x1 << 7;
            x0 = x0 << 5 | x0 >>> 27;
            x2 = x2 << 22 | x2 >>> 10;
            ++i;
        }
        y0 ^= this.K[idxK++];
        y1 ^= this.K[idxK++];
        out[outOffset++] = (byte)((y3 ^= this.K[idxK]) >>> 24);
        out[outOffset++] = (byte)(y3 >>> 16);
        out[outOffset++] = (byte)(y3 >>> 8);
        out[outOffset++] = (byte)y3;
        out[outOffset++] = (byte)((y2 ^= this.K[idxK++]) >>> 24);
        out[outOffset++] = (byte)(y2 >>> 16);
        out[outOffset++] = (byte)(y2 >>> 8);
        out[outOffset++] = (byte)y2;
        out[outOffset++] = (byte)(y1 >>> 24);
        out[outOffset++] = (byte)(y1 >>> 16);
        out[outOffset++] = (byte)(y1 >>> 8);
        out[outOffset++] = (byte)y1;
        out[outOffset++] = (byte)(y0 >>> 24);
        out[outOffset++] = (byte)(y0 >>> 16);
        out[outOffset++] = (byte)(y0 >>> 8);
        out[outOffset] = (byte)y0;
    }

    private final void blockDecrypt(byte[] in, int inOffset, byte[] out, int outOffset) {
        int x3 = (in[inOffset++] & 0xFF) << 24 | (in[inOffset++] & 0xFF) << 16 | (in[inOffset++] & 0xFF) << 8 | in[inOffset++] & 0xFF;
        int x2 = (in[inOffset++] & 0xFF) << 24 | (in[inOffset++] & 0xFF) << 16 | (in[inOffset++] & 0xFF) << 8 | in[inOffset++] & 0xFF;
        int x1 = (in[inOffset++] & 0xFF) << 24 | (in[inOffset++] & 0xFF) << 16 | (in[inOffset++] & 0xFF) << 8 | in[inOffset++] & 0xFF;
        int x0 = (in[inOffset++] & 0xFF) << 24 | (in[inOffset++] & 0xFF) << 16 | (in[inOffset++] & 0xFF) << 8 | in[inOffset++] & 0xFF;
        int y0 = 0;
        int y1 = 0;
        int y2 = 0;
        int y3 = 0;
        int idxK = 131;
        x3 ^= this.K[idxK--];
        x2 ^= this.K[idxK--];
        x1 ^= this.K[idxK--];
        x0 ^= this.K[idxK--];
        int i = 0;
        while (i < 4) {
            int t01 = x0 & x1;
            int t02 = x0 | x1;
            int t03 = x2 | t01;
            int t04 = x3 & t02;
            y3 = t03 ^ t04;
            int t06 = x1 ^ t04;
            int t07 = x3 ^ y3;
            int t08 = ~t07;
            int t09 = t06 | t08;
            int t10 = x1 ^ x3;
            int t11 = x0 | x3;
            y1 = x0 ^ t09;
            int t13 = x2 ^ t06;
            int t14 = x2 & t11;
            int t15 = x3 | y1;
            int t16 = t01 | t10;
            y0 = t13 ^ t15;
            y2 = t14 ^ t16;
            y3 ^= this.K[idxK--];
            int n = idxK--;
            int n2 = idxK--;
            int n3 = idxK--;
            x2 = (y2 ^= this.K[n]) << 10 | y2 >>> 22;
            x0 = (y0 ^= this.K[n3]) << 27 | y0 >>> 5;
            x2 = x2 ^ y3 ^ (y1 ^= this.K[n2]) << 7;
            x0 = x0 ^ y1 ^ y3;
            x3 = y3 << 25 | y3 >>> 7;
            x1 = y1 << 31 | y1 >>> 1;
            x3 = x3 ^ x2 ^ x0 << 3;
            x1 = x1 ^ x0 ^ x2;
            x2 = x2 << 29 | x2 >>> 3;
            x0 = x0 << 19 | x0 >>> 13;
            t01 = x0 ^ x2;
            t02 = ~x2;
            t03 = x1 & t01;
            t04 = x1 | t02;
            int t05 = x3 | t03;
            t06 = x1 ^ x3;
            t07 = x0 & t04;
            t08 = x0 | t02;
            t09 = t07 ^ t05;
            y1 = t06 ^ t08;
            y0 = ~t09;
            int t12 = x1 & y0;
            t13 = t01 & t05;
            t14 = t01 ^ t12;
            t15 = t07 ^ t13;
            t16 = x3 | t02;
            int t17 = x0 ^ y1;
            y3 = t17 ^ t15;
            y2 = t16 ^ t14;
            y3 ^= this.K[idxK--];
            int n4 = idxK--;
            int n5 = idxK--;
            int n6 = idxK--;
            x2 = (y2 ^= this.K[n4]) << 10 | y2 >>> 22;
            x0 = (y0 ^= this.K[n6]) << 27 | y0 >>> 5;
            x2 = x2 ^ y3 ^ (y1 ^= this.K[n5]) << 7;
            x0 = x0 ^ y1 ^ y3;
            x3 = y3 << 25 | y3 >>> 7;
            x1 = y1 << 31 | y1 >>> 1;
            x3 = x3 ^ x2 ^ x0 << 3;
            x1 = x1 ^ x0 ^ x2;
            x2 = x2 << 29 | x2 >>> 3;
            x0 = x0 << 19 | x0 >>> 13;
            t01 = x0 & x3;
            t02 = x2 ^ t01;
            t03 = x0 ^ x3;
            t04 = x1 & t02;
            t05 = x0 & x2;
            y0 = t03 ^ t04;
            t07 = x0 & y0;
            t08 = t01 ^ y0;
            t09 = x1 | t05;
            t10 = ~x1;
            y1 = t08 ^ t09;
            t12 = t10 | t07;
            t13 = y0 | y1;
            y3 = t02 ^ t12;
            t15 = t02 ^ t13;
            t16 = x1 ^ x3;
            y2 = t16 ^ t15;
            y3 ^= this.K[idxK--];
            int n7 = idxK--;
            int n8 = idxK--;
            int n9 = idxK--;
            x2 = (y2 ^= this.K[n7]) << 10 | y2 >>> 22;
            x0 = (y0 ^= this.K[n9]) << 27 | y0 >>> 5;
            x2 = x2 ^ y3 ^ (y1 ^= this.K[n8]) << 7;
            x0 = x0 ^ y1 ^ y3;
            x3 = y3 << 25 | y3 >>> 7;
            x1 = y1 << 31 | y1 >>> 1;
            x3 = x3 ^ x2 ^ x0 << 3;
            x1 = x1 ^ x0 ^ x2;
            x2 = x2 << 29 | x2 >>> 3;
            x0 = x0 << 19 | x0 >>> 13;
            t01 = x1 | x3;
            t02 = x2 | x3;
            t03 = x0 & t01;
            t04 = x1 ^ t02;
            t05 = x2 ^ x3;
            t06 = ~t03;
            t07 = x0 & t04;
            y1 = t05 ^ t07;
            t09 = y1 | t06;
            t10 = x0 ^ t07;
            t11 = t01 ^ t09;
            t12 = x3 ^ t04;
            t13 = x2 | t10;
            y3 = t03 ^ t12;
            t15 = x0 ^ t04;
            y2 = t11 ^ t13;
            y0 = t15 ^ t09;
            y3 ^= this.K[idxK--];
            int n10 = idxK--;
            int n11 = idxK--;
            int n12 = idxK--;
            x2 = (y2 ^= this.K[n10]) << 10 | y2 >>> 22;
            x0 = (y0 ^= this.K[n12]) << 27 | y0 >>> 5;
            x2 = x2 ^ y3 ^ (y1 ^= this.K[n11]) << 7;
            x0 = x0 ^ y1 ^ y3;
            x3 = y3 << 25 | y3 >>> 7;
            x1 = y1 << 31 | y1 >>> 1;
            x3 = x3 ^ x2 ^ x0 << 3;
            x1 = x1 ^ x0 ^ x2;
            x2 = x2 << 29 | x2 >>> 3;
            x0 = x0 << 19 | x0 >>> 13;
            t01 = x2 | x3;
            t02 = x0 | x3;
            t03 = x2 ^ t02;
            t04 = x1 ^ t02;
            t05 = x0 ^ x3;
            t06 = t04 & t03;
            t07 = x1 & t01;
            y2 = t05 ^ t06;
            t09 = x0 ^ t03;
            y0 = t07 ^ t03;
            t11 = y0 | t05;
            t12 = t09 & t11;
            t13 = x0 & y2;
            t14 = t01 ^ t05;
            y1 = x1 ^ t12;
            t16 = x1 | t13;
            y3 = t14 ^ t16;
            y3 ^= this.K[idxK--];
            int n13 = idxK--;
            int n14 = idxK--;
            int n15 = idxK--;
            x2 = (y2 ^= this.K[n13]) << 10 | y2 >>> 22;
            x0 = (y0 ^= this.K[n15]) << 27 | y0 >>> 5;
            x2 = x2 ^ y3 ^ (y1 ^= this.K[n14]) << 7;
            x0 = x0 ^ y1 ^ y3;
            x3 = y3 << 25 | y3 >>> 7;
            x1 = y1 << 31 | y1 >>> 1;
            x3 = x3 ^ x2 ^ x0 << 3;
            x1 = x1 ^ x0 ^ x2;
            x2 = x2 << 29 | x2 >>> 3;
            x0 = x0 << 19 | x0 >>> 13;
            t01 = x0 ^ x3;
            t02 = x2 ^ x3;
            t03 = x0 & x2;
            t04 = x1 | t02;
            y0 = t01 ^ t04;
            t06 = x0 | x2;
            t07 = x3 | y0;
            t08 = ~x3;
            t09 = x1 & t06;
            t10 = t08 | t03;
            t11 = x1 & t07;
            t12 = t06 & t02;
            y3 = t09 ^ t10;
            y1 = t12 ^ t11;
            t15 = x2 & y3;
            t16 = y0 ^ y1;
            t17 = t10 ^ t15;
            y2 = t16 ^ t17;
            y3 ^= this.K[idxK--];
            int n16 = idxK--;
            int n17 = idxK--;
            int n18 = idxK--;
            x2 = (y2 ^= this.K[n16]) << 10 | y2 >>> 22;
            x0 = (y0 ^= this.K[n18]) << 27 | y0 >>> 5;
            x2 = x2 ^ y3 ^ (y1 ^= this.K[n17]) << 7;
            x0 = x0 ^ y1 ^ y3;
            x3 = y3 << 25 | y3 >>> 7;
            x1 = y1 << 31 | y1 >>> 1;
            x3 = x3 ^ x2 ^ x0 << 3;
            x1 = x1 ^ x0 ^ x2;
            x2 = x2 << 29 | x2 >>> 3;
            x0 = x0 << 19 | x0 >>> 13;
            t01 = x0 ^ x1;
            t02 = x1 | x3;
            t03 = x0 & x2;
            t04 = x2 ^ t02;
            t05 = x0 | t04;
            t06 = t01 & t05;
            t07 = x3 | t03;
            t08 = x1 ^ t06;
            t09 = t07 ^ t06;
            t10 = t04 | t03;
            t11 = x3 & t08;
            y2 = ~t09;
            y1 = t10 ^ t11;
            t14 = x0 | y2;
            t15 = t06 ^ y1;
            y3 = t01 ^ t04;
            t17 = x2 ^ t15;
            y0 = t14 ^ t17;
            y3 ^= this.K[idxK--];
            int n19 = idxK--;
            int n20 = idxK--;
            int n21 = idxK--;
            x2 = (y2 ^= this.K[n19]) << 10 | y2 >>> 22;
            x0 = (y0 ^= this.K[n21]) << 27 | y0 >>> 5;
            x2 = x2 ^ y3 ^ (y1 ^= this.K[n20]) << 7;
            x0 = x0 ^ y1 ^ y3;
            x3 = y3 << 25 | y3 >>> 7;
            x1 = y1 << 31 | y1 >>> 1;
            x3 = x3 ^ x2 ^ x0 << 3;
            x1 = x1 ^ x0 ^ x2;
            x2 = x2 << 29 | x2 >>> 3;
            x0 = x0 << 19 | x0 >>> 13;
            t01 = x2 ^ x3;
            t02 = x0 | x1;
            t03 = x1 | x2;
            t04 = x2 & t01;
            t05 = t02 ^ t01;
            t06 = x0 | t04;
            y2 = ~t05;
            t08 = x1 ^ x3;
            t09 = t03 & t08;
            t10 = x3 | y2;
            y1 = t09 ^ t06;
            t12 = x0 | t05;
            t13 = y1 ^ t12;
            t14 = t03 ^ t10;
            t15 = x0 ^ x2;
            y3 = t14 ^ t13;
            t17 = t05 & t13;
            int t18 = t14 | t17;
            y0 = t15 ^ t18;
            y3 ^= this.K[idxK--];
            y2 ^= this.K[idxK--];
            y1 ^= this.K[idxK--];
            y0 ^= this.K[idxK--];
            if (i == 3) break;
            x2 = y2 << 10 | y2 >>> 22;
            x0 = y0 << 27 | y0 >>> 5;
            x2 = x2 ^ y3 ^ y1 << 7;
            x0 = x0 ^ y1 ^ y3;
            x3 = y3 << 25 | y3 >>> 7;
            x1 = y1 << 31 | y1 >>> 1;
            x3 = x3 ^ x2 ^ x0 << 3;
            x1 = x1 ^ x0 ^ x2;
            x2 = x2 << 29 | x2 >>> 3;
            x0 = x0 << 19 | x0 >>> 13;
            ++i;
        }
        out[outOffset++] = (byte)(y3 >>> 24);
        out[outOffset++] = (byte)(y3 >>> 16);
        out[outOffset++] = (byte)(y3 >>> 8);
        out[outOffset++] = (byte)y3;
        out[outOffset++] = (byte)(y2 >>> 24);
        out[outOffset++] = (byte)(y2 >>> 16);
        out[outOffset++] = (byte)(y2 >>> 8);
        out[outOffset++] = (byte)y2;
        out[outOffset++] = (byte)(y1 >>> 24);
        out[outOffset++] = (byte)(y1 >>> 16);
        out[outOffset++] = (byte)(y1 >>> 8);
        out[outOffset++] = (byte)y1;
        out[outOffset++] = (byte)(y0 >>> 24);
        out[outOffset++] = (byte)(y0 >>> 16);
        out[outOffset++] = (byte)(y0 >>> 8);
        out[outOffset] = (byte)y0;
    }

    public Serpent() {
        super(16);
    }

    static {
        String SBOX_INIT = "8\u00f1\u00a6[\u00edBp\u009c\u00fc'\u0090Z\u001b\u00e8m4\u0086y<\u00af\u00d1\u00e4\u000bR\u000f\u00b8\u00c9c\u00d1$\u00a7^\u001f\u0083\u00c0\u00b6%J\u009e}\u00f5+J\u009c\u0003\u00e8\u00d6qr\u00c5\u0084k\u00e9\u001f\u00d3\u00a0\u001d\u00f0\u00e8+t\u00ca\u0093V";
        int i = 0;
        while (i < 8) {
            int j = 0;
            while (j < 16) {
                int ci = i * 8 + j / 2;
                Serpent.Sbox[i][j] = (byte)(SBOX_INIT.charAt(ci) >>> 4);
                Serpent.Sbox[i][++j] = (byte)(SBOX_INIT.charAt(ci) & 0xF);
                ++j;
            }
            ++i;
        }
    }
}

