/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.cipher;

import cryptix.jce.provider.cipher.BlockCipher;
import java.security.InvalidKeyException;
import java.security.Key;

public final class Rijndael
extends BlockCipher {
    private static final int BLOCK_SIZE = 16;
    private static int[] alog;
    private static int[] log;
    private static final byte[] S;
    private static final byte[] Si;
    private static final int[] T1;
    private static final int[] T2;
    private static final int[] T3;
    private static final int[] T4;
    private static final int[] T5;
    private static final int[] T6;
    private static final int[] T7;
    private static final int[] T8;
    private static final int[] U1;
    private static final int[] U2;
    private static final int[] U3;
    private static final int[] U4;
    private static final byte[] rcon;
    private boolean ROUNDS_12;
    private boolean ROUNDS_14;
    private boolean decrypt;
    private int[] K;
    private int limit;

    protected void coreInit(Key key, boolean decrypt) throws InvalidKeyException {
        if (key == null) {
            throw new InvalidKeyException("Key missing");
        }
        if (!key.getFormat().equalsIgnoreCase("RAW")) {
            throw new InvalidKeyException("Wrong format: RAW bytes needed");
        }
        byte[] userkey = key.getEncoded();
        if (userkey == null) {
            throw new InvalidKeyException("RAW bytes missing");
        }
        int len = userkey.length;
        if (len != 16 && len != 24 && len != 32) {
            throw new InvalidKeyException("Invalid user key length");
        }
        Object o = Rijndael.makeKey(userkey, decrypt);
        this.decrypt = decrypt;
        int[][] Kd = (int[][])((Object[])o)[decrypt ? 1 : 0];
        int rounds = Kd.length;
        this.K = new int[rounds * 4];
        int i = 0;
        while (i < rounds) {
            int j = 0;
            while (j < 4) {
                this.K[i * 4 + j] = Kd[i][j];
                ++j;
            }
            ++i;
        }
        if (decrypt) {
            int j0 = this.K[this.K.length - 4];
            int j1 = this.K[this.K.length - 3];
            int j2 = this.K[this.K.length - 2];
            int j3 = this.K[this.K.length - 1];
            int i2 = this.K.length - 1;
            while (i2 > 3) {
                this.K[i2] = this.K[i2 - 4];
                --i2;
            }
            this.K[0] = j0;
            this.K[1] = j1;
            this.K[2] = j2;
            this.K[3] = j3;
        }
        this.ROUNDS_12 = rounds >= 13;
        this.ROUNDS_14 = rounds == 15;
        this.limit = --rounds * 4;
    }

    protected void coreCrypt(byte[] in, int inOffset, byte[] out, int outOffset) {
        if (this.decrypt) {
            this.blockDecrypt(in, inOffset, out, outOffset);
        } else {
            this.blockEncrypt(in, inOffset, out, outOffset);
        }
    }

    static final int mul(int a, int b) {
        return a != 0 && b != 0 ? alog[(log[a & 0xFF] + log[b & 0xFF]) % 255] : 0;
    }

    static final int mul4(int a, byte[] b) {
        if (a == 0) {
            return 0;
        }
        a = log[a & 0xFF];
        int a0 = b[0] != 0 ? alog[(a + log[b[0] & 0xFF]) % 255] & 0xFF : 0;
        int a1 = b[1] != 0 ? alog[(a + log[b[1] & 0xFF]) % 255] & 0xFF : 0;
        int a2 = b[2] != 0 ? alog[(a + log[b[2] & 0xFF]) % 255] & 0xFF : 0;
        int a3 = b[3] != 0 ? alog[(a + log[b[3] & 0xFF]) % 255] & 0xFF : 0;
        return a0 << 24 | a1 << 16 | a2 << 8 | a3;
    }

    private void blockEncrypt(byte[] in, int inOffset, byte[] out, int outOffset) {
        int keyOffset = 0;
        int t0 = (in[inOffset++] << 24 | (in[inOffset++] & 0xFF) << 16 | (in[inOffset++] & 0xFF) << 8 | in[inOffset++] & 0xFF) ^ this.K[keyOffset++];
        int t1 = (in[inOffset++] << 24 | (in[inOffset++] & 0xFF) << 16 | (in[inOffset++] & 0xFF) << 8 | in[inOffset++] & 0xFF) ^ this.K[keyOffset++];
        int t2 = (in[inOffset++] << 24 | (in[inOffset++] & 0xFF) << 16 | (in[inOffset++] & 0xFF) << 8 | in[inOffset++] & 0xFF) ^ this.K[keyOffset++];
        int t3 = (in[inOffset++] << 24 | (in[inOffset++] & 0xFF) << 16 | (in[inOffset++] & 0xFF) << 8 | in[inOffset++] & 0xFF) ^ this.K[keyOffset++];
        while (keyOffset < this.limit) {
            int a0 = T1[t0 >>> 24] ^ T2[t1 >>> 16 & 0xFF] ^ T3[t2 >>> 8 & 0xFF] ^ T4[t3 & 0xFF] ^ this.K[keyOffset++];
            int a1 = T1[t1 >>> 24] ^ T2[t2 >>> 16 & 0xFF] ^ T3[t3 >>> 8 & 0xFF] ^ T4[t0 & 0xFF] ^ this.K[keyOffset++];
            int a2 = T1[t2 >>> 24] ^ T2[t3 >>> 16 & 0xFF] ^ T3[t0 >>> 8 & 0xFF] ^ T4[t1 & 0xFF] ^ this.K[keyOffset++];
            t3 = T1[t3 >>> 24] ^ T2[t0 >>> 16 & 0xFF] ^ T3[t1 >>> 8 & 0xFF] ^ T4[t2 & 0xFF] ^ this.K[keyOffset++];
            t0 = a0;
            t1 = a1;
            t2 = a2;
        }
        int tt = this.K[keyOffset++];
        out[outOffset++] = (byte)(S[t0 >>> 24] ^ tt >>> 24);
        out[outOffset++] = (byte)(S[t1 >>> 16 & 0xFF] ^ tt >>> 16);
        out[outOffset++] = (byte)(S[t2 >>> 8 & 0xFF] ^ tt >>> 8);
        out[outOffset++] = (byte)(S[t3 & 0xFF] ^ tt);
        tt = this.K[keyOffset++];
        out[outOffset++] = (byte)(S[t1 >>> 24] ^ tt >>> 24);
        out[outOffset++] = (byte)(S[t2 >>> 16 & 0xFF] ^ tt >>> 16);
        out[outOffset++] = (byte)(S[t3 >>> 8 & 0xFF] ^ tt >>> 8);
        out[outOffset++] = (byte)(S[t0 & 0xFF] ^ tt);
        tt = this.K[keyOffset++];
        out[outOffset++] = (byte)(S[t2 >>> 24] ^ tt >>> 24);
        out[outOffset++] = (byte)(S[t3 >>> 16 & 0xFF] ^ tt >>> 16);
        out[outOffset++] = (byte)(S[t0 >>> 8 & 0xFF] ^ tt >>> 8);
        out[outOffset++] = (byte)(S[t1 & 0xFF] ^ tt);
        tt = this.K[keyOffset++];
        out[outOffset++] = (byte)(S[t3 >>> 24] ^ tt >>> 24);
        out[outOffset++] = (byte)(S[t0 >>> 16 & 0xFF] ^ tt >>> 16);
        out[outOffset++] = (byte)(S[t1 >>> 8 & 0xFF] ^ tt >>> 8);
        out[outOffset] = (byte)(S[t2 & 0xFF] ^ tt);
    }

    private void blockDecrypt(byte[] in, int inOffset, byte[] out, int outOffset) {
        int a2;
        int a1;
        int a0;
        int keyOffset = 8;
        int t0 = (in[inOffset++] << 24 | (in[inOffset++] & 0xFF) << 16 | (in[inOffset++] & 0xFF) << 8 | in[inOffset++] & 0xFF) ^ this.K[4];
        int t1 = (in[inOffset++] << 24 | (in[inOffset++] & 0xFF) << 16 | (in[inOffset++] & 0xFF) << 8 | in[inOffset++] & 0xFF) ^ this.K[5];
        int t2 = (in[inOffset++] << 24 | (in[inOffset++] & 0xFF) << 16 | (in[inOffset++] & 0xFF) << 8 | in[inOffset++] & 0xFF) ^ this.K[6];
        int t3 = (in[inOffset++] << 24 | (in[inOffset++] & 0xFF) << 16 | (in[inOffset++] & 0xFF) << 8 | in[inOffset] & 0xFF) ^ this.K[7];
        if (this.ROUNDS_12) {
            a0 = T5[t0 >>> 24] ^ T6[t3 >>> 16 & 0xFF] ^ T7[t2 >>> 8 & 0xFF] ^ T8[t1 & 0xFF] ^ this.K[keyOffset++];
            a1 = T5[t1 >>> 24] ^ T6[t0 >>> 16 & 0xFF] ^ T7[t3 >>> 8 & 0xFF] ^ T8[t2 & 0xFF] ^ this.K[keyOffset++];
            a2 = T5[t2 >>> 24] ^ T6[t1 >>> 16 & 0xFF] ^ T7[t0 >>> 8 & 0xFF] ^ T8[t3 & 0xFF] ^ this.K[keyOffset++];
            t3 = T5[t3 >>> 24] ^ T6[t2 >>> 16 & 0xFF] ^ T7[t1 >>> 8 & 0xFF] ^ T8[t0 & 0xFF] ^ this.K[keyOffset++];
            t0 = T5[a0 >>> 24] ^ T6[t3 >>> 16 & 0xFF] ^ T7[a2 >>> 8 & 0xFF] ^ T8[a1 & 0xFF] ^ this.K[keyOffset++];
            t1 = T5[a1 >>> 24] ^ T6[a0 >>> 16 & 0xFF] ^ T7[t3 >>> 8 & 0xFF] ^ T8[a2 & 0xFF] ^ this.K[keyOffset++];
            t2 = T5[a2 >>> 24] ^ T6[a1 >>> 16 & 0xFF] ^ T7[a0 >>> 8 & 0xFF] ^ T8[t3 & 0xFF] ^ this.K[keyOffset++];
            t3 = T5[t3 >>> 24] ^ T6[a2 >>> 16 & 0xFF] ^ T7[a1 >>> 8 & 0xFF] ^ T8[a0 & 0xFF] ^ this.K[keyOffset++];
            if (this.ROUNDS_14) {
                a0 = T5[t0 >>> 24] ^ T6[t3 >>> 16 & 0xFF] ^ T7[t2 >>> 8 & 0xFF] ^ T8[t1 & 0xFF] ^ this.K[keyOffset++];
                a1 = T5[t1 >>> 24] ^ T6[t0 >>> 16 & 0xFF] ^ T7[t3 >>> 8 & 0xFF] ^ T8[t2 & 0xFF] ^ this.K[keyOffset++];
                a2 = T5[t2 >>> 24] ^ T6[t1 >>> 16 & 0xFF] ^ T7[t0 >>> 8 & 0xFF] ^ T8[t3 & 0xFF] ^ this.K[keyOffset++];
                t3 = T5[t3 >>> 24] ^ T6[t2 >>> 16 & 0xFF] ^ T7[t1 >>> 8 & 0xFF] ^ T8[t0 & 0xFF] ^ this.K[keyOffset++];
                t0 = T5[a0 >>> 24] ^ T6[t3 >>> 16 & 0xFF] ^ T7[a2 >>> 8 & 0xFF] ^ T8[a1 & 0xFF] ^ this.K[keyOffset++];
                t1 = T5[a1 >>> 24] ^ T6[a0 >>> 16 & 0xFF] ^ T7[t3 >>> 8 & 0xFF] ^ T8[a2 & 0xFF] ^ this.K[keyOffset++];
                t2 = T5[a2 >>> 24] ^ T6[a1 >>> 16 & 0xFF] ^ T7[a0 >>> 8 & 0xFF] ^ T8[t3 & 0xFF] ^ this.K[keyOffset++];
                t3 = T5[t3 >>> 24] ^ T6[a2 >>> 16 & 0xFF] ^ T7[a1 >>> 8 & 0xFF] ^ T8[a0 & 0xFF] ^ this.K[keyOffset++];
            }
        }
        a0 = T5[t0 >>> 24] ^ T6[t3 >>> 16 & 0xFF] ^ T7[t2 >>> 8 & 0xFF] ^ T8[t1 & 0xFF] ^ this.K[keyOffset++];
        a1 = T5[t1 >>> 24] ^ T6[t0 >>> 16 & 0xFF] ^ T7[t3 >>> 8 & 0xFF] ^ T8[t2 & 0xFF] ^ this.K[keyOffset++];
        a2 = T5[t2 >>> 24] ^ T6[t1 >>> 16 & 0xFF] ^ T7[t0 >>> 8 & 0xFF] ^ T8[t3 & 0xFF] ^ this.K[keyOffset++];
        t3 = T5[t3 >>> 24] ^ T6[t2 >>> 16 & 0xFF] ^ T7[t1 >>> 8 & 0xFF] ^ T8[t0 & 0xFF] ^ this.K[keyOffset++];
        t0 = T5[a0 >>> 24] ^ T6[t3 >>> 16 & 0xFF] ^ T7[a2 >>> 8 & 0xFF] ^ T8[a1 & 0xFF] ^ this.K[keyOffset++];
        t1 = T5[a1 >>> 24] ^ T6[a0 >>> 16 & 0xFF] ^ T7[t3 >>> 8 & 0xFF] ^ T8[a2 & 0xFF] ^ this.K[keyOffset++];
        t2 = T5[a2 >>> 24] ^ T6[a1 >>> 16 & 0xFF] ^ T7[a0 >>> 8 & 0xFF] ^ T8[t3 & 0xFF] ^ this.K[keyOffset++];
        t3 = T5[t3 >>> 24] ^ T6[a2 >>> 16 & 0xFF] ^ T7[a1 >>> 8 & 0xFF] ^ T8[a0 & 0xFF] ^ this.K[keyOffset++];
        a0 = T5[t0 >>> 24] ^ T6[t3 >>> 16 & 0xFF] ^ T7[t2 >>> 8 & 0xFF] ^ T8[t1 & 0xFF] ^ this.K[keyOffset++];
        a1 = T5[t1 >>> 24] ^ T6[t0 >>> 16 & 0xFF] ^ T7[t3 >>> 8 & 0xFF] ^ T8[t2 & 0xFF] ^ this.K[keyOffset++];
        a2 = T5[t2 >>> 24] ^ T6[t1 >>> 16 & 0xFF] ^ T7[t0 >>> 8 & 0xFF] ^ T8[t3 & 0xFF] ^ this.K[keyOffset++];
        t3 = T5[t3 >>> 24] ^ T6[t2 >>> 16 & 0xFF] ^ T7[t1 >>> 8 & 0xFF] ^ T8[t0 & 0xFF] ^ this.K[keyOffset++];
        t0 = T5[a0 >>> 24] ^ T6[t3 >>> 16 & 0xFF] ^ T7[a2 >>> 8 & 0xFF] ^ T8[a1 & 0xFF] ^ this.K[keyOffset++];
        t1 = T5[a1 >>> 24] ^ T6[a0 >>> 16 & 0xFF] ^ T7[t3 >>> 8 & 0xFF] ^ T8[a2 & 0xFF] ^ this.K[keyOffset++];
        t2 = T5[a2 >>> 24] ^ T6[a1 >>> 16 & 0xFF] ^ T7[a0 >>> 8 & 0xFF] ^ T8[t3 & 0xFF] ^ this.K[keyOffset++];
        t3 = T5[t3 >>> 24] ^ T6[a2 >>> 16 & 0xFF] ^ T7[a1 >>> 8 & 0xFF] ^ T8[a0 & 0xFF] ^ this.K[keyOffset++];
        a0 = T5[t0 >>> 24] ^ T6[t3 >>> 16 & 0xFF] ^ T7[t2 >>> 8 & 0xFF] ^ T8[t1 & 0xFF] ^ this.K[keyOffset++];
        a1 = T5[t1 >>> 24] ^ T6[t0 >>> 16 & 0xFF] ^ T7[t3 >>> 8 & 0xFF] ^ T8[t2 & 0xFF] ^ this.K[keyOffset++];
        a2 = T5[t2 >>> 24] ^ T6[t1 >>> 16 & 0xFF] ^ T7[t0 >>> 8 & 0xFF] ^ T8[t3 & 0xFF] ^ this.K[keyOffset++];
        t3 = T5[t3 >>> 24] ^ T6[t2 >>> 16 & 0xFF] ^ T7[t1 >>> 8 & 0xFF] ^ T8[t0 & 0xFF] ^ this.K[keyOffset++];
        t0 = T5[a0 >>> 24] ^ T6[t3 >>> 16 & 0xFF] ^ T7[a2 >>> 8 & 0xFF] ^ T8[a1 & 0xFF] ^ this.K[keyOffset++];
        t1 = T5[a1 >>> 24] ^ T6[a0 >>> 16 & 0xFF] ^ T7[t3 >>> 8 & 0xFF] ^ T8[a2 & 0xFF] ^ this.K[keyOffset++];
        t2 = T5[a2 >>> 24] ^ T6[a1 >>> 16 & 0xFF] ^ T7[a0 >>> 8 & 0xFF] ^ T8[t3 & 0xFF] ^ this.K[keyOffset++];
        t3 = T5[t3 >>> 24] ^ T6[a2 >>> 16 & 0xFF] ^ T7[a1 >>> 8 & 0xFF] ^ T8[a0 & 0xFF] ^ this.K[keyOffset++];
        a0 = T5[t0 >>> 24] ^ T6[t3 >>> 16 & 0xFF] ^ T7[t2 >>> 8 & 0xFF] ^ T8[t1 & 0xFF] ^ this.K[keyOffset++];
        a1 = T5[t1 >>> 24] ^ T6[t0 >>> 16 & 0xFF] ^ T7[t3 >>> 8 & 0xFF] ^ T8[t2 & 0xFF] ^ this.K[keyOffset++];
        a2 = T5[t2 >>> 24] ^ T6[t1 >>> 16 & 0xFF] ^ T7[t0 >>> 8 & 0xFF] ^ T8[t3 & 0xFF] ^ this.K[keyOffset++];
        t3 = T5[t3 >>> 24] ^ T6[t2 >>> 16 & 0xFF] ^ T7[t1 >>> 8 & 0xFF] ^ T8[t0 & 0xFF] ^ this.K[keyOffset++];
        t0 = T5[a0 >>> 24] ^ T6[t3 >>> 16 & 0xFF] ^ T7[a2 >>> 8 & 0xFF] ^ T8[a1 & 0xFF] ^ this.K[keyOffset++];
        t1 = T5[a1 >>> 24] ^ T6[a0 >>> 16 & 0xFF] ^ T7[t3 >>> 8 & 0xFF] ^ T8[a2 & 0xFF] ^ this.K[keyOffset++];
        t2 = T5[a2 >>> 24] ^ T6[a1 >>> 16 & 0xFF] ^ T7[a0 >>> 8 & 0xFF] ^ T8[t3 & 0xFF] ^ this.K[keyOffset++];
        t3 = T5[t3 >>> 24] ^ T6[a2 >>> 16 & 0xFF] ^ T7[a1 >>> 8 & 0xFF] ^ T8[a0 & 0xFF] ^ this.K[keyOffset++];
        a0 = T5[t0 >>> 24] ^ T6[t3 >>> 16 & 0xFF] ^ T7[t2 >>> 8 & 0xFF] ^ T8[t1 & 0xFF] ^ this.K[keyOffset++];
        a1 = T5[t1 >>> 24] ^ T6[t0 >>> 16 & 0xFF] ^ T7[t3 >>> 8 & 0xFF] ^ T8[t2 & 0xFF] ^ this.K[keyOffset++];
        a2 = T5[t2 >>> 24] ^ T6[t1 >>> 16 & 0xFF] ^ T7[t0 >>> 8 & 0xFF] ^ T8[t3 & 0xFF] ^ this.K[keyOffset++];
        t3 = T5[t3 >>> 24] ^ T6[t2 >>> 16 & 0xFF] ^ T7[t1 >>> 8 & 0xFF] ^ T8[t0 & 0xFF] ^ this.K[keyOffset++];
        t1 = this.K[0];
        out[outOffset++] = (byte)(Si[a0 >>> 24] ^ t1 >>> 24);
        out[outOffset++] = (byte)(Si[t3 >>> 16 & 0xFF] ^ t1 >>> 16);
        out[outOffset++] = (byte)(Si[a2 >>> 8 & 0xFF] ^ t1 >>> 8);
        out[outOffset++] = (byte)(Si[a1 & 0xFF] ^ t1);
        t1 = this.K[1];
        out[outOffset++] = (byte)(Si[a1 >>> 24] ^ t1 >>> 24);
        out[outOffset++] = (byte)(Si[a0 >>> 16 & 0xFF] ^ t1 >>> 16);
        out[outOffset++] = (byte)(Si[t3 >>> 8 & 0xFF] ^ t1 >>> 8);
        out[outOffset++] = (byte)(Si[a2 & 0xFF] ^ t1);
        t1 = this.K[2];
        out[outOffset++] = (byte)(Si[a2 >>> 24] ^ t1 >>> 24);
        out[outOffset++] = (byte)(Si[a1 >>> 16 & 0xFF] ^ t1 >>> 16);
        out[outOffset++] = (byte)(Si[a0 >>> 8 & 0xFF] ^ t1 >>> 8);
        out[outOffset++] = (byte)(Si[t3 & 0xFF] ^ t1);
        t1 = this.K[3];
        out[outOffset++] = (byte)(Si[t3 >>> 24] ^ t1 >>> 24);
        out[outOffset++] = (byte)(Si[a2 >>> 16 & 0xFF] ^ t1 >>> 16);
        out[outOffset++] = (byte)(Si[a1 >>> 8 & 0xFF] ^ t1 >>> 8);
        out[outOffset] = (byte)(Si[a0 & 0xFF] ^ t1);
    }

    private static Object makeKey(byte[] k, boolean decrypt) throws InvalidKeyException {
        int tt;
        if (k == null) {
            throw new InvalidKeyException("Empty key");
        }
        if (k.length != 16 && k.length != 24 && k.length != 32) {
            throw new InvalidKeyException("Incorrect key length");
        }
        int ROUNDS = Rijndael.getRounds(k.length);
        int ROUND_KEY_COUNT = (ROUNDS + 1) * 4;
        int BC = 4;
        int[][] Ke = new int[ROUNDS + 1][4];
        int[][] Kd = new int[ROUNDS + 1][4];
        int KC = k.length / 4;
        int[] tk = new int[KC];
        int i = 0;
        int j = 0;
        while (i < KC) {
            tk[i++] = k[j++] << 24 | (k[j++] & 0xFF) << 16 | (k[j++] & 0xFF) << 8 | k[j++] & 0xFF;
        }
        int t = 0;
        j = 0;
        while (j < KC && t < ROUND_KEY_COUNT) {
            Ke[t / 4][t % 4] = tk[j];
            Kd[ROUNDS - t / 4][t % 4] = tk[j];
            ++j;
            ++t;
        }
        int rconpointer = 0;
        while (t < ROUND_KEY_COUNT) {
            tt = tk[KC - 1];
            tk[0] = tk[0] ^ (S[tt >>> 16 & 0xFF] << 24 ^ (S[tt >>> 8 & 0xFF] & 0xFF) << 16 ^ (S[tt & 0xFF] & 0xFF) << 8 ^ S[tt >>> 24] & 0xFF ^ rcon[rconpointer++] << 24);
            if (KC != 8) {
                i = 1;
                j = 0;
                while (i < KC) {
                    int n = i++;
                    tk[n] = tk[n] ^ tk[j++];
                }
            } else {
                i = 1;
                j = 0;
                while (i < KC / 2) {
                    int n = i++;
                    tk[n] = tk[n] ^ tk[j++];
                }
                tt = tk[KC / 2 - 1];
                int n = KC / 2;
                tk[n] = tk[n] ^ (S[tt & 0xFF] & 0xFF ^ (S[tt >>> 8 & 0xFF] & 0xFF) << 8 ^ (S[tt >>> 16 & 0xFF] & 0xFF) << 16 ^ S[tt >>> 24] << 24);
                j = KC / 2;
                i = j + 1;
                while (i < KC) {
                    int n2 = i++;
                    tk[n2] = tk[n2] ^ tk[j++];
                }
            }
            j = 0;
            while (j < KC && t < ROUND_KEY_COUNT) {
                Ke[t / 4][t % 4] = tk[j];
                Kd[ROUNDS - t / 4][t % 4] = tk[j];
                ++j;
                ++t;
            }
        }
        int r = 1;
        while (r < ROUNDS) {
            j = 0;
            while (j < BC) {
                tt = Kd[r][j];
                Kd[r][j] = U1[tt >>> 24 & 0xFF] ^ U2[tt >>> 16 & 0xFF] ^ U3[tt >>> 8 & 0xFF] ^ U4[tt & 0xFF];
                ++j;
            }
            ++r;
        }
        Object[] sessionKey = new Object[]{Ke, Kd};
        return sessionKey;
    }

    private static int getRounds(int keySize) {
        return (keySize >> 2) + 6;
    }

    public Rijndael() {
        super(16);
    }

    static {
        int t;
        alog = new int[256];
        log = new int[256];
        S = new byte[256];
        Si = new byte[256];
        T1 = new int[256];
        T2 = new int[256];
        T3 = new int[256];
        T4 = new int[256];
        T5 = new int[256];
        T6 = new int[256];
        T7 = new int[256];
        T8 = new int[256];
        U1 = new int[256];
        U2 = new int[256];
        U3 = new int[256];
        U4 = new int[256];
        rcon = new byte[30];
        int ROOT = 283;
        int j = 0;
        Rijndael.alog[0] = 1;
        int i = 1;
        while (i < 256) {
            j = alog[i - 1] << 1 ^ alog[i - 1];
            if ((j & 0x100) != 0) {
                j ^= ROOT;
            }
            Rijndael.alog[i] = j;
            ++i;
        }
        i = 1;
        while (i < 255) {
            Rijndael.log[Rijndael.alog[i]] = i;
            ++i;
        }
        byte[][] A = new byte[][]{{1, 1, 1, 1, 1, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 0, 0}, {0, 0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 1, 1, 1, 1}, {1, 0, 0, 0, 1, 1, 1, 1}, {1, 1, 0, 0, 0, 1, 1, 1}, {1, 1, 1, 0, 0, 0, 1, 1}, {1, 1, 1, 1, 0, 0, 0, 1}};
        byte[] B = new byte[]{0, 1, 1, 0, 0, 0, 1, 1};
        byte[][] box = new byte[256][8];
        box[1][7] = 1;
        i = 2;
        while (i < 256) {
            j = alog[255 - log[i]];
            t = 0;
            while (t < 8) {
                box[i][t] = (byte)(j >>> 7 - t & 1);
                ++t;
            }
            ++i;
        }
        byte[][] cox = new byte[256][8];
        i = 0;
        while (i < 256) {
            t = 0;
            while (t < 8) {
                cox[i][t] = B[t];
                j = 0;
                while (j < 8) {
                    byte[] byArray = cox[i];
                    int n = t;
                    byArray[n] = (byte)(byArray[n] ^ A[t][j] * box[i][j]);
                    ++j;
                }
                ++t;
            }
            ++i;
        }
        i = 0;
        while (i < 256) {
            Rijndael.S[i] = (byte)(cox[i][0] << 7);
            t = 1;
            while (t < 8) {
                int n = i;
                S[n] = (byte)(S[n] ^ cox[i][t] << 7 - t);
                ++t;
            }
            Rijndael.Si[Rijndael.S[i] & 0xFF] = (byte)i;
            ++i;
        }
        byte[][] G = new byte[][]{{2, 1, 1, 3}, {3, 2, 1, 1}, {1, 3, 2, 1}, {1, 1, 3, 2}};
        byte[][] AA = new byte[4][8];
        i = 0;
        while (i < 4) {
            j = 0;
            while (j < 4) {
                AA[i][j] = G[i][j];
                ++j;
            }
            AA[i][i + 4] = 1;
            ++i;
        }
        byte[][] iG = new byte[4][4];
        i = 0;
        while (i < 4) {
            byte pivot = AA[i][i];
            if (pivot == 0) {
                t = i + 1;
                while (AA[t][i] == 0 && t < 4) {
                    ++t;
                }
                if (t == 4) {
                    throw new RuntimeException("G matrix is not invertible");
                }
                j = 0;
                while (j < 8) {
                    byte tmp = AA[i][j];
                    AA[i][j] = AA[t][j];
                    AA[t][j] = tmp;
                    ++j;
                }
                pivot = AA[i][i];
            }
            j = 0;
            while (j < 8) {
                if (AA[i][j] != 0) {
                    AA[i][j] = (byte)alog[(255 + log[AA[i][j] & 0xFF] - log[pivot & 0xFF]) % 255];
                }
                ++j;
            }
            t = 0;
            while (t < 4) {
                if (i != t) {
                    j = i + 1;
                    while (j < 8) {
                        byte[] byArray = AA[t];
                        int n = j;
                        byArray[n] = (byte)(byArray[n] ^ Rijndael.mul(AA[i][j], AA[t][i]));
                        ++j;
                    }
                    AA[t][i] = 0;
                }
                ++t;
            }
            ++i;
        }
        i = 0;
        while (i < 4) {
            j = 0;
            while (j < 4) {
                iG[i][j] = AA[i][j + 4];
                ++j;
            }
            ++i;
        }
        t = 0;
        while (t < 256) {
            byte s = S[t];
            Rijndael.T1[t] = Rijndael.mul4(s, G[0]);
            Rijndael.T2[t] = Rijndael.mul4(s, G[1]);
            Rijndael.T3[t] = Rijndael.mul4(s, G[2]);
            Rijndael.T4[t] = Rijndael.mul4(s, G[3]);
            s = Si[t];
            Rijndael.T5[t] = Rijndael.mul4(s, iG[0]);
            Rijndael.T6[t] = Rijndael.mul4(s, iG[1]);
            Rijndael.T7[t] = Rijndael.mul4(s, iG[2]);
            Rijndael.T8[t] = Rijndael.mul4(s, iG[3]);
            Rijndael.U1[t] = Rijndael.mul4(t, iG[0]);
            Rijndael.U2[t] = Rijndael.mul4(t, iG[1]);
            Rijndael.U3[t] = Rijndael.mul4(t, iG[2]);
            Rijndael.U4[t] = Rijndael.mul4(t, iG[3]);
            ++t;
        }
        Rijndael.rcon[0] = 1;
        int r = 1;
        t = 1;
        while (t < 30) {
            int n = t++;
            r = Rijndael.mul(2, r);
            Rijndael.rcon[n] = (byte)r;
        }
        log = null;
        alog = null;
    }
}

