/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.cipher;

import cryptix.jce.provider.cipher.Mode;
import cryptix.jce.provider.cipher.PaddingNone;
import cryptix.jce.provider.cipher.PaddingPKCS5;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;

abstract class Padding {
    private final Mode mode;
    private byte[] scratchBuf;
    protected boolean decrypt;

    static Padding getInstance(String padding, Mode mode) throws NoSuchPaddingException {
        if (padding.equalsIgnoreCase("None") || padding.equalsIgnoreCase("NoPadding")) {
            return new PaddingNone(mode);
        }
        if (padding.equalsIgnoreCase("PKCS5") || padding.equalsIgnoreCase("PKCS#5") || padding.equalsIgnoreCase("PKCS7") || padding.equalsIgnoreCase("PKCS#7")) {
            return new PaddingPKCS5(mode);
        }
        throw new NoSuchPaddingException("Padding not available [" + padding + "]");
    }

    final int getBlockSize() {
        return this.mode.getBlockSize();
    }

    final int getOutputSize(int inputLen) {
        return this.mode.getOutputSize(inputLen + this.getPadSize(inputLen));
    }

    final AlgorithmParameterSpec getParamSpec() {
        return this.mode.getParamSpec();
    }

    final byte[] getIV() {
        return this.mode.getIV();
    }

    final void init(boolean decrypt, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.decrypt = decrypt;
        this.mode.init(this.decrypt, key, params, random);
    }

    final int update(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException {
        return this.mode.update(input, inputOffset, inputLen, output, outputOffset);
    }

    final int doFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        if (this.decrypt) {
            if (input == null) {
                return 0;
            }
            if (inputLen < this.getPadSize(inputLen)) {
                throw new BadPaddingException("Input data not bounded by the padding size");
            }
            int i = this.mode.update(input, inputOffset, inputLen, output, outputOffset);
            return this.coreUnPad(output, i);
        }
        byte[] t = this.corePad(input, inputLen);
        return this.mode.update(t, inputOffset, t.length, output, outputOffset);
    }

    protected int getBufSize() {
        return this.mode.getBufSize();
    }

    abstract byte[] corePad(byte[] var1, int var2) throws IllegalBlockSizeException;

    abstract int coreUnPad(byte[] var1, int var2);

    abstract int getPadSize(int var1);

    Padding(Mode mode) {
        this.mode = mode;
    }
}

