/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.cipher;

import cryptix.jce.provider.cipher.BlockCipher;
import cryptix.jce.provider.cipher.Mode;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;

final class ModeCBC
extends Mode {
    private final byte[] buf = new byte[this.CIPHER_BLOCK_SIZE];
    private final byte[] prevBlock = new byte[this.CIPHER_BLOCK_SIZE];
    private byte[] IV = null;

    final int coreGetOutputSize(int inputLen) {
        return (this.bufCount + inputLen) / this.CIPHER_BLOCK_SIZE * this.CIPHER_BLOCK_SIZE;
    }

    final void coreInit(boolean decrypt, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.cipher.coreInit(key, decrypt);
        if (decrypt) {
            IvParameterSpec iv = (IvParameterSpec)params;
            this.IV = iv.getIV();
            System.arraycopy(this.IV, 0, this.prevBlock, 0, this.CIPHER_BLOCK_SIZE);
            this.bufCount = 0;
        } else {
            IvParameterSpec iv = (IvParameterSpec)params;
            this.IV = iv.getIV();
            System.arraycopy(this.IV, 0, this.buf, 0, this.CIPHER_BLOCK_SIZE);
            this.bufCount = 0;
        }
    }

    int coreUpdate(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException {
        int i;
        int remainder;
        if (this.decrypt) {
            int i2;
            int remainder2;
            int ret = 0;
            while (inputLen >= (remainder2 = this.CIPHER_BLOCK_SIZE - this.bufCount)) {
                i2 = 0;
                while (i2 < remainder2) {
                    this.buf[this.bufCount++] = input[inputOffset++];
                    ++i2;
                }
                this.cipher.coreCrypt(this.buf, 0, output, outputOffset);
                i2 = 0;
                while (i2 < this.CIPHER_BLOCK_SIZE) {
                    int n = outputOffset++;
                    output[n] = (byte)(output[n] ^ this.prevBlock[i2]);
                    ++i2;
                }
                i2 = 0;
                while (i2 < this.CIPHER_BLOCK_SIZE) {
                    this.prevBlock[i2] = this.buf[i2];
                    ++i2;
                }
                inputLen -= this.CIPHER_BLOCK_SIZE;
                ret += this.CIPHER_BLOCK_SIZE;
                this.bufCount = 0;
            }
            i2 = 0;
            while (i2 < inputLen) {
                this.buf[this.bufCount++] = input[inputOffset++];
                ++i2;
            }
            return ret;
        }
        int ret = 0;
        while (inputLen >= (remainder = this.CIPHER_BLOCK_SIZE - this.bufCount)) {
            i = 0;
            while (i < remainder) {
                int n = this.bufCount++;
                this.buf[n] = (byte)(this.buf[n] ^ input[inputOffset++]);
                ++i;
            }
            this.cipher.coreCrypt(this.buf, 0, this.buf, 0);
            System.arraycopy(this.buf, 0, output, outputOffset, this.CIPHER_BLOCK_SIZE);
            inputLen -= remainder;
            outputOffset += this.CIPHER_BLOCK_SIZE;
            ret += this.CIPHER_BLOCK_SIZE;
            this.bufCount = 0;
        }
        i = 0;
        while (i < inputLen) {
            int n = this.bufCount++;
            this.buf[n] = (byte)(this.buf[n] ^ input[inputOffset++]);
            ++i;
        }
        return ret;
    }

    final byte[] coreGetIV() {
        return this.IV;
    }

    final AlgorithmParameterSpec coreGetParamSpec() {
        if (this.IV == null) {
            return new IvParameterSpec(this.generateIV());
        }
        return new IvParameterSpec(this.IV);
    }

    ModeCBC(BlockCipher cipher) {
        super(cipher);
    }
}

