/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.cipher;

import cryptix.jce.provider.cipher.BlockCipher;
import cryptix.jce.provider.cipher.ModeCBC;
import cryptix.jce.provider.cipher.ModeECB;
import cryptix.jce.provider.cipher.ModeOFB;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.ShortBufferException;

abstract class Mode {
    protected final BlockCipher cipher;
    protected final int CIPHER_BLOCK_SIZE;
    protected boolean decrypt;
    protected int bufCount;

    static Mode getInstance(String mode, BlockCipher cipher) throws NoSuchAlgorithmException {
        if (mode.equalsIgnoreCase("CBC")) {
            return new ModeCBC(cipher);
        }
        if (mode.equalsIgnoreCase("ECB")) {
            return new ModeECB(cipher);
        }
        if (mode.equalsIgnoreCase("OFB")) {
            return new ModeOFB(cipher);
        }
        throw new NoSuchAlgorithmException();
    }

    void init(boolean decrypt, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.decrypt = decrypt;
        this.coreInit(decrypt, key, params, random);
    }

    final byte[] getIV() {
        return this.coreGetIV();
    }

    final AlgorithmParameterSpec getParamSpec() {
        return this.coreGetParamSpec();
    }

    final int getOutputSize(int inputLen) {
        return this.coreGetOutputSize(inputLen);
    }

    final int getBlockSize() {
        return this.CIPHER_BLOCK_SIZE;
    }

    final int update(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException {
        return this.coreUpdate(input, inputOffset, inputLen, output, outputOffset);
    }

    final int getBufSize() {
        return this.bufCount;
    }

    /*
     * WARNING - void declaration
     */
    protected byte[] generateIV() {
        void var1_1;
        byte[] b = new byte[this.CIPHER_BLOCK_SIZE];
        SecureRandom sr = new SecureRandom();
        sr.nextBytes(b);
        return var1_1;
    }

    abstract int coreGetOutputSize(int var1);

    abstract void coreInit(boolean var1, Key var2, AlgorithmParameterSpec var3, SecureRandom var4) throws InvalidKeyException, InvalidAlgorithmParameterException;

    abstract int coreUpdate(byte[] var1, int var2, int var3, byte[] var4, int var5) throws ShortBufferException;

    abstract byte[] coreGetIV();

    abstract AlgorithmParameterSpec coreGetParamSpec();

    Mode(BlockCipher cipher) {
        this.cipher = cipher;
        this.CIPHER_BLOCK_SIZE = cipher.coreGetBlockSize();
    }
}

