/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto.spec;

import java.security.spec.AlgorithmParameterSpec;

public class RC5ParameterSpec
implements AlgorithmParameterSpec {
    private final int version;
    private final int rounds;
    private final int wordSize;
    private final byte[] iv;

    public int getVersion() {
        return this.version;
    }

    public int getRounds() {
        return this.rounds;
    }

    public int getWordSize() {
        return this.wordSize;
    }

    public byte[] getIV() {
        return (byte[])this.iv.clone();
    }

    public RC5ParameterSpec(int version, int rounds, int wordSize) {
        this.version = version;
        this.rounds = rounds;
        this.wordSize = wordSize;
        this.iv = null;
    }

    public RC5ParameterSpec(int version, int rounds, int wordSize, byte[] iv) {
        this.version = version;
        this.rounds = rounds;
        this.wordSize = wordSize;
        this.iv = (byte[])iv.clone();
    }

    public RC5ParameterSpec(int version, int rounds, int wordSize, byte[] iv, int offset) {
        this.version = version;
        this.rounds = rounds;
        this.wordSize = wordSize;
        this.iv = new byte[2 * (wordSize / 8)];
        System.arraycopy(iv, offset, this.iv, 0, this.iv.length);
    }
}

