/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto.spec;

import java.security.spec.AlgorithmParameterSpec;

public class RC2ParameterSpec
implements AlgorithmParameterSpec {
    private final int bits;
    private final byte[] iv;

    public int getEffectiveKeyBits() {
        return this.bits;
    }

    public byte[] getIV() {
        return (byte[])this.iv.clone();
    }

    public RC2ParameterSpec(int effectiveKeyBits) {
        this.bits = effectiveKeyBits;
        this.iv = null;
    }

    public RC2ParameterSpec(int effectiveKeyBits, byte[] iv) {
        this.bits = effectiveKeyBits;
        this.iv = iv;
    }

    public RC2ParameterSpec(int effectiveKeyBits, byte[] iv, int offset) {
        this.bits = effectiveKeyBits;
        this.iv = new byte[8];
        System.arraycopy(iv, offset, this.iv, 0, this.iv.length);
    }
}

