/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;

final class Support {
    static Object[] getImplementation(String type, String algorithm) throws NoSuchAlgorithmException {
        try {
            Provider[] providers = Security.getProviders();
            if (providers == null || providers.length == 0) {
                throw new NoSuchAlgorithmException("No providers installed");
            }
            int i = 0;
            while (i < providers.length) {
                Object[] res = Support.getImplementation(type, algorithm, providers[i]);
                if (res != null) {
                    Object[] objectArray = res;
                    Object var3_6 = null;
                    return objectArray;
                }
                ++i;
            }
            throw new NoSuchAlgorithmException("Algorithm not found. [" + type + "." + algorithm + "]");
        }
        catch (Throwable throwable) {
            Object var3_7 = null;
            throw throwable;
        }
    }

    static Object[] getImplementation(String type, String algorithm, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        Provider p = Security.getProvider(provider);
        if (p == null) {
            throw new NoSuchProviderException("Provider not found. [" + provider + "]");
        }
        Object[] res = Support.getImplementation(type, algorithm, p);
        if (res != null) {
            return res;
        }
        throw new NoSuchAlgorithmException("Algorithm not found. [" + type + "." + algorithm + "]");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Object[] getImplementation(String algType, String algName, Provider p) {
        try {
            try {
                String class_name = p.getProperty("Alg.Alias." + algType + "." + algName);
                class_name = class_name == null ? p.getProperty(algType + "." + algName) : p.getProperty(algType + "." + class_name);
                if (class_name == null) {
                    return null;
                }
                Object[] res = new Object[]{Class.forName(class_name).newInstance(), p};
                return res;
            }
            catch (LinkageError e) {
                e.printStackTrace();
                return null;
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                return null;
            }
            catch (InstantiationException e) {
                e.printStackTrace();
                return null;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            return null;
        }
        catch (Throwable throwable) {
            Object var4_14 = null;
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    static String getClassName(String algType, String algName, Provider p) {
        void var3_3;
        String class_name = p.getProperty("Alg.Alias." + algType + "." + algName);
        class_name = class_name == null ? p.getProperty(algType + "." + algName) : p.getProperty(algType + "." + class_name);
        return var3_3;
    }

    Support() {
    }
}

