/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

public class SealedObject
implements Serializable {
    private byte[] encBuf;
    private byte[] encParams = null;
    private String sealAlgorithm;
    private String paramsAlgorithm;

    public final String getAlgorithm() {
        return this.sealAlgorithm;
    }

    public final Object getObject(Key key) throws IOException, ClassNotFoundException, NoSuchAlgorithmException, InvalidKeyException {
        Cipher c = null;
        AlgorithmParameters p = null;
        if (this.encParams != null) {
            AlgorithmParameters.getInstance(this.paramsAlgorithm);
            p.init(this.encParams);
        }
        try {
            c = Cipher.getInstance(this.sealAlgorithm);
            if (p != null) {
                c.init(2, key, p);
            } else {
                c.init(2, key);
            }
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new InvalidKeyException(e.getMessage());
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            // empty catch block
        }
        return this.deCrypt(c);
    }

    public final Object getObject(Key key, String provider) throws IOException, ClassNotFoundException, NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        Cipher c = null;
        AlgorithmParameters p = null;
        if (this.encParams != null) {
            AlgorithmParameters.getInstance(this.paramsAlgorithm, provider);
            p.init(this.encParams);
        }
        try {
            c = Cipher.getInstance(this.sealAlgorithm);
            if (p != null) {
                c.init(2, key, p);
            } else {
                c.init(2, key);
            }
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new InvalidKeyException(e.getMessage());
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            // empty catch block
        }
        return this.deCrypt(c);
    }

    /*
     * WARNING - void declaration
     */
    public final Object getObject(Cipher c) throws IOException, ClassNotFoundException, IllegalBlockSizeException, BadPaddingException {
        void var2_2;
        Object o = null;
        ByteArrayInputStream bais = null;
        ObjectInputStream ois = null;
        bais = new ByteArrayInputStream(c.doFinal(this.encBuf));
        try {
            ois = new ObjectInputStream(bais);
            o = ois.readObject();
        }
        catch (StreamCorruptedException e) {
            throw new IOException(e.getMessage());
        }
        catch (OptionalDataException e) {
            throw new IOException(e.getMessage());
        }
        catch (InvalidClassException e) {
            throw new IOException(e.getMessage());
        }
        ois.close();
        bais.close();
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private Object deCrypt(Cipher c) throws ClassNotFoundException, IOException {
        void var2_2;
        Object o = null;
        ByteArrayInputStream bais = null;
        ObjectInputStream ois = null;
        try {
            bais = new ByteArrayInputStream(c.doFinal(this.encBuf));
        }
        catch (BadPaddingException badPaddingException) {
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            // empty catch block
        }
        try {
            ois = new ObjectInputStream(bais);
            o = ois.readObject();
        }
        catch (StreamCorruptedException e) {
            throw new IOException(e.getMessage());
        }
        catch (OptionalDataException e) {
            throw new IOException(e.getMessage());
        }
        catch (InvalidClassException e) {
            throw new IOException(e.getMessage());
        }
        ois.close();
        bais.close();
        return var2_2;
    }

    public SealedObject(Serializable object, Cipher c) throws IOException, IllegalBlockSizeException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        try {
            oos.writeObject(object);
            oos.flush();
        }
        catch (InvalidClassException e) {
            throw new IOException(e.getMessage());
        }
        catch (NotSerializableException e) {
            throw new IOException(e.getMessage());
        }
        try {
            this.encBuf = c.doFinal(baos.toByteArray());
        }
        catch (BadPaddingException params) {
            // empty catch block
        }
        AlgorithmParameters params = c.getParameters();
        if (params != null) {
            this.encParams = params.getEncoded();
            this.paramsAlgorithm = params.getAlgorithm();
        }
        this.sealAlgorithm = c.getAlgorithm();
        oos.close();
        baos.close();
    }
}

