/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.MacSpi;
import javax.crypto.ShortBufferException;
import javax.crypto.Support;

public class Mac {
    private static final int STATE_UNDEFINED = 0;
    private static final int STATE_INITIALIZED = 1;
    private int state;
    private final MacSpi spi;
    private final Provider provider;
    private final String algorithm;

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public static final Mac getInstance(String algorithm) throws NoSuchAlgorithmException {
        Object[] o = Support.getImplementation("Mac", algorithm);
        return new Mac((MacSpi)o[0], (Provider)o[1], algorithm);
    }

    public static final Mac getInstance(String algorithm, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        Object[] o = Support.getImplementation("Mac", algorithm, provider);
        return new Mac((MacSpi)o[0], (Provider)o[1], algorithm);
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final int getMacLength() {
        return this.spi.engineGetMacLength();
    }

    public final void init(Key key) throws InvalidKeyException {
        try {
            this.spi.engineInit(key, null);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new InvalidKeyException("This Mac requires an AlgorithmParameterSpec");
        }
        this.state = 1;
    }

    public final void init(Key key, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.spi.engineInit(key, params);
        this.state = 1;
    }

    public final void update(byte input) throws IllegalStateException {
        if (this.state != 1) {
            throw new IllegalStateException();
        }
        this.spi.engineUpdate(input);
    }

    public final void update(byte[] input) throws IllegalStateException {
        if (this.state != 1) {
            throw new IllegalStateException();
        }
        this.spi.engineUpdate(input, 0, input.length);
    }

    public final void update(byte[] input, int offset, int len) throws IllegalStateException {
        if (this.state != 1) {
            throw new IllegalStateException();
        }
        this.spi.engineUpdate(input, offset, len);
    }

    /*
     * WARNING - void declaration
     */
    public final byte[] doFinal() throws IllegalStateException {
        void var1_1;
        if (this.state != 1) {
            throw new IllegalStateException();
        }
        byte[] res = this.spi.engineDoFinal();
        this.reset();
        return var1_1;
    }

    public final void doFinal(byte[] output, int outOffset) throws ShortBufferException, IllegalStateException {
        if (this.state != 1) {
            throw new IllegalStateException();
        }
        int my_len = this.getMacLength();
        if (output.length - outOffset < my_len) {
            throw new ShortBufferException("Buffer too short");
        }
        byte[] res = this.spi.engineDoFinal();
        System.arraycopy(res, 0, output, outOffset, my_len);
        this.reset();
    }

    public final byte[] doFinal(byte[] input) throws IllegalStateException {
        if (this.state != 1) {
            throw new IllegalStateException();
        }
        this.update(input);
        return this.doFinal();
    }

    public final void reset() {
        this.spi.engineReset();
    }

    public final Object clone() throws CloneNotSupportedException {
        MacSpi clone_spi = (MacSpi)this.spi.clone();
        return new Mac(clone_spi, this.provider, this.algorithm, this.state);
    }

    protected Mac(MacSpi macSpi, Provider provider, String algorithm) {
        this(macSpi, provider, algorithm, 0);
    }

    private Mac(MacSpi macSpi, Provider provider, String algorithm, int state) {
        this.spi = macSpi;
        this.provider = provider;
        this.algorithm = algorithm;
        this.state = state;
    }
}

