/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NullCipher;

public class CipherOutputStream
extends FilterOutputStream {
    private OutputStream os;
    private Cipher c;
    private byte[] encBuf;
    private byte[] ba = new byte[1];

    public void write(int b) throws IOException {
        this.ba[0] = (byte)b;
        this.write(this.ba, 0, 1);
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.encBuf = this.c.update(b, off, len);
        if (this.encBuf != null) {
            this.os.write(this.encBuf);
        }
    }

    public void flush() throws IOException {
        this.os.flush();
    }

    public void close() throws IOException {
        try {
            this.encBuf = this.c.doFinal();
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
        }
        catch (BadPaddingException badPaddingException) {
            // empty catch block
        }
        this.os.write(this.encBuf);
        this.os.flush();
        this.os.close();
    }

    public CipherOutputStream(OutputStream os, Cipher c) {
        super(os);
        this.os = os;
        this.c = c;
    }

    protected CipherOutputStream(OutputStream os) {
        this(os, new NullCipher());
    }
}

