/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NullCipher;

public class CipherInputStream
extends FilterInputStream {
    private int bufBegin = 0;
    private int bufEnd = 0;
    private boolean isClosed = false;
    private Cipher c;
    private byte[] encBuf;
    private byte[] rawBuf = null;
    private InputStream is;

    public int read() throws IOException {
        if (this.bufBegin >= this.bufEnd && this.doBuffering() == -1) {
            return -1;
        }
        return this.rawBuf[this.bufBegin++] & 0xFF;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.bufBegin >= this.bufEnd && this.doBuffering() == -1) {
            return -1;
        }
        if (len <= 0) {
            return 0;
        }
        int l = this.bufEnd - this.bufBegin;
        if (l > len) {
            l = len;
        }
        if (b != null) {
            int i = 0;
            while (i < l) {
                b[off + i] = this.rawBuf[this.bufBegin + i];
                ++i;
            }
        }
        this.bufBegin += l;
        return l;
    }

    /*
     * WARNING - void declaration
     */
    public long skip(long n) throws IOException {
        void var3_2;
        long i = this.bufEnd - this.bufBegin;
        if (i <= 0L || n <= 0L) {
            return 0L;
        }
        if (i < n) {
            i = n;
        }
        this.bufBegin += (int)i;
        return (long)var3_2;
    }

    public int available() throws IOException {
        return this.bufEnd - this.bufBegin;
    }

    public void close() throws IOException {
        this.is.close();
        this.doClose();
    }

    public boolean markSupported() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private int doBuffering() throws IOException {
        void var1_1;
        if (this.isClosed) {
            return -1;
        }
        int len = this.is.read(this.encBuf);
        if (len < 0) {
            this.doClose();
        } else {
            try {
                this.rawBuf = this.c.update(this.encBuf, 0, len);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        len = this.rawBuf.length;
        this.bufBegin = 0;
        this.bufEnd = len;
        return (int)var1_1;
    }

    private void doClose() {
        this.isClosed = true;
        try {
            this.rawBuf = this.c.doFinal();
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
        }
        catch (BadPaddingException badPaddingException) {
            // empty catch block
        }
    }

    public CipherInputStream(InputStream is, Cipher c) {
        super(is);
        this.c = c;
        this.is = is;
        this.encBuf = new byte[1024];
    }

    protected CipherInputStream(InputStream is) {
        this(is, new NullCipher());
    }
}

