#!/bin/bash

cmdline=$0
cd "$(dirname $cmdline)"
cmdline=$(basename $cmdline)



while [ -L "$cmdline" ]; do
	cmdline="$(readlink "$cmdline")"
done

cd "$(dirname $cmdline)"

# Go up one directory, this script is in (mercury program directory)/startup
cd ..

if [ ! -e ./lib ]; then
	echo "Mercury can't find it's libraries." >&2
	echo "Current working directory = $(pwd)" >&2
	exit 1
fi

JAVA_EXEC=java

# Check for unsupported JVMs
JAVA_CLIENT=`${JAVA_EXEC} -version 2>&1`
if [ "`echo ${JAVA_CLIENT} | grep Blackdown`" != "" ]; then
	echo "Mercury does not run on Blackdown Java." >&2
	echo "Please, make sure to have the Sun Java version 1.5 or later installed." >&2
	exit 1
fi
if [ "`echo ${JAVA_CLIENT} | grep libgcj`" != "" ]; then
	echo "Mercury does not run on GNU Java." >&2
	echo "Please, make sure to have the Sun Java version 1.5 or later installed." >&2
	exit 1
fi



if (pidof compiz &> /dev/null) || (pidof compiz.real &> /dev/null) || (pidof beryl &> /dev/null); then
	 echo "- Adding Compiz/beryl compatibility mode."
	 AWT_TOOLKIT=MToolkit
else
	 unset AWT_TOOLKIT
fi

# LD_PRELOAD=/usr/lib/libv4l/v4l1compat.so
# LD_PRELOAD=/usr/lib64/libv4l/v4l1compat.so  

for file in `ls lib`
do
   classpath="lib/$file:$classpath"
done

echo Starting Mercury now...

java -Djava.library.path=jni:jni/jmf -Xmx128m -classpath $classpath com.dMSN.Main $*
