/*
 * Decompiled with CFR 0.152.
 */
package net.java.stun4j.test;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketException;

public class BasicTest {
    String stunSerAddrStr = "stun01.sipphone.com";
    DatagramSocket sock = null;
    private byte[] bindingRequest = new byte[]{0, 1, 0, 8, 1, 2, 3, 4, 5, 6, 7, 8, 9, 16, 17, 18, 19, 20, 21, 22, 0, 3, 0, 4, 0, 0, 0, 0};
    private byte[] wrongBindingRequest = new byte[]{0, 1, 0, 7, 1, 2, 3, 4, 5, 6, 7, 8, 9, 16, 17, 18, 19, 20, 21, 22, 0, 3, 0, 4, 0, 0, 0, 6};

    public void sendBindingRequest() {
        try {
            InetSocketAddress stunSerAddr = new InetSocketAddress(this.stunSerAddrStr, 3478);
            DatagramPacket packet = new DatagramPacket(this.bindingRequest, 28, stunSerAddr);
            this.sock = new DatagramSocket();
            this.sock.send(packet);
        }
        catch (SocketException ex) {
            System.err.println("Failed to open a socket to " + this.stunSerAddrStr + ". " + ex.getMessage());
            ex.printStackTrace();
        }
        catch (IOException ex) {
            System.err.println("Failed to send the binding request to " + this.stunSerAddrStr + ". " + ex.getMessage());
            ex.printStackTrace();
        }
    }

    public void sendWrongBindingRequest() {
        try {
            InetSocketAddress stunSerAddr = new InetSocketAddress(this.stunSerAddrStr, 3478);
            DatagramPacket packet = new DatagramPacket(this.wrongBindingRequest, 28, stunSerAddr);
            this.sock = new DatagramSocket();
            this.sock.send(packet);
        }
        catch (SocketException ex) {
            System.err.println("Failed to open a socket to " + this.stunSerAddrStr + ". " + ex.getMessage());
            ex.printStackTrace();
        }
        catch (IOException ex) {
            System.err.println("Failed to send the binding request to " + this.stunSerAddrStr + ". " + ex.getMessage());
            ex.printStackTrace();
        }
    }

    public void receiveBindingResponse() {
        int attLen;
        byte[] responseData = new byte[512];
        DatagramPacket responsePacket = new DatagramPacket(responseData, 512);
        try {
            this.sock.receive(responsePacket);
        }
        catch (IOException ex) {
            System.err.println("Failed to receive a packet! " + ex.getMessage());
        }
        System.out.println("====================== Stun Header =============================");
        System.out.println("STUN Message Type: 0x" + this.byteToHex(responseData[0]) + this.byteToHex(responseData[1]));
        System.out.println("Message Length:    0x" + this.byteToHex(responseData[2]) + this.byteToHex(responseData[3]));
        System.out.println("Transaction ID:    0x" + this.byteToHex(responseData[4]) + this.byteToHex(responseData[5]) + this.byteToHex(responseData[6]) + this.byteToHex(responseData[7]) + this.byteToHex(responseData[8]) + this.byteToHex(responseData[9]) + this.byteToHex(responseData[10]) + this.byteToHex(responseData[11]) + this.byteToHex(responseData[12]) + this.byteToHex(responseData[13]) + this.byteToHex(responseData[14]) + this.byteToHex(responseData[15]) + this.byteToHex(responseData[16]) + this.byteToHex(responseData[17]) + this.byteToHex(responseData[18]) + this.byteToHex(responseData[19]));
        System.out.println("====================== Attributes ==============================");
        for (int i = 20; i < responsePacket.getLength(); i += attLen) {
            int attLen1 = 0;
            byte attLen2 = 0;
            System.out.println("Attribute Type:   0x" + this.byteToHex(responseData[i++]) + this.byteToHex(responseData[i++]));
            byte by = responseData[i++];
            attLen2 = by;
            attLen2 = responseData[i++];
            System.out.println("Attribute Length: 0x" + this.byteToHex(by) + this.byteToHex(attLen2));
            attLen = (attLen1 << 8) + attLen2;
            for (int j = 0; j < attLen; ++j) {
                System.out.println("    data[" + j + "]=" + (responseData[j + i] & 0xFF));
            }
        }
    }

    private String byteToHex(byte b) {
        return (b < 15 ? "0" : "") + Integer.toHexString(b & 0xFF).toUpperCase();
    }

    public static void main(String[] args) {
        BasicTest basicTest = new BasicTest();
        basicTest.sendBindingRequest();
        basicTest.receiveBindingResponse();
        basicTest.sendWrongBindingRequest();
        basicTest.receiveBindingResponse();
    }
}

