/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import gov.nist.core.InternalErrorHandler;
import gov.nist.core.LogWriter;
import gov.nist.core.NameValueList;
import gov.nist.javax.sip.NistSipMessageHandlerImpl;
import gov.nist.javax.sip.address.AddressImpl;
import gov.nist.javax.sip.address.GenericURI;
import gov.nist.javax.sip.address.SipUri;
import gov.nist.javax.sip.header.CSeq;
import gov.nist.javax.sip.header.Contact;
import gov.nist.javax.sip.header.ContactList;
import gov.nist.javax.sip.header.From;
import gov.nist.javax.sip.header.RecordRoute;
import gov.nist.javax.sip.header.RecordRouteList;
import gov.nist.javax.sip.header.RequestLine;
import gov.nist.javax.sip.header.Route;
import gov.nist.javax.sip.header.RouteList;
import gov.nist.javax.sip.header.To;
import gov.nist.javax.sip.header.Via;
import gov.nist.javax.sip.message.SIPMessage;
import gov.nist.javax.sip.message.SIPRequest;
import gov.nist.javax.sip.message.SIPResponse;
import gov.nist.javax.sip.stack.HopImpl;
import gov.nist.javax.sip.stack.MessageChannel;
import gov.nist.javax.sip.stack.MessageProcessor;
import gov.nist.javax.sip.stack.PendingRecord;
import gov.nist.javax.sip.stack.SIPClientTransaction;
import gov.nist.javax.sip.stack.SIPServerTransaction;
import gov.nist.javax.sip.stack.SIPTransaction;
import gov.nist.javax.sip.stack.SIPTransactionStack;
import gov.nist.javax.sip.stack.TCPMessageChannel;
import java.io.IOException;
import java.text.ParseException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.TimerTask;
import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.DialogState;
import javax.sip.InvalidArgumentException;
import javax.sip.SipException;
import javax.sip.Transaction;
import javax.sip.TransactionDoesNotExistException;
import javax.sip.address.Address;
import javax.sip.address.Hop;
import javax.sip.header.CallIdHeader;
import javax.sip.message.Request;

public class SIPDialog
implements Dialog,
PendingRecord {
    private boolean reInviteFlag;
    private Object applicationData;
    private SIPRequest originalRequest;
    private SIPTransaction firstTransaction;
    private SIPTransaction lastTransaction;
    private String dialogId;
    private int localSequenceNumber = 0;
    private int remoteSequenceNumber = -1;
    private String myTag;
    private String hisTag;
    private RouteList routeList;
    private Route contactRoute;
    private String user;
    private Route defaultRoute;
    private SIPTransactionStack sipStack;
    private int dialogState = -1;
    private boolean ackSeen;
    protected SIPRequest lastAck;
    protected boolean ackProcessed;
    protected DialogTimerTask timerTask;
    protected Integer nextSeqno;
    protected static final int WINDOW_SIZE = 8;
    protected Hashtable pendingRecords = new Hashtable();
    private int retransmissionTicksLeft;
    private int prevRetransmissionTicks;
    protected boolean inPendingQueue;
    private int ackLine;
    private GenericURI requestURI;
    protected Address localParty;
    protected Address remoteParty;
    protected CallIdHeader callIdHeader;
    public static final int EARLY_STATE = 0;
    public static final int CONFIRMED_STATE = 1;
    public static final int COMPLETED_STATE = 2;
    public static final int TERMINATED_STATE = 3;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putPending(NistSipMessageHandlerImpl pendingRecord, int seqno) {
        boolean toInsert = false;
        Hashtable hashtable = this.pendingRecords;
        synchronized (hashtable) {
            if (this.nextSeqno != null && seqno > this.nextSeqno + 8) {
                return;
            }
            if (this.pendingRecords.containsKey(new Integer(seqno))) {
                return;
            }
            this.pendingRecords.put(new Integer(seqno), pendingRecord);
            toInsert = true;
        }
        if (toInsert) {
            this.sipStack.putPending(this);
        }
    }

    public void setApplicationData(Object applicationData) {
        this.applicationData = applicationData;
    }

    public Object getApplicationData() {
        return this.applicationData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestConsumed() {
        boolean toNotify = false;
        this.nextSeqno = new Integer(this.getRemoteSequenceNumber() + 1);
        Hashtable hashtable = this.pendingRecords;
        synchronized (hashtable) {
            if (this.pendingRecords.containsKey(this.nextSeqno)) {
                toNotify = true;
            }
        }
        if (toNotify) {
            this.sipStack.notifyPendingRecordScanner();
        }
    }

    public boolean isRequestConsumable(SIPRequest dialogRequest) {
        if (this.getRemoteSequenceNumber() == -1) {
            return true;
        }
        if (this.nextSeqno == null) {
            return false;
        }
        return this.nextSeqno.intValue() == dialogRequest.getCSeq().getSequenceNumber();
    }

    private void printRouteList() {
        if (LogWriter.needsLogging) {
            this.sipStack.logWriter.logMessage("this : " + this);
            this.sipStack.logWriter.logMessage("printRouteList : " + this.routeList.encode());
            if (this.contactRoute != null) {
                this.sipStack.logWriter.logMessage("contactRoute : " + this.contactRoute.encode());
            } else {
                this.sipStack.logWriter.logMessage("contactRoute : null");
            }
        }
    }

    public HopImpl getNextHop() throws SipException {
        int port;
        RouteList rl = this.getRouteList();
        SipUri sipUri = null;
        if (rl != null && !rl.isEmpty()) {
            Route route = (Route)this.getRouteList().getFirst();
            sipUri = (SipUri)route.getAddress().getURI();
        } else if (this.contactRoute != null && this.contactRoute.getAddress().getURI() instanceof SipUri) {
            sipUri = (SipUri)this.contactRoute.getAddress().getURI();
        } else {
            throw new SipException("No route found!");
        }
        String host = sipUri.getMAddrParam() != null ? sipUri.getMAddrParam() : sipUri.getHost();
        String transport = sipUri.getTransportParam();
        if (transport == null) {
            transport = "udp";
        }
        if ((port = sipUri.getPort()) == -1) {
            port = 5060;
        }
        return new HopImpl(host, port, transport);
    }

    public boolean isClientDialog() {
        SIPTransaction transaction = (SIPTransaction)this.getFirstTransaction();
        return transaction instanceof SIPClientTransaction;
    }

    public void setState(int state) {
        if (LogWriter.needsLogging) {
            this.sipStack.logWriter.logMessage("Setting dialog state for " + this);
            this.sipStack.logWriter.logStackTrace();
            if (state != -1 && state != this.dialogState && LogWriter.needsLogging) {
                this.sipStack.logWriter.logMessage("New dialog state is " + DialogState.getObject(state) + "dialogId = " + this.getDialogId());
            }
        }
        this.dialogState = state;
        if (state == 3) {
            this.sipStack.removeDialog(this);
            this.stopTimer();
            this.sipStack.removePending(this);
        }
    }

    public void printDebugInfo() {
        if (LogWriter.needsLogging) {
            this.sipStack.logWriter.logMessage("isServer = " + this.isServer());
            this.sipStack.logWriter.logMessage("localTag = " + this.getLocalTag());
            this.sipStack.logWriter.logMessage("remoteTag = " + this.getRemoteTag());
            this.sipStack.logWriter.logMessage("localSequenceNumer = " + this.getLocalSequenceNumber());
            this.sipStack.logWriter.logMessage("remoteSequenceNumer = " + this.getRemoteSequenceNumber());
            this.sipStack.logWriter.logMessage("ackLine:" + this.getRemoteTag() + " " + this.ackLine);
        }
    }

    public void ackReceived(SIPRequest sipRequest) {
        if (this.ackSeen) {
            return;
        }
        SIPServerTransaction tr = this.getInviteTransaction();
        if (tr != null && tr.getCSeq() == sipRequest.getCSeq().getSequenceNumber()) {
            this.ackSeen = true;
            this.lastAck = sipRequest;
            if (LogWriter.needsLogging) {
                this.sipStack.logWriter.logMessage("ackReceived for " + tr.getMethod());
                this.ackLine = this.sipStack.logWriter.lineCount;
                this.printDebugInfo();
            }
            this.setState(1);
        }
    }

    public boolean isAckSeen() {
        return this.ackSeen;
    }

    public SIPRequest getLastAck() {
        return this.lastAck;
    }

    public Transaction getFirstTransaction() {
        return this.firstTransaction;
    }

    public Iterator getRouteSet() {
        if (this.routeList == null) {
            return new LinkedList().listIterator();
        }
        return this.getRouteList().listIterator();
    }

    private synchronized RouteList getRouteList() {
        Route route;
        if (LogWriter.needsLogging) {
            this.sipStack.logWriter.logMessage("getRouteList " + this);
        }
        ListIterator li = this.routeList.listIterator(this.routeList.size());
        boolean flag = true;
        RouteList retval = new RouteList();
        while (li.hasPrevious()) {
            route = (Route)li.previous();
            String host = ((SipUri)route.getAddress().getURI()).getHost();
            int port = ((SipUri)route.getAddress().getURI()).getPort();
            if (port == -1) {
                port = 5060;
            }
            String transport = ((SipUri)route.getAddress().getURI()).getTransportParam();
            String sh = this.sipStack.getHostAddress();
            int tp = this.firstTransaction.getPort();
            if (flag && sh.equalsIgnoreCase(host) && port == tp) {
                flag = false;
                continue;
            }
            retval.addFirst(route.clone());
        }
        if (flag) {
            retval = new RouteList();
            li = this.routeList.listIterator();
            while (li.hasNext()) {
                route = (Route)li.next();
                retval.add(route.clone());
            }
        }
        if (LogWriter.needsLogging) {
            this.sipStack.logWriter.logMessage("----- ");
            this.sipStack.logWriter.logMessage("getRouteList for " + this);
            if (retval != null) {
                this.sipStack.logWriter.logMessage("RouteList = " + retval.encode());
            }
            this.sipStack.logWriter.logMessage("myRouteList = " + this.routeList.encode());
            this.sipStack.logWriter.logMessage("----- ");
        }
        return retval;
    }

    public void setStack(SIPTransactionStack sipStack) {
        this.sipStack = sipStack;
    }

    public void setDefaultRoute(Route defaultRoute) {
        this.defaultRoute = (Route)defaultRoute.clone();
    }

    public void setUser(String user) {
        this.user = user;
    }

    private void addRoute(RecordRouteList recordRouteList) {
        if (this.isClientDialog()) {
            this.routeList = new RouteList();
            ListIterator li = recordRouteList.listIterator(recordRouteList.size());
            while (li.hasPrevious()) {
                RecordRoute rr = (RecordRoute)li.previous();
                AddressImpl addr = (AddressImpl)rr.getAddress();
                Route route = new Route();
                route.setAddress((AddressImpl)((AddressImpl)rr.getAddress()).clone());
                route.setParameters((NameValueList)rr.getParameters().clone());
                this.routeList.add(route);
            }
        } else {
            this.routeList = new RouteList();
            ListIterator li = recordRouteList.listIterator();
            while (li.hasNext()) {
                RecordRoute rr = (RecordRoute)li.next();
                Route route = new Route();
                route.setAddress((AddressImpl)((AddressImpl)rr.getAddress()).clone());
                route.setParameters((NameValueList)rr.getParameters().clone());
                this.routeList.add(route);
            }
        }
    }

    private void addRoute(ContactList contactList) {
        if (contactList.size() == 0) {
            return;
        }
        Contact contact = (Contact)contactList.getFirst();
        Route route = new Route();
        route.setAddress((AddressImpl)((AddressImpl)contact.getAddress()).clone());
        this.contactRoute = route;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void addRoute(SIPMessage sipMessage) {
        block16: {
            block17: {
                try {
                    block19: {
                        block18: {
                            if (LogWriter.needsLogging) {
                                this.sipStack.logWriter.logMessage("addRoute: dialogState: " + this + "state = " + this.getState());
                            }
                            if (this.dialogState == 1 || this.dialogState == 2) break block18;
                            if (this.dialogState != 3) break block19;
                        }
                        Object var6_2 = null;
                        if (!LogWriter.needsLogging) return;
                        this.sipStack.logWriter.logStackTrace();
                        this.sipStack.logWriter.logMessage("added a route = " + this.routeList.encode() + "contactRoute = " + this.contactRoute);
                        return;
                    }
                    if (!this.isServer()) {
                        if (!(sipMessage instanceof SIPResponse)) break block16;
                        SIPResponse sipResponse = (SIPResponse)sipMessage;
                        if (sipResponse.getStatusCode() == 100) {
                            break block17;
                        }
                        RecordRouteList rrlist = sipMessage.getRecordRouteHeaders();
                        if (rrlist != null) {
                            this.addRoute(rrlist);
                        } else {
                            this.routeList = new RouteList();
                        }
                        ContactList contactList = sipMessage.getContactHeaders();
                        if (contactList != null) {
                            this.addRoute(contactList);
                        }
                        break block16;
                    }
                    if (!(sipMessage instanceof SIPRequest)) break block16;
                    RecordRouteList rrlist = sipMessage.getRecordRouteHeaders();
                    if (rrlist != null) {
                        this.addRoute(rrlist);
                    } else {
                        this.routeList = new RouteList();
                    }
                    ContactList contactList = sipMessage.getContactHeaders();
                    if (contactList != null) {
                        this.addRoute(contactList);
                    }
                    break block16;
                }
                catch (Throwable throwable) {
                    Object var6_5 = null;
                    if (!LogWriter.needsLogging) throw throwable;
                    this.sipStack.logWriter.logStackTrace();
                    this.sipStack.logWriter.logMessage("added a route = " + this.routeList.encode() + "contactRoute = " + this.contactRoute);
                    throw throwable;
                }
            }
            Object var6_3 = null;
            if (!LogWriter.needsLogging) return;
            this.sipStack.logWriter.logStackTrace();
            this.sipStack.logWriter.logMessage("added a route = " + this.routeList.encode() + "contactRoute = " + this.contactRoute);
            return;
        }
        Object var6_4 = null;
        if (!LogWriter.needsLogging) return;
        this.sipStack.logWriter.logStackTrace();
        this.sipStack.logWriter.logMessage("added a route = " + this.routeList.encode() + "contactRoute = " + this.contactRoute);
    }

    protected SIPDialog() {
        this.routeList = new RouteList();
    }

    public void setDialogId(String dialogId) {
        this.dialogId = dialogId;
    }

    protected SIPDialog(SIPTransaction transaction) {
        this();
        this.sipStack = transaction.sipStack;
        this.addTransaction(transaction);
    }

    public boolean isServer() {
        return this.firstTransaction instanceof SIPServerTransaction;
    }

    protected boolean isReInvite() {
        return this.reInviteFlag;
    }

    public String getDialogId() {
        if (this.firstTransaction instanceof SIPServerTransaction) {
            if (this.originalRequest != null) {
                this.dialogId = this.originalRequest.getDialogId(true, this.myTag);
            }
        } else if (this.getFirstTransaction() != null && ((SIPClientTransaction)this.getFirstTransaction()).getLastResponse() != null) {
            this.dialogId = ((SIPClientTransaction)this.firstTransaction).getLastResponse().getDialogId(false, this.hisTag);
        }
        return this.dialogId;
    }

    public void addTransaction(SIPTransaction transaction) {
        SIPRequest sipRequest = transaction.getOriginalRequest();
        if (this.firstTransaction != null && this.firstTransaction != transaction && transaction.getMethod().equals(this.firstTransaction.getMethod())) {
            this.reInviteFlag = true;
        }
        if (sipRequest.getMethod().equals("BYE")) {
            this.setState(2);
        }
        if (this.firstTransaction == null) {
            this.firstTransaction = transaction;
            this.setLocalParty(sipRequest);
            this.setRemoteParty(sipRequest);
            this.setCallId(sipRequest);
            this.originalRequest = sipRequest;
            if (transaction instanceof SIPServerTransaction) {
                this.hisTag = sipRequest.getFrom().getTag();
            } else {
                this.setLocalSequenceNumber(sipRequest.getCSeq().getSequenceNumber());
                this.myTag = sipRequest.getFrom().getTag();
                if (this.myTag == null) {
                    throw new RuntimeException("bad message tag missing!");
                }
            }
        } else if (transaction.getMethod().equals(this.firstTransaction.getMethod()) && (this.firstTransaction instanceof SIPServerTransaction && transaction instanceof SIPClientTransaction || this.firstTransaction instanceof SIPClientTransaction && transaction instanceof SIPServerTransaction)) {
            this.firstTransaction = transaction;
            this.setLocalParty(sipRequest);
            this.setRemoteParty(sipRequest);
            this.setCallId(sipRequest);
            this.originalRequest = sipRequest;
        }
        if (transaction instanceof SIPServerTransaction) {
            this.setRemoteSequenceNumber(sipRequest.getCSeq().getSequenceNumber());
        }
        this.lastTransaction = transaction;
        transaction.setDialog(this);
        if (LogWriter.needsLogging) {
            this.sipStack.logWriter.logMessage("Transaction Added " + this + this.myTag + "/" + this.hisTag);
            this.sipStack.logWriter.logMessage("TID = " + transaction.getTransactionId() + "/" + transaction.IsServerTransaction());
            this.sipStack.logWriter.logStackTrace();
        }
    }

    public void setRemoteTag(String hisTag) {
        this.hisTag = hisTag;
    }

    public SIPTransaction getLastTransaction() {
        return this.lastTransaction;
    }

    public SIPServerTransaction getInviteTransaction() {
        if (this.timerTask != null) {
            return this.timerTask.transaction;
        }
        return null;
    }

    protected void setLocalSequenceNumber(int lCseq) {
        this.localSequenceNumber = lCseq;
    }

    private void setRemoteSequenceNumber(int rCseq) {
        if (LogWriter.needsLogging) {
            this.sipStack.logWriter.logMessage("setRemoteSeqno " + this + "/" + rCseq);
        }
        this.remoteSequenceNumber = rCseq;
    }

    public void incrementLocalSequenceNumber() {
        ++this.localSequenceNumber;
    }

    public int getRemoteSequenceNumber() {
        return this.remoteSequenceNumber;
    }

    public int getLocalSequenceNumber() {
        return this.localSequenceNumber;
    }

    public String getLocalTag() {
        return this.myTag;
    }

    public String getRemoteTag() {
        return this.hisTag;
    }

    public void setLocalTag(String mytag) {
        if (LogWriter.needsLogging) {
            this.sipStack.logWriter.logMessage("set Local tag " + mytag + " " + this.dialogId);
            this.sipStack.logWriter.logStackTrace();
        }
        this.myTag = mytag;
    }

    protected void deleteTransactions() {
        this.firstTransaction = null;
        this.lastTransaction = null;
    }

    public void delete() {
        this.setState(3);
    }

    public CallIdHeader getCallId() {
        return this.callIdHeader;
    }

    private void setCallId(SIPRequest sipRequest) {
        this.callIdHeader = sipRequest.getCallId();
    }

    public Address getLocalParty() {
        return this.localParty;
    }

    private void setLocalParty(SIPRequest sipRequest) {
        this.localParty = !this.isServer() ? sipRequest.getFrom().getAddress() : sipRequest.getTo().getAddress();
    }

    public Address getRemoteParty() {
        return this.remoteParty;
    }

    private void setRemoteParty(SIPRequest sipRequest) {
        this.remoteParty = !this.isServer() ? sipRequest.getTo().getAddress() : sipRequest.getFrom().getAddress();
    }

    public Address getRemoteTarget() {
        if (this.contactRoute == null) {
            return null;
        }
        return this.contactRoute.getAddress();
    }

    public DialogState getState() {
        if (this.dialogState == -1) {
            return null;
        }
        return DialogState.getObject(this.dialogState);
    }

    public boolean isSecure() {
        return this.getFirstTransaction().getRequest().getRequestURI().getScheme().equalsIgnoreCase("sips");
    }

    public void sendAck(Request request) throws SipException {
        SIPRequest ackRequest = (SIPRequest)request;
        if (LogWriter.needsLogging) {
            this.sipStack.logWriter.logMessage("sendAck" + this);
        }
        if (!ackRequest.getMethod().equals("ACK") && !ackRequest.getMethod().equals("PRACK")) {
            throw new SipException("Bad request method -- should be ACK");
        }
        if (ackRequest.getMethod().equals("ACK") && (this.getState() == null || this.getState().getValue() == 0)) {
            throw new SipException("Bad dialog state " + this.getState());
        }
        if (ackRequest.getMethod().equals("PRACK") && this.getState() == null) {
            throw new SipException("Bad dialog state sending PRACK" + this.getState());
        }
        if (ackRequest.getMethod().equals("PRACK") && this.getState().getValue() == 0) {
            this.setState(1);
        }
        if (!this.getCallId().getCallId().equals(((SIPRequest)request).getCallId().getCallId())) {
            throw new SipException("Bad call ID in request");
        }
        try {
            if (LogWriter.needsLogging) {
                this.sipStack.logWriter.logMessage("setting from tag For outgoing ACK= " + this.getLocalTag());
                this.sipStack.logWriter.logMessage("setting To tag for outgoing ACK = " + this.getRemoteTag());
            }
            if (this.getLocalTag() != null) {
                ackRequest.getFrom().setTag(this.getLocalTag());
            }
            if (this.getRemoteTag() != null) {
                ackRequest.getTo().setTag(this.getRemoteTag());
            }
        }
        catch (ParseException ex) {
            throw new SipException(ex.getMessage());
        }
        if (ackRequest.getHeader("Route") == null) {
            RouteList rl = this.getRouteList();
            if (rl.size() > 0) {
                Route route = (Route)rl.getFirst();
                SipUri sipUri = (SipUri)route.getAddress().getURI();
                if (sipUri.hasLrParam()) {
                    ackRequest.setRequestURI(this.getRemoteTarget().getURI());
                    ackRequest.addHeader(rl);
                } else {
                    rl.removeFirst();
                    ackRequest.setRequestURI(sipUri);
                    if (rl.size() > 0) {
                        ackRequest.addHeader(rl);
                    }
                    if (this.contactRoute != null) {
                        ackRequest.addHeader(this.contactRoute);
                    }
                }
            } else if (this.getRemoteTarget() != null) {
                ackRequest.setRequestURI(this.getRemoteTarget().getURI());
            }
        }
        HopImpl hop = this.getNextHop();
        try {
            MessageChannel messageChannel = this.sipStack.createRawMessageChannel(hop);
            if (messageChannel == null) {
                Hop outboundProxy = this.sipStack.getRouter().getOutboundProxy();
                if (outboundProxy == null) {
                    throw new SipException("No route found!");
                }
                messageChannel = this.sipStack.createRawMessageChannel(outboundProxy);
            }
            SIPClientTransaction clientTransaction = (SIPClientTransaction)this.sipStack.createMessageChannel(messageChannel);
            clientTransaction.setOriginalRequest(ackRequest);
            clientTransaction.sendMessage(ackRequest);
            this.lastAck = ackRequest;
            clientTransaction.setState(SIPTransaction.TERMINATED_STATE);
        }
        catch (Exception ex) {
            if (LogWriter.needsLogging) {
                this.sipStack.logWriter.logException(ex);
            }
            throw new SipException("Cold not create message channel");
        }
    }

    public Request createRequest(String method) throws SipException {
        if (method == null) {
            throw new NullPointerException("null method");
        }
        if (this.getState() == null || this.getState().getValue() == 3 && !method.equalsIgnoreCase("BYE") || this.isServer() && this.getState().getValue() == 0 && method.equalsIgnoreCase("BYE")) {
            throw new SipException("Dialog  " + this.getDialogId() + " not yet established or terminated " + this.getState());
        }
        RequestLine requestLine = new RequestLine();
        requestLine.setUri((GenericURI)this.getRemoteParty().getURI());
        requestLine.setMethod(method);
        SIPRequest sipRequest = this.originalRequest.createSIPRequest(requestLine, this.isServer());
        try {
            if (!method.equals("ACK")) {
                CSeq cseq = (CSeq)sipRequest.getCSeq();
                cseq.setSequenceNumber(this.localSequenceNumber + 1);
            } else {
                SIPTransaction transaction = this.lastTransaction;
                if (transaction == null) {
                    throw new SipException("Could not create ack!");
                }
                SIPResponse response = this.lastTransaction.getLastResponse();
                if (response == null) {
                    throw new SipException("Could not find response!");
                }
                int seqno = response.getCSeq().getSequenceNumber();
                CSeq cseq = (CSeq)sipRequest.getCSeq();
                cseq.setSequenceNumber(seqno);
            }
        }
        catch (InvalidArgumentException ex) {
            InternalErrorHandler.handleException(ex);
        }
        if (this.isServer()) {
            sipRequest.removeHeader("Via");
            MessageProcessor messageProcessor = this.sipStack.getMessageProcessor(this.firstTransaction.encapsulatedChannel.getTransport());
            Via via = messageProcessor.getViaHeader();
            sipRequest.addHeader(via);
        }
        From from = (From)sipRequest.getFrom();
        To to = (To)sipRequest.getTo();
        try {
            if (this.getLocalTag() != null) {
                from.setTag(this.getLocalTag());
            }
            if (this.getRemoteTag() != null) {
                to.setTag(this.getRemoteTag());
            }
        }
        catch (ParseException ex) {
            InternalErrorHandler.handleException(ex);
        }
        RouteList rl = this.getRouteList();
        if (rl.size() > 0) {
            Route route = (Route)rl.getFirst();
            SipUri sipUri = (SipUri)route.getAddress().getURI();
            if (sipUri.hasLrParam()) {
                if (this.getRemoteTarget() != null) {
                    sipRequest.setRequestURI(this.getRemoteTarget().getURI());
                }
                sipRequest.addHeader(rl);
            } else {
                rl.removeFirst();
                sipRequest.setRequestURI(sipUri);
                if (rl.size() > 0) {
                    sipRequest.addHeader(rl);
                }
                if (this.contactRoute != null) {
                    sipRequest.addHeader(this.contactRoute);
                }
            }
        } else if (this.getRemoteTarget() != null) {
            sipRequest.setRequestURI(this.getRemoteTarget().getURI());
        }
        try {
            if (sipRequest.getRequestURI() instanceof SipUri) {
                ((SipUri)sipRequest.getRequestURI()).setTransportParam(sipRequest.getTopmostVia().getTransport());
            }
        }
        catch (ParseException ex) {
            // empty catch block
        }
        return sipRequest;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void sendRequest(ClientTransaction clientTransactionId) throws TransactionDoesNotExistException, SipException {
        HopImpl hop;
        SIPRequest dialogRequest = ((SIPClientTransaction)clientTransactionId).getOriginalRequest();
        if (clientTransactionId == null) {
            throw new NullPointerException("null parameter");
        }
        if (dialogRequest.getMethod().equals("ACK") || dialogRequest.getMethod().equals("CANCEL")) {
            throw new SipException("Bad Request Method. " + dialogRequest.getMethod());
        }
        if (this.getState() == null) {
            throw new SipException("Bad dialog state " + this.getState());
        }
        if (LogWriter.needsLogging) {
            this.sipStack.logWriter.logMessage("dialog.sendRequest  dialog = " + this + "\ndialogRequest = \n" + dialogRequest);
        }
        if (dialogRequest.getTopmostVia() == null) {
            Via via = ((SIPClientTransaction)clientTransactionId).getOutgoingViaHeader();
            dialogRequest.addHeader(via);
        }
        if (!this.getCallId().getCallId().equals(dialogRequest.getCallId().getCallId())) {
            throw new SipException("Bad call ID in request");
        }
        ((SIPClientTransaction)clientTransactionId).dialog = this;
        this.addTransaction((SIPTransaction)((Object)clientTransactionId));
        ((SIPClientTransaction)clientTransactionId).isMapped = true;
        From from = (From)dialogRequest.getFrom();
        To to = (To)dialogRequest.getTo();
        try {
            if (this.getLocalTag() != null) {
                from.setTag(this.getLocalTag());
            }
            if (this.getRemoteTag() != null) {
                to.setTag(this.getRemoteTag());
            }
        }
        catch (ParseException ex) {
            System.out.println("Huh??");
            ex.printStackTrace();
        }
        if (dialogRequest.getHeader("Route") == null) {
            RouteList rl = this.getRouteList();
            if (rl.size() > 0) {
                Route route = (Route)rl.getFirst();
                SipUri sipUri = (SipUri)route.getAddress().getURI();
                if (sipUri.hasLrParam()) {
                    dialogRequest.setRequestURI(this.getRemoteTarget().getURI());
                    dialogRequest.addHeader(rl);
                } else {
                    rl.removeFirst();
                    dialogRequest.setRequestURI(sipUri);
                    if (rl.size() > 0) {
                        dialogRequest.addHeader(rl);
                    }
                    if (this.contactRoute != null) {
                        dialogRequest.addHeader(this.contactRoute);
                    }
                }
            } else if (this.getRemoteTarget() != null) {
                dialogRequest.setRequestURI(this.getRemoteTarget().getURI());
            }
        }
        try {
            hop = this.getNextHop();
        }
        catch (SipException se) {
            Iterator iter = this.sipStack.getNextHop(dialogRequest);
            if (!iter.hasNext()) throw se;
            Hop h = (Hop)iter.next();
            hop = new HopImpl(h.getHost(), h.getPort(), h.getTransport());
        }
        try {
            TCPMessageChannel oldChannel = null;
            MessageChannel messageChannel = this.sipStack.createRawMessageChannel(hop);
            if (((SIPClientTransaction)clientTransactionId).encapsulatedChannel instanceof TCPMessageChannel) {
                oldChannel = (TCPMessageChannel)((SIPClientTransaction)clientTransactionId).encapsulatedChannel;
                if (oldChannel.isCached && !oldChannel.isRunning) {
                    oldChannel.uncache();
                }
                if (!this.sipStack.cacheClientConnections) {
                    --oldChannel.useCount;
                    if (LogWriter.needsLogging) {
                        this.sipStack.logWriter.logMessage("oldChannel: useCount " + oldChannel.useCount);
                    }
                }
            }
            ((SIPClientTransaction)clientTransactionId).encapsulatedChannel = messageChannel;
            if (messageChannel == null) {
                Hop outboundProxy = this.sipStack.getRouter().getOutboundProxy();
                if (outboundProxy == null) {
                    throw new SipException("No route found!");
                }
                messageChannel = this.sipStack.createRawMessageChannel(outboundProxy);
            }
            ((SIPClientTransaction)clientTransactionId).encapsulatedChannel = messageChannel;
            if (messageChannel != null && messageChannel instanceof TCPMessageChannel) {
                ++((TCPMessageChannel)messageChannel).useCount;
            }
            if (!this.sipStack.cacheClientConnections && oldChannel != null && oldChannel.useCount == 0) {
                oldChannel.close();
            }
        }
        catch (Exception ex) {
            if (!LogWriter.needsLogging) throw new SipException("Cold not create message channel");
            this.sipStack.logWriter.logException(ex);
            throw new SipException("Cold not create message channel");
        }
        try {
            ++this.localSequenceNumber;
            dialogRequest.getCSeq().setSequenceNumber(this.getLocalSequenceNumber());
        }
        catch (InvalidArgumentException ex) {
            ex.printStackTrace();
        }
        if (this.isServer()) {
            SIPServerTransaction serverTransaction = (SIPServerTransaction)this.getFirstTransaction();
            try {
                if (this.myTag != null) {
                    from.setTag(this.myTag);
                }
                if (this.hisTag != null) {
                    to.setTag(this.hisTag);
                }
            }
            catch (ParseException ex) {
                throw new SipException(ex.getMessage());
            }
            try {
                ((SIPClientTransaction)clientTransactionId).sendMessage(dialogRequest);
                if (!dialogRequest.getMethod().equals("BYE")) return;
                this.setState(2);
                return;
            }
            catch (IOException ex) {
                throw new SipException("error sending message");
            }
        }
        SIPClientTransaction clientTransaction = (SIPClientTransaction)this.getFirstTransaction();
        try {
            if (LogWriter.needsLogging) {
                this.sipStack.logWriter.logMessage("setting tags from " + this.getDialogId());
                this.sipStack.logWriter.logMessage("fromTag " + this.myTag);
                this.sipStack.logWriter.logMessage("toTag " + this.hisTag);
            }
            if (this.myTag != null) {
                from.setTag(this.myTag);
            }
            if (this.hisTag != null) {
                to.setTag(this.hisTag);
            }
        }
        catch (ParseException ex) {
            throw new SipException(ex.getMessage());
        }
        try {
            ((SIPClientTransaction)clientTransactionId).sendMessage(dialogRequest);
            if (!dialogRequest.getMethod().equalsIgnoreCase("BYE")) return;
            this.setState(2);
            return;
        }
        catch (IOException ex) {
            if (!LogWriter.needsLogging) throw new SipException("error sending message");
            this.sipStack.logWriter.logException(ex);
            throw new SipException("error sending message");
        }
    }

    protected boolean toRetransmitFinalResponse() {
        if (--this.retransmissionTicksLeft == 0) {
            this.prevRetransmissionTicks = this.retransmissionTicksLeft = 2 * this.prevRetransmissionTicks;
            return true;
        }
        return false;
    }

    protected void setRetransmissionTicks() {
        this.retransmissionTicksLeft = 1;
        this.prevRetransmissionTicks = 1;
    }

    public void resendAck() throws SipException {
        if (this.lastAck != null) {
            this.sendAck(this.lastAck);
        }
    }

    public boolean isInviteDialog() {
        return this.originalRequest.getMethod().equals("INVITE");
    }

    protected void startTimer(SIPServerTransaction transaction) {
        if (this.timerTask != null && this.timerTask.transaction == transaction) {
            this.sipStack.logMessage("Timer already running for " + this.getDialogId());
            return;
        }
        if (LogWriter.needsLogging) {
            this.sipStack.logMessage("Starting dialog timer for " + this.getDialogId());
        }
        this.ackSeen = false;
        if (this.timerTask != null) {
            this.timerTask.transaction = transaction;
        } else {
            this.timerTask = new DialogTimerTask(this, transaction);
            this.sipStack.timer.schedule((TimerTask)this.timerTask, 0L, 500L);
        }
        this.setRetransmissionTicks();
    }

    protected void stopTimer() {
        try {
            if (this.timerTask != null) {
                this.timerTask.cancel();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void clearPending() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasPending() {
        Hashtable hashtable = this.pendingRecords;
        synchronized (hashtable) {
            return this.nextSeqno != null && this.pendingRecords.containsKey(this.nextSeqno);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processPending() {
        NistSipMessageHandlerImpl msgHandler = null;
        Hashtable hashtable = this.pendingRecords;
        synchronized (hashtable) {
            msgHandler = (NistSipMessageHandlerImpl)this.pendingRecords.remove(this.nextSeqno);
            if (this.pendingRecords.size() != 0) {
                this.sipStack.putPending(this);
            }
        }
        if (msgHandler != null) {
            msgHandler.processPending();
        }
    }

    public class DialogTimerTask
    extends TimerTask {
        SIPDialog dialog;
        SIPTransactionStack stack;
        SIPServerTransaction transaction;

        public DialogTimerTask(SIPDialog dialog, SIPServerTransaction transaction) {
            this.dialog = dialog;
            this.stack = dialog.sipStack;
            this.transaction = transaction;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            SIPResponse response;
            if (LogWriter.needsLogging) {
                SIPDialog.this.sipStack.logMessage("Running dialog timer");
            }
            if (!this.dialog.ackSeen && (response = this.transaction.getLastResponse()).getStatusCode() == 200) {
                try {
                    if (((SIPDialog)SIPDialog.this).sipStack.retransmissionFilter && this.dialog.toRetransmitFinalResponse()) {
                        this.transaction.sendMessage(response);
                    }
                }
                catch (IOException ex) {
                    this.dialog.setState(3);
                }
                finally {
                    this.transaction.fireTimer();
                }
            }
            if (this.dialog.isAckSeen() || this.dialog.dialogState == 3) {
                this.cancel();
                this.dialog.timerTask = null;
            }
        }
    }
}

