/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import gov.nist.core.LogWriter;
import gov.nist.javax.sip.stack.SIPMessageStack;
import java.io.IOException;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Hashtable;

class IOHandler {
    private SIPMessageStack sipStack;
    private static String UDP = "udp";
    private static String TCP = "tcp";
    private Hashtable socketTable;

    protected static String makeKey(InetAddress addr, int port) {
        return addr.getHostAddress() + ":" + port;
    }

    protected IOHandler(SIPMessageStack sipStack) {
        this.sipStack = sipStack;
        this.socketTable = new Hashtable();
    }

    protected synchronized void putSocket(String key, Socket sock) {
        this.socketTable.put(key, sock);
    }

    private synchronized Socket getSocket(String key) {
        return (Socket)this.socketTable.get(key);
    }

    private void removeSocket(String key) {
        this.socketTable.remove(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeChunks(OutputStream outputStream, byte[] bytes, int length) throws IOException {
        OutputStream outputStream2 = outputStream;
        synchronized (outputStream2) {
            int chunksize = 8192;
            for (int p = 0; p < length; p += chunksize) {
                int chunk = p + chunksize < length ? chunksize : length - p;
                outputStream.write(bytes, p, chunk);
            }
        }
        outputStream.flush();
    }

    public Socket sendBytes(InetAddress inaddr, int contactPort, String transport, byte[] bytes, boolean retry) throws IOException {
        int retry_count = 0;
        int max_retry = retry ? 2 : 1;
        int length = bytes.length;
        if (LogWriter.needsLogging) {
            this.sipStack.logWriter.logMessage("sendBytes " + transport + " inAddr " + inaddr.getHostAddress() + " port = " + contactPort + " length = " + length);
        }
        if (transport.compareToIgnoreCase(TCP) == 0) {
            String key = IOHandler.makeKey(inaddr, contactPort);
            Socket clientSock = this.getSocket(key);
            while (retry_count < max_retry) {
                if (clientSock == null) {
                    if (LogWriter.needsLogging) {
                        this.sipStack.logWriter.logMessage("inaddr = " + inaddr);
                        this.sipStack.logWriter.logMessage("port = " + contactPort);
                    }
                    clientSock = new Socket(inaddr, contactPort);
                    OutputStream outputStream = clientSock.getOutputStream();
                    this.writeChunks(outputStream, bytes, length);
                    this.putSocket(key, clientSock);
                    break;
                }
                try {
                    OutputStream outputStream = clientSock.getOutputStream();
                    this.writeChunks(outputStream, bytes, length);
                    break;
                }
                catch (IOException ex) {
                    if (LogWriter.needsLogging) {
                        this.sipStack.logWriter.logException(ex);
                    }
                    this.removeSocket(key);
                    try {
                        clientSock.close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    clientSock = null;
                    ++retry_count;
                }
            }
            if (clientSock == null) {
                throw new IOException("Could not connect to " + inaddr + ":" + contactPort);
            }
            return clientSock;
        }
        DatagramSocket datagramSock = new DatagramSocket();
        datagramSock.connect(inaddr, contactPort);
        DatagramPacket dgPacket = new DatagramPacket(bytes, 0, length, inaddr, contactPort);
        datagramSock.send(dgPacket);
        datagramSock.close();
        return null;
    }

    public void closeAll() {
        Enumeration values = this.socketTable.elements();
        while (values.hasMoreElements()) {
            Socket s = (Socket)values.nextElement();
            try {
                s.close();
            }
            catch (IOException iOException) {}
        }
    }
}

