/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip;

import gov.nist.core.LogWriter;
import gov.nist.javax.sip.ListeningPointImpl;
import gov.nist.javax.sip.SipProviderImpl;
import gov.nist.javax.sip.SipStackImpl;
import gov.nist.javax.sip.address.SipUri;
import gov.nist.javax.sip.header.RetryAfter;
import gov.nist.javax.sip.header.Route;
import gov.nist.javax.sip.header.RouteList;
import gov.nist.javax.sip.message.SIPRequest;
import gov.nist.javax.sip.message.SIPResponse;
import gov.nist.javax.sip.stack.MessageChannel;
import gov.nist.javax.sip.stack.SIPClientTransaction;
import gov.nist.javax.sip.stack.SIPDialog;
import gov.nist.javax.sip.stack.SIPServerTransaction;
import gov.nist.javax.sip.stack.SIPTransaction;
import gov.nist.javax.sip.stack.SIPTransactionStack;
import gov.nist.javax.sip.stack.ServerRequestInterface;
import gov.nist.javax.sip.stack.ServerResponseInterface;
import java.io.IOException;
import javax.sip.ClientTransaction;
import javax.sip.InvalidArgumentException;
import javax.sip.RequestEvent;
import javax.sip.ResponseEvent;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.SipListener;
import javax.sip.TransactionState;

public class NistSipMessageHandlerImpl
implements ServerRequestInterface,
ServerResponseInterface {
    protected SIPTransaction transactionChannel;
    protected ListeningPointImpl listeningPoint;
    protected SipStackImpl sipStackImpl;
    private SIPRequest pendingRequest;
    private MessageChannel pendingMessageChannel;

    public void processPending() {
        this.processRequest(this.pendingRequest, this.pendingMessageChannel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void processRequest(SIPRequest sipRequest, MessageChannel incomingMessageChannel) {
        if (LogWriter.needsLogging) {
            this.sipStackImpl.logMessage("PROCESSING INCOMING REQUEST " + sipRequest.getFirstLine());
        }
        if (this.listeningPoint == null) {
            if (!LogWriter.needsLogging) return;
            this.sipStackImpl.logMessage("Dropping message: No listening point registered!");
            return;
        }
        SIPTransactionStack sipStack = (SIPTransactionStack)this.transactionChannel.getSIPStack();
        SipStackImpl sipStackImpl = (SipStackImpl)sipStack;
        SipProviderImpl sipProvider = this.listeningPoint.getProvider();
        if (sipProvider == null) {
            if (!LogWriter.needsLogging) return;
            sipStackImpl.logMessage("No provider - dropping !!");
            return;
        }
        SipListener sipListener = sipProvider.sipListener;
        if (sipRequest.getHeader("Route") != null) {
            RouteList routes = sipRequest.getRouteHeaders();
            Route route = (Route)routes.getFirst();
            SipUri uri = (SipUri)route.getAddress().getURI();
            int port = uri.getHostPort().hasPort() ? uri.getHostPort().getPort() : 5060;
            String host = uri.getHost();
            if (host.equals(this.listeningPoint.getHost()) && port == this.listeningPoint.getPort()) {
                if (routes.size() == 1) {
                    sipRequest.removeHeader("Route");
                } else {
                    routes.removeFirst();
                }
            }
        }
        SIPTransaction transaction = this.transactionChannel;
        SipProviderImpl sipProviderImpl = sipProvider;
        synchronized (sipProviderImpl) {
            RequestEvent sipEvent;
            SIPDialog dialog;
            String dialogId;
            block53: {
                block57: {
                    block55: {
                        SIPDialog dialog2;
                        block56: {
                            if (!sipRequest.getMethod().equalsIgnoreCase("ACK")) break block55;
                            dialogId = sipRequest.getDialogId(true);
                            dialog2 = sipStackImpl.getDialog(dialogId);
                            if (LogWriter.needsLogging) {
                                sipStackImpl.logMessage("Processing ACK for dialog " + dialog2);
                            }
                            if (dialog2 != null) break block56;
                            if (LogWriter.needsLogging) {
                                sipStackImpl.logMessage("Dialog does not exist " + sipRequest.getFirstLine() + " isServerTransaction = " + true);
                            }
                            transaction = sipStackImpl.findTransaction(sipRequest, true);
                            break block53;
                        }
                        if (dialog2.getLastAck() != null && dialog2.getLastAck().getCSeq().getSequenceNumber() == sipRequest.getCSeq().getSequenceNumber()) {
                            if (sipStackImpl.isRetransmissionFilterActive()) {
                                if (!LogWriter.needsLogging) return;
                                sipStackImpl.logMessage("Retransmission Filter enabled - dropping Ack retransmission");
                                return;
                            }
                            if (LogWriter.needsLogging) {
                                sipStackImpl.logMessage("ACK retransmission for 2XX response Sending ACK to the TU");
                            }
                            transaction.setDialog(dialog2);
                            break block53;
                        } else {
                            SIPResponse sipResponse;
                            SIPServerTransaction tr = dialog2.getInviteTransaction();
                            SIPResponse sIPResponse = sipResponse = tr != null ? tr.getLastResponse() : null;
                            if (tr != null && sipResponse != null && sipResponse.getStatusCode() / 100 == 2 && sipResponse.getCSeq().getMethod().equals("INVITE") && sipResponse.getCSeq().getSequenceNumber() == sipRequest.getCSeq().getSequenceNumber()) {
                                transaction.setDialog(dialog2);
                                dialog2.ackReceived(sipRequest);
                                sipStackImpl.logMessage("ACK for 2XX response --- sending to TU ");
                                break block53;
                            } else {
                                if (!LogWriter.needsLogging) return;
                                sipStackImpl.logMessage(" INVITE transaction not found  -- Discarding ACK");
                                return;
                            }
                        }
                    }
                    if (!sipRequest.getMethod().equals("BYE")) break block57;
                    transaction = this.transactionChannel;
                    if (transaction != null && ((SIPServerTransaction)transaction).isTransactionMapped()) {
                        SIPDialog dialog3;
                        dialogId = sipRequest.getDialogId(true);
                        if (LogWriter.needsLogging) {
                            sipStackImpl.logMessage("dialogId = " + dialogId);
                        }
                        if ((dialog3 = sipStackImpl.getDialog(dialogId)) != null) {
                            if (!dialog3.isRequestConsumable(sipRequest)) {
                                if (!LogWriter.needsLogging) return;
                                sipStackImpl.logMessage("Dropping bye  for " + dialogId);
                                return;
                            }
                            dialog3.addTransaction(transaction);
                        }
                        break block53;
                    } else if (transaction != null) {
                        dialogId = sipRequest.getDialogId(true);
                        SIPDialog dialog4 = sipStack.getDialog(dialogId);
                        if (dialog4 != null) {
                            if (!LogWriter.needsLogging) return;
                            sipStackImpl.logMessage("Dropping out of sequence BYE");
                            return;
                        }
                        transaction = null;
                    }
                    break block53;
                }
                if (sipRequest.getRequestLine().getMethod().equals("CANCEL")) {
                    SIPServerTransaction serverTransaction = (SIPServerTransaction)sipStack.findCancelTransaction(sipRequest, true);
                    if (serverTransaction == null) {
                        if (LogWriter.needsLogging) {
                            sipStackImpl.logMessage("transaction  does not exist " + sipRequest.getFirstLine() + "isServerTransaction = " + true);
                        }
                        transaction = null;
                    } else {
                        transaction = serverTransaction;
                    }
                } else if (sipRequest.getMethod().equals("INVITE")) {
                    SIPTransaction lastTransaction;
                    dialogId = sipRequest.getDialogId(true);
                    SIPDialog dialog5 = sipStack.getDialog(dialogId);
                    SIPTransaction sIPTransaction = lastTransaction = dialog5 == null ? null : dialog5.getInviteTransaction();
                    if (dialog5 != null && transaction != null && lastTransaction != null && sipRequest.getCSeq().getSequenceNumber() > dialog5.getRemoteSequenceNumber() && lastTransaction instanceof SIPServerTransaction && lastTransaction.isInviteTransaction() && lastTransaction.getState() != TransactionState.COMPLETED && lastTransaction.getState() != TransactionState.TERMINATED && lastTransaction.getState() != TransactionState.CONFIRMED) {
                        if (LogWriter.needsLogging) {
                            sipStackImpl.logMessage("Sending 500 response for out of sequence message");
                        }
                        SIPResponse sipResponse = sipRequest.createResponse(500);
                        RetryAfter retryAfter = new RetryAfter();
                        try {
                            retryAfter.setRetryAfter((int)(10.0 * Math.random()));
                        }
                        catch (InvalidArgumentException ex) {
                            ex.printStackTrace();
                        }
                        sipResponse.addHeader(retryAfter);
                        try {
                            transaction.sendMessage(sipResponse);
                        }
                        catch (IOException ex) {
                            // empty catch block
                        }
                        return;
                    }
                    SIPTransaction sIPTransaction2 = lastTransaction = dialog5 == null ? null : dialog5.getLastTransaction();
                    if (dialog5 != null && dialog5.getLastTransaction() != null && lastTransaction.isInviteTransaction() && lastTransaction instanceof SIPClientTransaction && lastTransaction.getState() != TransactionState.TERMINATED) {
                        if (LogWriter.needsLogging) {
                            sipStackImpl.logMessage("Sending 491 response for out of sequence message");
                        }
                        SIPResponse sipResponse = sipRequest.createResponse(491);
                        try {
                            transaction.sendMessage(sipResponse);
                        }
                        catch (IOException ex) {
                            // empty catch block
                        }
                        return;
                    }
                }
            }
            if (LogWriter.needsLogging) {
                sipStackImpl.logMessage("-----------------");
                sipStackImpl.logMessage(sipRequest.encodeMessage());
            }
            if (!((dialog = sipStackImpl.getDialog(dialogId = sipRequest.getDialogId(true))) == null || transaction == null || sipRequest.getMethod().equals("BYE") || sipRequest.getMethod().equals("CANCEL") || sipRequest.getMethod().equals("ACK"))) {
                if (dialog.getRemoteSequenceNumber() >= sipRequest.getCSeq().getSequenceNumber()) {
                    if (LogWriter.needsLogging) {
                        sipStackImpl.logMessage("Dropping out of sequence message " + dialog.getRemoteSequenceNumber() + " " + sipRequest.getCSeq());
                    }
                    if (dialog.getRemoteSequenceNumber() <= sipRequest.getCSeq().getSequenceNumber()) return;
                    if (LogWriter.needsLogging) {
                        sipStackImpl.logMessage("Sending 500 response for out of sequence message");
                    }
                    SIPResponse sipResponse = sipRequest.createResponse(500);
                    try {
                        transaction.sendMessage(sipResponse);
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                    return;
                }
                if (!dialog.isRequestConsumable(sipRequest)) {
                    if (LogWriter.needsLogging) {
                        sipStackImpl.logMessage("sequence number is too large - putting pending!");
                    }
                    this.pendingRequest = sipRequest;
                    this.pendingMessageChannel = incomingMessageChannel;
                    dialog.putPending(this, sipRequest.getCSeq().getSequenceNumber());
                    return;
                }
                dialog.addTransaction(transaction);
                dialog.addRoute(sipRequest);
            }
            if (dialog == null && sipRequest.getMethod().equals("NOTIFY")) {
                SIPClientTransaction ct = sipStack.findSubscribeTransaction(sipRequest);
                if (ct != null) {
                    transaction.setDialog((SIPDialog)ct.getDialog());
                    sipEvent = ct.getDialog().getState() == null ? new RequestEvent(sipProvider, null, sipRequest) : new RequestEvent(sipProvider, (ServerTransaction)((Object)transaction), sipRequest);
                } else {
                    sipEvent = new RequestEvent(sipProvider, null, sipRequest);
                }
            } else {
                sipEvent = transaction != null && ((SIPServerTransaction)transaction).isTransactionMapped() ? new RequestEvent(sipProvider, (ServerTransaction)((Object)transaction), sipRequest) : new RequestEvent(sipProvider, null, sipRequest);
            }
            sipProvider.handleEvent(sipEvent, transaction);
            return;
        }
    }

    public void processResponse(SIPResponse sipResponse, MessageChannel incomingMessageChannel) {
        SipStackImpl sipStack;
        if (LogWriter.needsLogging) {
            this.sipStackImpl.logMessage("PROCESSING INCOMING RESPONSE" + sipResponse.encodeMessage());
        }
        if (this.listeningPoint == null) {
            if (LogWriter.needsLogging) {
                this.sipStackImpl.logMessage("Dropping message: No listening point registered!");
            }
            return;
        }
        SIPTransaction transaction = this.transactionChannel;
        SipProviderImpl sipProvider = this.listeningPoint.getProvider();
        if (sipProvider == null) {
            if (LogWriter.needsLogging) {
                this.sipStackImpl.logMessage("Dropping message:  no provider");
            }
            return;
        }
        SipStackImpl sipStackImpl = sipStack = sipProvider.sipStackImpl;
        if (LogWriter.needsLogging) {
            sipStackImpl.logMessage("Transaction = " + transaction);
        }
        if (this.transactionChannel == null) {
            String dialogId = sipResponse.getDialogId(false);
            SIPDialog dialog = sipStack.getDialog(dialogId);
            if (sipProvider.sipListener == null) {
                return;
            }
            if (dialog != null) {
                if (sipResponse.getStatusCode() != 200) {
                    return;
                }
                if (sipStackImpl.isRetransmissionFilterActive() && sipResponse.getCSeq().getSequenceNumber() == ((SIPTransaction)dialog.getFirstTransaction()).getCSeq() && sipResponse.getCSeq().getMethod().equals(((SIPTransaction)dialog.getFirstTransaction()).getMethod())) {
                    try {
                        dialog.resendAck();
                        return;
                    }
                    catch (SipException ex) {
                        // empty catch block
                    }
                }
            }
            ResponseEvent sipEvent = new ResponseEvent(sipProvider, null, sipResponse);
            sipProvider.handleEvent(sipEvent, transaction);
            return;
        }
        SipListener sipListener = sipProvider.sipListener;
        ResponseEvent responseEvent = new ResponseEvent(sipProvider, (ClientTransaction)((Object)transaction), sipResponse);
        sipProvider.handleEvent(responseEvent, transaction);
    }

    public String getProcessingInfo() {
        return null;
    }
}

