/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sdp.fields;

import gov.nist.javax.sdp.fields.SDPField;
import gov.nist.javax.sdp.fields.SDPObjectList;
import gov.nist.javax.sdp.fields.TypedTime;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.sdp.RepeatTime;
import javax.sdp.SdpException;
import javax.sdp.SdpParseException;

public class RepeatField
extends SDPField
implements RepeatTime {
    protected TypedTime repeatInterval;
    protected TypedTime activeDuration;
    protected SDPObjectList offsets = new SDPObjectList();

    public RepeatField() {
        super("r=");
    }

    public void setRepeatInterval(TypedTime interval) {
        this.repeatInterval = interval;
    }

    public void setActiveDuration(TypedTime duration) {
        this.activeDuration = duration;
    }

    public void addOffset(TypedTime offset) {
        this.offsets.add(offset);
    }

    public LinkedList getOffsets() {
        return this.offsets;
    }

    public int getRepeatInterval() throws SdpParseException {
        if (this.repeatInterval == null) {
            return -1;
        }
        return this.repeatInterval.getTime();
    }

    public void setRepeatInterval(int repeatInterval) throws SdpException {
        if (repeatInterval < 0) {
            throw new SdpException("The repeat interval is <0");
        }
        if (this.repeatInterval == null) {
            this.repeatInterval = new TypedTime();
        }
        this.repeatInterval.setTime(repeatInterval);
    }

    public int getActiveDuration() throws SdpParseException {
        if (this.activeDuration == null) {
            return -1;
        }
        return this.activeDuration.getTime();
    }

    public void setActiveDuration(int activeDuration) throws SdpException {
        if (activeDuration < 0) {
            throw new SdpException("The active Duration is <0");
        }
        if (this.activeDuration == null) {
            this.activeDuration = new TypedTime();
        }
        this.activeDuration.setTime(activeDuration);
    }

    public int[] getOffsetArray() throws SdpParseException {
        LinkedList linkedList = this.getOffsets();
        int[] result = new int[linkedList.size()];
        for (int i = 0; i < linkedList.size(); ++i) {
            TypedTime typedTime = (TypedTime)linkedList.get(i);
            result[i] = typedTime.getTime();
        }
        return result;
    }

    public void setOffsetArray(int[] offsets) throws SdpException {
        for (int i = 0; i < offsets.length; ++i) {
            TypedTime typedTime = new TypedTime();
            typedTime.setTime(offsets[i]);
            this.addOffset(typedTime);
        }
    }

    public boolean getTypedTime() throws SdpParseException {
        return true;
    }

    public void setTypedTime(boolean typedTime) {
    }

    public String encode() {
        String retval = "r=" + this.repeatInterval.encode() + " " + this.activeDuration.encode();
        ListIterator li = this.offsets.listIterator();
        while (li.hasNext()) {
            TypedTime off = (TypedTime)li.next();
            retval = retval + " " + off.encode();
        }
        retval = retval + "\r\n";
        return retval;
    }
}

