<?xml version="1.0"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:variable name='HeaderStyle'>border-bottom:1 solid black</xsl:variable>

	<xsl:template match="EventLog">
		<html>
			<head>
				<title>Event log</title>
			</head>

			<body>
				<xsl:apply-templates select="Event">
					<xsl:sort select='TimeID' order='descending'/>
				</xsl:apply-templates>
			</body>
		</html>
	</xsl:template>

	<xsl:template match="Event">
		<xsl:value-of select="@Type"/> - <xsl:apply-templates select="Time"/> - 
		<xsl:if test="@Type='LOGIN'">
			<xsl:call-template name="LoginEvent"/>
		</xsl:if>
		<xsl:if test="@Type='LOGOUT'">
			<xsl:call-template name="LogoutEvent"/>
		</xsl:if>
		<xsl:if test="@Type='NAME_CHANGE'">
			<xsl:call-template name="NameChangeEvent"/>
		</xsl:if>
		<xsl:if test="@Type='MESSAGE'">
			<xsl:call-template name="MessageEvent"/>
		</xsl:if>

	</xsl:template>

	<xsl:template name="LoginEvent">
		<xsl:apply-templates select="Contact"/> signed in
		<br/>
	</xsl:template>

	<xsl:template name="MessageEvent">
		<xsl:apply-templates select="Contact"/> send a message
		<br/>
	</xsl:template>

	<xsl:template name="LogoutEvent">
		<xsl:apply-templates select="Contact"/> signed out<br/>
		<br/>
	</xsl:template>

	<xsl:template name="NameChangeEvent">
		<xsl:apply-templates select="Contact"/> changed name : <b><xsl:value-of select="Contact/@DisplayName"/></b>
		<br/>
	</xsl:template>

	<xsl:template match="Contact">
		<xsl:apply-templates select="@Alias"/>
	</xsl:template>

	<xsl:template match="Time">
		<xsl:value-of select="@Date"/> on
		<xsl:value-of select="@Time"/>
	</xsl:template>

</xsl:stylesheet>
