/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.util.gui;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Logger;

public class ColorFactory {
    private static final Logger logger = null;
    public static final Color TRANSPARENT = new Color(0, 0, 0, 0);
    private static ColorFactory instance;
    private final Map colorMap = new HashMap();
    private static final String RGB_START = "rgb(";
    static /* synthetic */ Class class$org$lobobrowser$util$gui$ColorFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ColorFactory() {
        Map colorMap = this.colorMap;
        ColorFactory colorFactory = this;
        synchronized (colorFactory) {
            colorMap.put("transparent", new Color(0, 0, 0, 0));
            colorMap.put("black", Color.black);
            colorMap.put("blue", Color.blue);
            colorMap.put("cyan", Color.cyan);
            colorMap.put("darkGray", Color.darkGray);
            colorMap.put("gray", Color.gray);
            colorMap.put("green", new Color(0, 100, 0));
            colorMap.put("magenta", Color.magenta);
            colorMap.put("orange", Color.orange);
            colorMap.put("pink", Color.pink);
            colorMap.put("red", Color.red);
            colorMap.put("white", Color.white);
            colorMap.put("yellow", Color.yellow);
            colorMap.put("grey", new Color(50, 100, 0));
            colorMap.put("brown", new Color(100, 50, 0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final ColorFactory getInstance() {
        if (instance == null) {
            Class clazz = class$org$lobobrowser$util$gui$ColorFactory == null ? (class$org$lobobrowser$util$gui$ColorFactory = ColorFactory.class$("org.lobobrowser.util.gui.ColorFactory")) : class$org$lobobrowser$util$gui$ColorFactory;
            synchronized (clazz) {
                if (instance == null) {
                    instance = new ColorFactory();
                }
            }
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isColor(String colorSpec) {
        if (colorSpec.startsWith("#")) {
            return true;
        }
        String normalSpec = colorSpec.toLowerCase();
        if (normalSpec.startsWith(RGB_START)) {
            return true;
        }
        ColorFactory colorFactory = this;
        synchronized (colorFactory) {
            return this.colorMap.containsKey(normalSpec);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Color getColor(String colorSpec) {
        String normalSpec = colorSpec.toLowerCase();
        ColorFactory colorFactory = this;
        synchronized (colorFactory) {
            Color color = (Color)this.colorMap.get(normalSpec);
            if (color == null) {
                if (normalSpec.startsWith(RGB_START)) {
                    int endIdx = normalSpec.lastIndexOf(41);
                    String commaValues = endIdx == -1 ? normalSpec.substring(RGB_START.length()) : normalSpec.substring(RGB_START.length(), endIdx);
                    StringTokenizer tok = new StringTokenizer(commaValues, ",");
                    int r10 = 0;
                    int g10 = 0;
                    int b10 = 0;
                    if (tok.hasMoreTokens()) {
                        String rstr = tok.nextToken().trim();
                        try {
                            r10 = Integer.parseInt(rstr);
                        }
                        catch (NumberFormatException nfe) {
                            // empty catch block
                        }
                        if (tok.hasMoreTokens()) {
                            String gstr = tok.nextToken().trim();
                            try {
                                g10 = Integer.parseInt(gstr);
                            }
                            catch (NumberFormatException nfe) {
                                // empty catch block
                            }
                            if (tok.hasMoreTokens()) {
                                String bstr = tok.nextToken().trim();
                                try {
                                    b10 = Integer.parseInt(bstr);
                                }
                                catch (NumberFormatException nfe) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                    color = new Color(r10, g10, b10);
                } else if (normalSpec.startsWith("#")) {
                    int len = normalSpec.length();
                    int[] rgba = new int[4];
                    rgba[3] = 255;
                    for (int i10 = 0; i10 < rgba.length; ++i10) {
                        int idx = 2 * i10 + 1;
                        if (idx >= len) continue;
                        String hexText = normalSpec.substring(idx, idx + Math.min(2, len - idx));
                        try {
                            rgba[i10] = Integer.parseInt(hexText, 16);
                            continue;
                        }
                        catch (NumberFormatException nfe) {
                            // empty catch block
                        }
                    }
                    color = new Color(rgba[0], rgba[1], rgba[2], rgba[3]);
                } else {
                    return Color.RED;
                }
                this.colorMap.put(normalSpec, color);
            }
            return color;
        }
    }

    static /* synthetic */ Class class$(String x02) {
        try {
            return Class.forName(x02);
        }
        catch (ClassNotFoundException x12) {
            throw new NoClassDefFoundError(x12.getMessage());
        }
    }
}

