/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.lobobrowser.util.ObjectFilter;

public class FilteredCollection
implements Collection {
    private final ObjectFilter filter;
    private final Collection sourceCollection;

    public FilteredCollection(Collection sourceCollection, ObjectFilter filter) {
        this.filter = filter;
        this.sourceCollection = sourceCollection;
    }

    public int size() {
        int count = 0;
        Iterator i10 = this.sourceCollection.iterator();
        while (i10.hasNext()) {
            if (this.filter.decode(i10.next()) == null) continue;
            ++count;
        }
        return count;
    }

    public boolean isEmpty() {
        Iterator i10 = this.sourceCollection.iterator();
        while (i10.hasNext()) {
            if (this.filter.decode(i10.next()) == null) continue;
            return false;
        }
        return true;
    }

    public boolean contains(Object o10) {
        return this.sourceCollection.contains(this.filter.encode(o10));
    }

    public Iterator iterator() {
        final Iterator sourceIterator = this.sourceCollection.iterator();
        return new Iterator(){
            private Boolean hasNext;
            private Object next;

            private void scanNext() {
                while (sourceIterator.hasNext()) {
                    Object item = FilteredCollection.this.filter.decode(sourceIterator.next());
                    if (item == null) continue;
                    this.hasNext = Boolean.TRUE;
                    this.next = item;
                }
                this.hasNext = Boolean.FALSE;
            }

            public boolean hasNext() {
                if (this.hasNext == null) {
                    this.scanNext();
                }
                return this.hasNext;
            }

            public Object next() {
                if (this.hasNext == null) {
                    this.scanNext();
                }
                if (Boolean.FALSE.equals(this.hasNext)) {
                    throw new NoSuchElementException();
                }
                Object next = this.next;
                this.hasNext = null;
                return next;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Object[] toArray() {
        return this.toArray(new Object[0]);
    }

    public Object[] toArray(Object[] a10) {
        ArrayList<Object> bucket = new ArrayList<Object>();
        Iterator i10 = this.sourceCollection.iterator();
        while (i10.hasNext()) {
            Object item = this.filter.decode(i10.next());
            if (item == null) continue;
            bucket.add(item);
        }
        return bucket.toArray(a10);
    }

    public boolean add(Object o10) {
        return this.sourceCollection.add(this.filter.encode(o10));
    }

    public boolean remove(Object o10) {
        return this.sourceCollection.remove(this.filter.encode(o10));
    }

    public boolean containsAll(Collection c10) {
        Iterator i10 = c10.iterator();
        while (i10.hasNext()) {
            if (this.contains(i10.next())) continue;
            return false;
        }
        return true;
    }

    public boolean addAll(Collection c10) {
        boolean result = false;
        Iterator i10 = c10.iterator();
        while (i10.hasNext()) {
            if (!this.add(i10.next())) continue;
            result = true;
        }
        return result;
    }

    public boolean removeAll(Collection c10) {
        boolean result = false;
        Iterator i10 = c10.iterator();
        while (i10.hasNext()) {
            if (!this.remove(i10.next())) continue;
            result = true;
        }
        return result;
    }

    public boolean retainAll(Collection c10) {
        boolean result = false;
        Object[] values = this.toArray();
        for (int i10 = 0; i10 < values.length; ++i10) {
            if (c10.contains(values[i10]) || !this.remove(values[i10])) continue;
            result = true;
        }
        return result;
    }

    public void clear() {
        Object[] values = this.toArray();
        for (int i10 = 0; i10 < values.length; ++i10) {
            this.sourceCollection.remove(this.filter.encode(values[i10]));
        }
    }
}

