/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.renderer;

import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;
import org.lobobrowser.html.domimpl.HTMLBaseInputElement;
import org.lobobrowser.html.domimpl.HTMLElementImpl;
import org.lobobrowser.html.renderer.BaseInputControl;
import org.lobobrowser.util.gui.WrapperLayout;

class InputRadioControl
extends BaseInputControl {
    private final JRadioButton widget;
    private ButtonGroup buttonGroup;

    public InputRadioControl(HTMLBaseInputElement modelNode) {
        super(modelNode);
        this.setLayout(WrapperLayout.getInstance());
        JRadioButton radio = new JRadioButton();
        radio.setOpaque(false);
        this.widget = radio;
        this.add(radio);
    }

    public void reset(int availWidth, int availHeight) {
        super.reset(availWidth, availHeight);
        HTMLElementImpl controlElement = this.controlElement;
        String name = controlElement.getAttribute("name");
        JRadioButton radio = this.widget;
        ButtonGroup prevGroup = this.buttonGroup;
        if (prevGroup != null) {
            prevGroup.remove(radio);
        }
        if (name != null) {
            String key = "cobra.radio.group." + name;
            ButtonGroup group = (ButtonGroup)controlElement.getDocumentItem(key);
            if (group == null) {
                group = new ButtonGroup();
                controlElement.setDocumentItem(key, group);
            }
            group.add(radio);
            this.buttonGroup = group;
        } else {
            this.buttonGroup = null;
        }
        String checkedText = controlElement.getAttribute("checked");
        radio.setSelected("checked".equalsIgnoreCase(checkedText));
    }

    public void click() {
        this.widget.doClick();
    }

    public boolean getChecked() {
        return this.widget.isSelected();
    }

    public void setChecked(boolean checked) {
        this.widget.setSelected(checked);
    }

    public void setDisabled(boolean disabled) {
        super.setDisabled(disabled);
        this.widget.setEnabled(!disabled);
    }

    public void resetInput() {
        String checkedText = this.controlElement.getAttribute("checked");
        this.widget.setSelected("checked".equalsIgnoreCase(checkedText));
    }

    public String getValue() {
        return this.controlElement.getAttribute("value");
    }
}

